/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.cache.impl;

import com.hazelcast.client.cache.impl.CallbackAwareClientDelegatingFuture;
import com.hazelcast.client.cache.impl.HazelcastClientCachingProvider;
import com.hazelcast.client.cache.impl.OneShotExecutionCallback;
import com.hazelcast.client.impl.ClientMessageDecoder;
import com.hazelcast.client.impl.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.HazelcastClientProxy;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.CacheGetCodec;
import com.hazelcast.client.spi.impl.ClientInvocation;
import com.hazelcast.client.spi.impl.ClientInvocationFuture;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.CacheConfig;
import com.hazelcast.config.CacheConfiguration;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.serialization.SerializationService;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.configuration.Configuration;
import javax.cache.configuration.Factory;
import javax.cache.integration.CacheLoader;
import javax.cache.integration.CacheLoaderException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class CallbackAwareClientDelegatingFutureTest
extends HazelcastTestSupport {
    private static final String CACHE_NAME = "MyCache";
    private static final ClientMessageDecoder CACHE_GET_RESPONSE_DECODER = new ClientMessageDecoder(){

        public <T> T decodeClientMessage(ClientMessage clientMessage) {
            return (T)CacheGetCodec.decodeResponse((ClientMessage)clientMessage).response;
        }
    };
    private TestHazelcastFactory factory;
    private HazelcastClientInstanceImpl client;

    @Before
    public void setup() {
        this.factory = new TestHazelcastFactory();
        this.factory.newHazelcastInstance();
        this.client = ((HazelcastClientProxy)this.factory.newHazelcastClient()).client;
    }

    @After
    public void tearDown() {
        this.factory.shutdownAll();
    }

    @Test
    public void test_CallbackAwareClientDelegatingFuture_when_noTimeOut_noError() throws ExecutionException, InterruptedException {
        this.test_CallbackAwareClientDelegatingFuture(false, false);
    }

    @Test
    public void test_CallbackAwareClientDelegatingFuture_when_timeOut_but_noError() throws ExecutionException, InterruptedException {
        this.test_CallbackAwareClientDelegatingFuture(true, false);
    }

    @Test
    public void test_CallbackAwareClientDelegatingFuture_when_noTimeOut_but_error() throws ExecutionException, InterruptedException {
        this.test_CallbackAwareClientDelegatingFuture(false, true);
    }

    private void test_CallbackAwareClientDelegatingFuture(boolean timeout, boolean error) throws ExecutionException, InterruptedException {
        if (timeout && error) {
            throw new IllegalArgumentException("Only one of the `timeout` and `error` parameters can be enabled at the same time!");
        }
        int timeoutMillis = timeout ? 5000 : -1;
        this.createCache(timeoutMillis, error);
        ClientMessage getRequest = this.createGetRequest(1);
        ClientMessageDecoder decoder = CACHE_GET_RESPONSE_DECODER;
        ClientInvocation invocation = new ClientInvocation(this.client, getRequest, 0);
        ClientInvocationFuture invocationFuture = invocation.invoke();
        final AtomicBoolean responseCalled = new AtomicBoolean();
        final AtomicBoolean failureCalled = new AtomicBoolean();
        OneShotExecutionCallback callback = new OneShotExecutionCallback(){

            protected void onResponseInternal(Object response) {
                responseCalled.set(true);
            }

            protected void onFailureInternal(Throwable t) {
                failureCalled.set(true);
            }
        };
        CallbackAwareClientDelegatingFuture callbackAwareInvocationFuture = new CallbackAwareClientDelegatingFuture(invocationFuture, this.client.getSerializationService(), decoder, callback);
        if (timeoutMillis > 0) {
            try {
                callbackAwareInvocationFuture.get((long)(timeoutMillis / 2), TimeUnit.MILLISECONDS);
                Assert.fail((String)"Timeout expected!");
            }
            catch (TimeoutException e) {
                Assert.assertTrue((boolean)failureCalled.get());
                Assert.assertFalse((boolean)responseCalled.get());
            }
        } else if (error) {
            try {
                callbackAwareInvocationFuture.get();
                Assert.fail((String)"CacheLoaderException expected!");
            }
            catch (ExecutionException e) {
                Assert.assertTrue((boolean)(e.getCause() instanceof CacheLoaderException));
                Assert.assertTrue((boolean)failureCalled.get());
                Assert.assertFalse((boolean)responseCalled.get());
            }
        } else {
            try {
                callbackAwareInvocationFuture.get();
                Assert.assertTrue((boolean)responseCalled.get());
                Assert.assertFalse((boolean)failureCalled.get());
            }
            catch (CacheLoaderException e) {
                Assert.fail((String)"CacheLoaderException not expected!");
            }
        }
    }

    private Cache createCache(int blockMilis, boolean throwError) {
        HazelcastClientCachingProvider cachingProvider = HazelcastClientCachingProvider.createCachingProvider((HazelcastInstance)this.client);
        CacheManager cacheManager = cachingProvider.getCacheManager();
        CacheConfiguration cacheConfig = new CacheConfig().setReadThrough(true).setCacheLoaderFactory((Factory)new BlockableCacheLoaderFactory(blockMilis, throwError));
        return cacheManager.createCache(CACHE_NAME, (Configuration)cacheConfig);
    }

    private ClientMessage createGetRequest(Integer key) {
        SerializationService serializationService = this.client.getSerializationService();
        Data keyData = serializationService.toData((Object)key);
        Data expiryPolicyData = serializationService.toData(null);
        String cacheNameWithPrefix = "/hz/MyCache";
        return CacheGetCodec.encodeRequest((String)cacheNameWithPrefix, (Data)keyData, (Data)expiryPolicyData);
    }

    public static class BlockableCacheLoader
    implements CacheLoader<Integer, String> {
        private final int blockMillis;
        private final boolean throwError;

        public BlockableCacheLoader(int blockMillis, boolean throwError) {
            this.blockMillis = blockMillis;
            this.throwError = throwError;
        }

        public String load(Integer key) throws CacheLoaderException {
            if (this.throwError) {
                throw new CacheLoaderException();
            }
            if (this.blockMillis > 0) {
                HazelcastTestSupport.sleepMillis((int)this.blockMillis);
            }
            return "Value-" + key;
        }

        public Map<Integer, String> loadAll(Iterable<? extends Integer> keys) throws CacheLoaderException {
            throw new UnsupportedOperationException();
        }
    }

    public static class BlockableCacheLoaderFactory
    implements Factory<BlockableCacheLoader> {
        private final int blockMillis;
        private final boolean throwError;

        public BlockableCacheLoaderFactory(int blockMillis, boolean throwError) {
            this.blockMillis = blockMillis;
            this.throwError = throwError;
        }

        public BlockableCacheLoader create() {
            return new BlockableCacheLoader(this.blockMillis, this.throwError);
        }
    }
}

