/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.cache.impl;

import com.hazelcast.client.cache.impl.ClientCacheProxy;
import com.hazelcast.config.CacheConfig;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.logging.AbstractLogger;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.LogEvent;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.logging.Level;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientCacheProxyTest
extends HazelcastTestSupport {
    @Test
    public void isCacheOnUpdate_prints_warning_message_for_deprecated_policy_CACHE() throws Exception {
        NearCacheConfig nearCacheConfig = new NearCacheConfig().setLocalUpdatePolicy(NearCacheConfig.LocalUpdatePolicy.CACHE);
        TestLogger logger = new TestLogger();
        new ClientCacheProxy(new CacheConfig());
        ClientCacheProxy.isCacheOnUpdate((NearCacheConfig)nearCacheConfig, (String)"cacheName", (ILogger)logger);
        Assert.assertNotNull((Object)logger.message);
    }

    @Test
    public void isCacheOnUpdate_not_prints_warning_message_for_policy_CACHE_ON_UPDATE() throws Exception {
        NearCacheConfig nearCacheConfig = new NearCacheConfig().setLocalUpdatePolicy(NearCacheConfig.LocalUpdatePolicy.CACHE_ON_UPDATE);
        TestLogger logger = new TestLogger();
        new ClientCacheProxy(new CacheConfig());
        ClientCacheProxy.isCacheOnUpdate((NearCacheConfig)nearCacheConfig, (String)"cacheName", (ILogger)logger);
        Assert.assertNull((Object)logger.message);
    }

    private class TestLogger
    extends AbstractLogger {
        String message;

        private TestLogger() {
        }

        public void log(Level level, String message) {
            this.message = message;
        }

        public void log(Level level, String message, Throwable thrown) {
            throw new UnsupportedOperationException();
        }

        public void log(LogEvent logEvent) {
            throw new UnsupportedOperationException();
        }

        public Level getLevel() {
            throw new UnsupportedOperationException();
        }

        public boolean isLoggable(Level level) {
            throw new UnsupportedOperationException();
        }
    }
}

