/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.cache.impl.nearcache;

import com.hazelcast.client.cache.impl.ClientCacheProxy;
import com.hazelcast.client.cache.impl.HazelcastClientCacheManager;
import com.hazelcast.client.cache.impl.HazelcastClientCachingProvider;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.CacheConfig;
import com.hazelcast.config.Config;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.spi.properties.GroupProperty;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.QuickTest;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.cache.Cache;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class})
public class ClientCacheNearCacheStaleReadTest
extends HazelcastTestSupport {
    private static final int NUM_GETTERS = 7;
    private static final int MAX_RUNTIME = 30;
    private static final String CACHE_NAME = "test";
    private static final String KEY = "key123";
    private static final ILogger LOGGER = Logger.getLogger(ClientCacheNearCacheStaleReadTest.class);
    private AtomicInteger valuePut;
    private AtomicBoolean stop;
    private AtomicInteger assertionViolationCount;
    private AtomicBoolean failed;
    private Cache<String, String> cache;
    private HazelcastInstance member;
    private HazelcastInstance client;
    private NearCacheConfig.LocalUpdatePolicy localUpdatePolicy = NearCacheConfig.LocalUpdatePolicy.INVALIDATE;
    private InMemoryFormat inMemoryFormat = InMemoryFormat.BINARY;

    @Before
    public void setUp() throws Exception {
        TestHazelcastFactory factory = new TestHazelcastFactory();
        this.valuePut = new AtomicInteger(0);
        this.stop = new AtomicBoolean(false);
        this.failed = new AtomicBoolean(false);
        this.assertionViolationCount = new AtomicInteger(0);
        Config config = new Config();
        config.setProperty(GroupProperty.CACHE_INVALIDATION_MESSAGE_BATCH_FREQUENCY_SECONDS.getName(), "2");
        this.member = factory.newHazelcastInstance(config);
        ClientConfig clientConfig = this.getClientConfig(CACHE_NAME);
        clientConfig.setProperty("hazelcast.invalidation.max.tolerated.miss.count", "0");
        this.client = factory.newHazelcastClient(clientConfig);
        HazelcastClientCachingProvider provider = HazelcastClientCachingProvider.createCachingProvider((HazelcastInstance)this.client);
        HazelcastClientCacheManager cacheManager = (HazelcastClientCacheManager)provider.getCacheManager();
        this.cache = cacheManager.createCache(CACHE_NAME, this.createCacheConfig(this.inMemoryFormat));
    }

    @After
    public void tearDown() {
        this.client.shutdown();
        this.member.shutdown();
    }

    @Test
    public void testNoLostInvalidationsEventually() throws Exception {
        this.testNoLostInvalidationsStrict(false);
    }

    @Test
    public void testNoLostInvalidationsStrict() throws Exception {
        this.testNoLostInvalidationsStrict(true);
    }

    private void testNoLostInvalidationsStrict(boolean strict) throws Exception {
        this.runTestInternal();
        if (!strict) {
            ClientCacheNearCacheStaleReadTest.sleepSeconds((int)2);
        }
        int valuePutLast = this.valuePut.get();
        String valueMapStr = (String)this.cache.get((Object)KEY);
        int valueMap = Integer.parseInt(valueMapStr);
        String msg = null;
        if (valueMap < valuePutLast) {
            msg = "Near Cache did *not* become consistent. (valueMap = " + valueMap + ", valuePut = " + valuePutLast + ").";
            this.flushClientNearCache(this.cache);
            String valueMap2Str = (String)this.cache.get((Object)KEY);
            int valueMap2 = Integer.parseInt(valueMap2Str);
            msg = valueMap2 < valuePutLast ? msg + " Unexpected inconsistency! (valueMap2 = " + valueMap2 + ", valuePut = " + valuePutLast + ")." : msg + " Flushing the Near Cache cleared the inconsistency. (valueMap2 = " + valueMap2 + ", valuePut = " + valuePutLast + ").";
        }
        this.client.getLifecycleService().terminate();
        if (msg != null) {
            LOGGER.warning(msg);
            Assert.fail(msg);
        }
        if (strict && this.assertionViolationCount.get() > 0) {
            msg = "Assertion violated " + this.assertionViolationCount.get() + " times.";
            LOGGER.warning(msg);
            Assert.fail((String)msg);
        }
    }

    private CacheConfig<String, String> createCacheConfig(InMemoryFormat inMemoryFormat) {
        return new CacheConfig().setName(CACHE_NAME).setInMemoryFormat(inMemoryFormat);
    }

    protected ClientConfig getClientConfig(String mapName) {
        NearCacheConfig nearCacheConfig = new NearCacheConfig(mapName).setInMemoryFormat(this.inMemoryFormat).setLocalUpdatePolicy(this.localUpdatePolicy);
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.addNearCacheConfig(nearCacheConfig);
        return clientConfig;
    }

    private void flushClientNearCache(Cache cache) {
        ((ClientCacheProxy)cache).getNearCache().clear();
    }

    private void runTestInternal() throws Exception {
        Thread threadPut = new Thread((Runnable)new PutRunnable(), "put0");
        threadPut.start();
        ClientCacheNearCacheStaleReadTest.sleepMillis((int)300);
        ArrayList<Thread> threads = new ArrayList<Thread>();
        for (int i = 0; i < 7; ++i) {
            Thread thread = new Thread((Runnable)new GetRunnable(), "get" + i);
            threads.add(thread);
        }
        for (Thread thread : threads) {
            thread.start();
        }
        int i = 0;
        while (!this.stop.get() && i++ < 30) {
            ClientCacheNearCacheStaleReadTest.sleepMillis((int)1000);
        }
        if (!this.stop.get()) {
            LOGGER.info("Problem did not occur within 30s.");
        }
        this.stop.set(true);
        threadPut.join();
        for (Thread thread : threads) {
            thread.join();
        }
    }

    private class GetRunnable
    implements Runnable {
        private GetRunnable() {
        }

        @Override
        public void run() {
            LOGGER.info(Thread.currentThread().getName() + " started.");
            int n = 0;
            while (!ClientCacheNearCacheStaleReadTest.this.stop.get()) {
                ++n;
                String valueMapStr = (String)ClientCacheNearCacheStaleReadTest.this.cache.get((Object)ClientCacheNearCacheStaleReadTest.KEY);
                int i = Integer.parseInt(valueMapStr);
                Assert.assertEquals((Object)("" + i), (Object)valueMapStr);
            }
            LOGGER.info(Thread.currentThread().getName() + " performed " + n + " operations.");
        }
    }

    private class PutRunnable
    implements Runnable {
        private PutRunnable() {
        }

        @Override
        public void run() {
            LOGGER.info(Thread.currentThread().getName() + " started.");
            int i = 0;
            while (!ClientCacheNearCacheStaleReadTest.this.stop.get()) {
                int valueMap;
                ClientCacheNearCacheStaleReadTest.this.cache.put((Object)ClientCacheNearCacheStaleReadTest.KEY, (Object)String.valueOf(++i));
                ClientCacheNearCacheStaleReadTest.this.valuePut.set(i);
                String valueMapStr = (String)ClientCacheNearCacheStaleReadTest.this.cache.get((Object)ClientCacheNearCacheStaleReadTest.KEY);
                if (valueMapStr == null || (valueMap = Integer.parseInt(valueMapStr)) == i) continue;
                ClientCacheNearCacheStaleReadTest.this.assertionViolationCount.incrementAndGet();
                LOGGER.warning("Assertion violated! (valueMap = " + valueMap + ", i = " + i + ")");
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    LOGGER.warning("Interrupted: " + e.getMessage());
                }
                if ((valueMap = Integer.parseInt(valueMapStr = (String)ClientCacheNearCacheStaleReadTest.this.cache.get((Object)ClientCacheNearCacheStaleReadTest.KEY))) == i) continue;
                LOGGER.warning("Near Cache invalidation lost! (valueMap = " + valueMap + ", i = " + i + ")");
                ClientCacheNearCacheStaleReadTest.this.failed.set(true);
                ClientCacheNearCacheStaleReadTest.this.stop.set(true);
            }
            LOGGER.info(Thread.currentThread().getName() + " performed " + i + " operations.");
        }
    }
}

