/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.cache.impl.nearcache;

import com.hazelcast.cache.impl.HazelcastServerCachingProvider;
import com.hazelcast.client.cache.impl.ClientCacheProxy;
import com.hazelcast.client.cache.impl.HazelcastClientCachingProvider;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.impl.HazelcastClientProxy;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.CacheConfig;
import com.hazelcast.config.EvictionConfig;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.internal.nearcache.NearCache;
import com.hazelcast.internal.nearcache.NearCacheRecord;
import com.hazelcast.internal.nearcache.impl.DefaultNearCache;
import com.hazelcast.internal.nearcache.impl.store.AbstractNearCacheRecordStore;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.test.HazelcastParametersRunnerFactory;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.NightlyTest;
import com.hazelcast.util.RandomPicker;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.configuration.Configuration;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Parameterized.UseParametersRunnerFactory(value=HazelcastParametersRunnerFactory.class)
@Category(value={NightlyTest.class})
public class ClientCacheRecordStateStressTest
extends HazelcastTestSupport {
    @Parameterized.Parameter
    public NearCacheConfig.LocalUpdatePolicy localUpdatePolicy;
    private final int KEY_SPACE = 100;
    private final int TEST_RUN_SECONDS = 60;
    private final int GET_ALL_THREAD_COUNT = 2;
    private final int PUT_ALL_THREAD_COUNT = 1;
    private final int GET_THREAD_COUNT = 1;
    private final int PUT_THREAD_COUNT = 1;
    private final int PUT_IF_ABSENT_THREAD_COUNT = 1;
    private final int CLEAR_THREAD_COUNT = 1;
    private final int REMOVE_THREAD_COUNT = 1;
    private final String cacheName = "test";
    private final AtomicBoolean stop = new AtomicBoolean();
    private TestHazelcastFactory factory;

    @Parameterized.Parameters(name="localUpdatePolicy:{0}")
    public static Collection<Object[]> parameters() {
        return Arrays.asList({NearCacheConfig.LocalUpdatePolicy.CACHE_ON_UPDATE}, {NearCacheConfig.LocalUpdatePolicy.INVALIDATE});
    }

    @Before
    public void setUp() throws Exception {
        this.factory = new TestHazelcastFactory();
        this.stop.set(false);
    }

    @After
    public void tearDown() throws Exception {
        this.factory.shutdownAll();
    }

    @Test
    public void all_records_are_readable_state_in_the_end() throws Exception {
        int i;
        HazelcastInstance member = this.factory.newHazelcastInstance();
        HazelcastServerCachingProvider provider = HazelcastServerCachingProvider.createCachingProvider((HazelcastInstance)member);
        CacheManager serverCacheManager = provider.getCacheManager();
        this.factory.newHazelcastInstance();
        this.factory.newHazelcastInstance();
        CacheConfig cacheConfig = new CacheConfig();
        cacheConfig.getEvictionConfig().setMaximumSizePolicy(EvictionConfig.MaxSizePolicy.ENTRY_COUNT).setSize(Integer.MAX_VALUE);
        Cache memberCache = serverCacheManager.createCache("test", (Configuration)cacheConfig);
        for (int i2 = 0; i2 < 100; ++i2) {
            memberCache.put((Object)i2, (Object)i2);
        }
        ClientConfig clientConfig = new ClientConfig();
        NearCacheConfig nearCacheConfig = new NearCacheConfig();
        nearCacheConfig.setInvalidateOnChange(true).setLocalUpdatePolicy(this.localUpdatePolicy).getEvictionConfig().setMaximumSizePolicy(EvictionConfig.MaxSizePolicy.ENTRY_COUNT).setSize(Integer.MAX_VALUE);
        clientConfig.addNearCacheConfig(nearCacheConfig);
        ArrayList<Thread> threads = new ArrayList<Thread>();
        for (int i3 = 0; i3 < 1; ++i3) {
            Put put = new Put(memberCache);
            threads.add(put);
        }
        HazelcastClientProxy client = (HazelcastClientProxy)this.factory.newHazelcastClient(clientConfig);
        HazelcastClientCachingProvider clientCachingProvider = HazelcastClientCachingProvider.createCachingProvider((HazelcastInstance)client);
        CacheManager cacheManager = clientCachingProvider.getCacheManager();
        Cache clientCache = cacheManager.createCache("test", (Configuration)cacheConfig);
        for (i = 0; i < 2; ++i) {
            GetAll getAll = new GetAll(clientCache);
            threads.add(getAll);
        }
        for (i = 0; i < 1; ++i) {
            PutAll putAll = new PutAll(clientCache);
            threads.add(putAll);
        }
        for (i = 0; i < 1; ++i) {
            PutIfAbsent putIfAbsent = new PutIfAbsent(clientCache);
            threads.add(putIfAbsent);
        }
        for (i = 0; i < 1; ++i) {
            Get get = new Get(clientCache);
            threads.add(get);
        }
        for (i = 0; i < 1; ++i) {
            Remove remove = new Remove(clientCache);
            threads.add(remove);
        }
        for (i = 0; i < 1; ++i) {
            Clear clear = new Clear(clientCache);
            threads.add(clear);
        }
        for (Thread thread : threads) {
            thread.start();
        }
        ClientCacheRecordStateStressTest.sleepSeconds((int)60);
        this.stop.set(true);
        for (Thread thread : threads) {
            thread.join();
        }
        this.assertFinalRecordStateIsReadPermitted(clientCache, member);
    }

    private void assertFinalRecordStateIsReadPermitted(Cache clientCache, HazelcastInstance member) {
        ClientCacheProxy proxy = (ClientCacheProxy)clientCache;
        NearCache nearCache = proxy.getNearCache();
        DefaultNearCache unwrap = (DefaultNearCache)nearCache.unwrap(DefaultNearCache.class);
        InternalSerializationService ss = ClientCacheRecordStateStressTest.getSerializationService((HazelcastInstance)member);
        for (int i = 0; i < 100; ++i) {
            Data key = ss.toData((Object)i);
            AbstractNearCacheRecordStore nearCacheRecordStore = (AbstractNearCacheRecordStore)unwrap.getNearCacheRecordStore();
            NearCacheRecord record = nearCacheRecordStore.getRecord((Object)key);
            if (record == null) continue;
            Assert.assertEquals((String)record.toString(), (long)-4L, (long)record.getRecordState());
        }
    }

    private class Get
    extends Thread {
        private final Cache cache;

        private Get(Cache cache) {
            this.cache = cache;
        }

        @Override
        public void run() {
            do {
                for (int i = 0; i < 100; ++i) {
                    this.cache.get((Object)i);
                }
            } while (!ClientCacheRecordStateStressTest.this.stop.get());
        }
    }

    private class PutAll
    extends Thread {
        private final Cache cache;

        private PutAll(Cache cache) {
            this.cache = cache;
        }

        @Override
        public void run() {
            HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
            do {
                map.clear();
                for (int i = 0; i < 100; ++i) {
                    map.put(i, RandomPicker.getInt((int)Integer.MAX_VALUE));
                }
                this.cache.putAll(map);
                HazelcastTestSupport.sleepAtLeastMillis((long)2000L);
            } while (!ClientCacheRecordStateStressTest.this.stop.get());
        }
    }

    private class GetAll
    extends Thread {
        private final Cache cache;

        private GetAll(Cache cache) {
            this.cache = cache;
        }

        @Override
        public void run() {
            HashSet<Integer> keys = new HashSet<Integer>();
            for (int i = 0; i < 100; ++i) {
                keys.add(i);
            }
            do {
                this.cache.getAll(keys);
                HazelcastTestSupport.sleepAtLeastMillis((long)10L);
            } while (!ClientCacheRecordStateStressTest.this.stop.get());
        }
    }

    private class Clear
    extends Thread {
        private final Cache cache;

        private Clear(Cache cache) {
            this.cache = cache;
        }

        @Override
        public void run() {
            do {
                this.cache.clear();
                HazelcastTestSupport.sleepAtLeastMillis((long)5000L);
            } while (!ClientCacheRecordStateStressTest.this.stop.get());
        }
    }

    private class PutIfAbsent
    extends Thread {
        private final Cache cache;

        private PutIfAbsent(Cache cache) {
            this.cache = cache;
        }

        @Override
        public void run() {
            do {
                for (int i = 0; i < 100; ++i) {
                    this.cache.putIfAbsent((Object)i, (Object)RandomPicker.getInt((int)Integer.MAX_VALUE));
                }
                HazelcastTestSupport.sleepAtLeastMillis((long)1000L);
            } while (!ClientCacheRecordStateStressTest.this.stop.get());
        }
    }

    private class Remove
    extends Thread {
        private final Cache cache;

        private Remove(Cache cache) {
            this.cache = cache;
        }

        @Override
        public void run() {
            do {
                for (int i = 0; i < 100; ++i) {
                    this.cache.remove((Object)i);
                }
                HazelcastTestSupport.sleepAtLeastMillis((long)1000L);
            } while (!ClientCacheRecordStateStressTest.this.stop.get());
        }
    }

    private class Put
    extends Thread {
        private final Cache cache;

        private Put(Cache cache) {
            this.cache = cache;
        }

        @Override
        public void run() {
            do {
                for (int i = 0; i < 100; ++i) {
                    this.cache.put((Object)i, (Object)RandomPicker.getInt((int)100));
                }
                HazelcastTestSupport.sleepAtLeastMillis((long)5000L);
            } while (!ClientCacheRecordStateStressTest.this.stop.get());
        }
    }
}

