/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.cache.impl.nearcache;

import com.hazelcast.cache.ICache;
import com.hazelcast.client.cache.impl.HazelcastClientCacheManager;
import com.hazelcast.client.cache.impl.HazelcastClientCachingProvider;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.impl.HazelcastClientProxy;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.CacheConfig;
import com.hazelcast.config.Config;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.config.SerializationConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.internal.nearcache.NearCache;
import com.hazelcast.internal.nearcache.NearCacheManager;
import com.hazelcast.nio.serialization.ClassDefinition;
import com.hazelcast.nio.serialization.ClassDefinitionBuilder;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.nio.serialization.PortableFactory;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.test.AssertTask;
import com.hazelcast.test.HazelcastSerialClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.QuickTest;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastSerialClassRunner.class)
@Category(value={QuickTest.class})
public class ClientCacheSerializationCountTest
extends HazelcastTestSupport {
    private static final String CACHE_NAME = ClientCacheSerializationCountTest.randomString();
    private static final AtomicInteger SERIALIZE_COUNT = new AtomicInteger();
    private static final AtomicInteger DESERIALIZE_COUNT = new AtomicInteger();
    private TestHazelcastFactory hazelcastFactory = new TestHazelcastFactory();
    private NearCache nearCache;
    private ICache<String, SerializationCountingData> cache;

    @After
    public void tearDown() {
        DESERIALIZE_COUNT.set(0);
        SERIALIZE_COUNT.set(0);
        this.hazelcastFactory.terminateAll();
    }

    @Test
    public void testDeserializationCountWith_ObjectNearCache_cacheLocalUpdatePolicy() {
        NearCacheConfig nearCacheConfig = this.createNearCacheConfig(InMemoryFormat.OBJECT, NearCacheConfig.LocalUpdatePolicy.CACHE_ON_UPDATE);
        this.prepareCache(nearCacheConfig);
        String key = ClientCacheSerializationCountTest.randomString();
        SerializationCountingData value = new SerializationCountingData();
        this.cache.put((Object)key, (Object)value);
        ClientCacheSerializationCountTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() throws Exception {
                Assert.assertEquals((long)1L, (long)ClientCacheSerializationCountTest.this.nearCache.size());
            }
        });
        this.assertAndReset(1, 0);
        this.cache.get((Object)key);
        this.assertAndReset(0, 0);
        this.cache.get((Object)key);
        this.assertAndReset(0, 0);
    }

    @Test
    public void testDeserializationCountWith_BinaryNearCache_cacheLocalUpdatePolicy() {
        NearCacheConfig nearCacheConfig = this.createNearCacheConfig(InMemoryFormat.BINARY, NearCacheConfig.LocalUpdatePolicy.CACHE_ON_UPDATE);
        this.prepareCache(nearCacheConfig);
        String key = ClientCacheSerializationCountTest.randomString();
        SerializationCountingData value = new SerializationCountingData();
        this.cache.put((Object)key, (Object)value);
        ClientCacheSerializationCountTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() throws Exception {
                Assert.assertEquals((long)1L, (long)ClientCacheSerializationCountTest.this.nearCache.size());
            }
        });
        this.assertAndReset(1, 0);
        this.cache.get((Object)key);
        this.assertAndReset(0, 1);
        this.cache.get((Object)key);
        this.assertAndReset(0, 1);
    }

    @Test
    public void testDeserializationCountWith_ObjectNearCache_invalidateLocalUpdatePolicy() {
        NearCacheConfig nearCacheConfig = this.createNearCacheConfig(InMemoryFormat.OBJECT, NearCacheConfig.LocalUpdatePolicy.INVALIDATE);
        this.prepareCache(nearCacheConfig);
        String key = ClientCacheSerializationCountTest.randomString();
        SerializationCountingData value = new SerializationCountingData();
        this.cache.put((Object)key, (Object)value);
        this.assertAndReset(1, 0);
        this.cache.get((Object)key);
        this.assertAndReset(0, 1);
        this.cache.get((Object)key);
        this.assertAndReset(0, 0);
    }

    @Test
    public void testDeserializationCountWith_BinaryNearCache_invalidateLocalUpdatePolicy() {
        NearCacheConfig nearCacheConfig = this.createNearCacheConfig(InMemoryFormat.BINARY, NearCacheConfig.LocalUpdatePolicy.INVALIDATE);
        this.prepareCache(nearCacheConfig);
        String key = ClientCacheSerializationCountTest.randomString();
        SerializationCountingData value = new SerializationCountingData();
        this.cache.put((Object)key, (Object)value);
        this.assertAndReset(1, 0);
        this.cache.get((Object)key);
        this.assertAndReset(0, 1);
        this.cache.get((Object)key);
        this.assertAndReset(0, 1);
    }

    @Test
    public void testDeserializationCountWithoutNearCache() {
        this.prepareCache(null);
        SerializationCountingData value = new SerializationCountingData();
        String key = ClientCacheSerializationCountTest.randomString();
        this.cache.put((Object)key, (Object)value);
        this.assertAndReset(1, 0);
        this.cache.get((Object)key);
        this.assertAndReset(0, 1);
        this.cache.get((Object)key);
        this.assertAndReset(0, 1);
    }

    private CacheConfig<String, SerializationCountingData> createCacheConfig(InMemoryFormat inMemoryFormat) {
        return new CacheConfig().setName(CACHE_NAME).setInMemoryFormat(inMemoryFormat);
    }

    private NearCacheConfig createNearCacheConfig(InMemoryFormat inMemoryFormat, NearCacheConfig.LocalUpdatePolicy localUpdatePolicy) {
        return new NearCacheConfig().setName(CACHE_NAME).setLocalUpdatePolicy(localUpdatePolicy).setInMemoryFormat(inMemoryFormat);
    }

    private Config createConfig() {
        Config config = new Config();
        SerializationConfig serializationConfig = config.getSerializationConfig();
        this.prepareSerializationConfig(serializationConfig);
        return config;
    }

    private ClientConfig createClientConfig() {
        ClientConfig config = new ClientConfig();
        SerializationConfig serializationConfig = config.getSerializationConfig();
        this.prepareSerializationConfig(serializationConfig);
        return config;
    }

    private void prepareSerializationConfig(SerializationConfig serializationConfig) {
        ClassDefinition classDefinition = new ClassDefinitionBuilder(SerializationCountingData.FACTORY_ID, SerializationCountingData.CLASS_ID).build();
        serializationConfig.addClassDefinition(classDefinition);
        serializationConfig.addPortableFactory(SerializationCountingData.FACTORY_ID, new PortableFactory(){

            public Portable create(int classId) {
                return new SerializationCountingData();
            }
        });
    }

    private void prepareCache(NearCacheConfig nearCacheConfig) {
        this.hazelcastFactory.newHazelcastInstance(this.createConfig());
        ClientConfig clientConfig = this.createClientConfig();
        if (nearCacheConfig != null) {
            clientConfig.addNearCacheConfig(nearCacheConfig);
        }
        HazelcastClientProxy client = (HazelcastClientProxy)this.hazelcastFactory.newHazelcastClient(clientConfig);
        HazelcastClientCachingProvider provider = HazelcastClientCachingProvider.createCachingProvider((HazelcastInstance)client);
        HazelcastClientCacheManager cacheManager = (HazelcastClientCacheManager)provider.getCacheManager();
        CacheConfig<String, SerializationCountingData> cacheConfig = this.createCacheConfig(InMemoryFormat.BINARY);
        NearCacheManager nearCacheManager = client.client.getNearCacheManager();
        this.cache = cacheManager.createCache(CACHE_NAME, cacheConfig);
        this.nearCache = nearCacheManager.getNearCache(cacheManager.getCacheNameWithPrefix(CACHE_NAME));
    }

    private void assertAndReset(int serializeCount, int deserializeCount) {
        Assert.assertEquals((long)serializeCount, (long)SERIALIZE_COUNT.getAndSet(0));
        Assert.assertEquals((long)deserializeCount, (long)DESERIALIZE_COUNT.getAndSet(0));
    }

    static class SerializationCountingData
    implements Portable {
        static int FACTORY_ID = 1;
        static int CLASS_ID = 1;

        public int getFactoryId() {
            return FACTORY_ID;
        }

        public int getClassId() {
            return CLASS_ID;
        }

        public void writePortable(PortableWriter writer) throws IOException {
            SERIALIZE_COUNT.incrementAndGet();
        }

        public void readPortable(PortableReader reader) throws IOException {
            DESERIALIZE_COUNT.incrementAndGet();
        }
    }
}

