/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.cache.impl.nearcache;

import com.hazelcast.cache.CacheUtil;
import com.hazelcast.cache.ICache;
import com.hazelcast.cache.impl.HazelcastServerCacheManager;
import com.hazelcast.cache.impl.HazelcastServerCachingProvider;
import com.hazelcast.client.cache.impl.HazelcastClientCacheManager;
import com.hazelcast.client.cache.impl.HazelcastClientCachingProvider;
import com.hazelcast.client.cache.impl.nearcache.NearCacheTestContext;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.impl.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.HazelcastClientProxy;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.CacheAddInvalidationListenerCodec;
import com.hazelcast.client.impl.protocol.codec.CacheRemoveEntryListenerCodec;
import com.hazelcast.client.spi.EventHandler;
import com.hazelcast.client.spi.impl.ListenerMessageCodec;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.CacheConfig;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.internal.nearcache.NearCache;
import com.hazelcast.internal.nearcache.NearCacheManager;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.test.AssertTask;
import com.hazelcast.test.HazelcastParametersRunnerFactory;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.SlowTest;
import java.util.Arrays;
import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import javax.cache.configuration.Configuration;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Parameterized.UseParametersRunnerFactory(value=HazelcastParametersRunnerFactory.class)
@Category(value={SlowTest.class})
public class ClientNearCacheInvalidationTest
extends HazelcastTestSupport {
    static final String DEFAULT_CACHE_NAME = "com.hazelcast.client.cache.impl.nearcache.ClientNearCacheInvalidationTest";
    static final int TIMEOUT = 5;
    static final int MEMBER_COUNT = 2;
    @Parameterized.Parameter
    public boolean invokeCacheOperationsFromMember;
    @Parameterized.Parameter(value=1)
    public InMemoryFormat inMemoryFormat;
    private HazelcastInstance member;
    private TestHazelcastFactory hazelcastFactory;
    private NearCacheTestContext testContext;

    @Parameterized.Parameters(name="fromMember:{0}, format:{1}")
    public static Collection<Object[]> parameters() {
        return Arrays.asList({false, InMemoryFormat.BINARY}, {false, InMemoryFormat.OBJECT}, {true, InMemoryFormat.BINARY}, {true, InMemoryFormat.OBJECT});
    }

    @Before
    public void setup() {
        this.hazelcastFactory = new TestHazelcastFactory();
        this.member = this.hazelcastFactory.newHazelcastInstance(this.getConfig());
        HazelcastInstance[] allMembers = new HazelcastInstance[2];
        allMembers[0] = this.member;
        for (int i = 1; i < 2; ++i) {
            allMembers[i] = this.hazelcastFactory.newHazelcastInstance(this.getConfig());
        }
        ClientNearCacheInvalidationTest.waitAllForSafeState((HazelcastInstance[])allMembers);
        ClientConfig clientConfig = this.createClientConfig();
        clientConfig.addNearCacheConfig(this.createNearCacheConfig(this.inMemoryFormat));
        HazelcastClientProxy client = (HazelcastClientProxy)this.hazelcastFactory.newHazelcastClient(clientConfig);
        NearCacheManager nearCacheManager = client.client.getNearCacheManager();
        HazelcastClientCachingProvider provider = HazelcastClientCachingProvider.createCachingProvider((HazelcastInstance)client);
        HazelcastClientCacheManager cacheManager = (HazelcastClientCacheManager)provider.getCacheManager();
        HazelcastServerCacheManager memberCacheManager = (HazelcastServerCacheManager)HazelcastServerCachingProvider.createCachingProvider((HazelcastInstance)this.member).getCacheManager();
        ICache cache = cacheManager.createCache(DEFAULT_CACHE_NAME, (Configuration)this.createCacheConfig(this.inMemoryFormat));
        ICache memberCache = this.member.getCacheManager().getCache(CacheUtil.getPrefixedCacheName((String)DEFAULT_CACHE_NAME, null, null));
        NearCache nearCache = nearCacheManager.getNearCache(cacheManager.getCacheNameWithPrefix(DEFAULT_CACHE_NAME));
        this.testContext = new NearCacheTestContext(client, this.member, cacheManager, memberCacheManager, nearCacheManager, (ICache<Object, String>)cache, (ICache<Object, String>)memberCache, (NearCache<Data, String>)nearCache);
        for (int i = 0; i < 1000; ++i) {
            this.testContext.memberCache.put((Object)Integer.toString(i), (Object)Integer.toString(i));
        }
    }

    @After
    public void tearDown() {
        this.hazelcastFactory.shutdownAll();
    }

    @Test
    public void when_cacheDestroyed_invalidationEventIsReceived() {
        AtomicInteger counter = new AtomicInteger();
        this.registerInvalidationListener(counter);
        this.destroy();
        this.assertInvalidationEventCountNeverExceeds(counter, 2);
    }

    @Test
    public void when_cacheCleared_invalidationEventIsReceived() {
        AtomicInteger counter = new AtomicInteger();
        this.registerInvalidationListener(counter);
        this.clear();
        this.assertInvalidationEventCountNeverExceeds(counter, 1);
    }

    @Test
    public void when_cacheClosed_invalidationEventIsNotReceived() {
        AtomicInteger counter = new AtomicInteger();
        this.registerInvalidationListener(counter);
        this.close();
        this.assertInvalidationEventNeverReceived(counter);
    }

    @Test
    public void when_cacheManagerDestroyCacheInvoked_invalidationEventMayBeReceived() {
        AtomicInteger counter = new AtomicInteger();
        this.registerInvalidationListener(counter);
        this.destroyCacheFromCacheManager();
        if (this.invokeCacheOperationsFromMember) {
            this.assertInvalidationEventNeverReceived(counter);
        } else {
            this.assertInvalidationEventCountNeverExceeds(counter, 2);
        }
    }

    @Test
    public void when_shuttingDown_invalidationEventIsNotReceived() {
        AtomicInteger counter = new AtomicInteger();
        this.registerInvalidationListener(counter);
        this.shutdown();
        this.assertInvalidationEventNeverReceived(counter);
    }

    private void assertInvalidationEventCountNeverExceeds(final AtomicInteger counter, final int maximumEventCount) {
        ClientNearCacheInvalidationTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() throws Exception {
                Assert.assertTrue((String)"At least one invalidation event should have been received", (counter.get() >= 1 ? 1 : 0) != 0);
            }
        }, (long)5L);
        ClientNearCacheInvalidationTest.assertTrueAllTheTime((AssertTask)new AssertTask(){

            public void run() throws Exception {
                Assert.assertTrue((String)("Expected invalidation event to be received at most " + maximumEventCount + " times"), (counter.get() <= maximumEventCount ? 1 : 0) != 0);
            }
        }, (long)5L);
    }

    private void assertInvalidationEventNeverReceived(final AtomicInteger counter) {
        ClientNearCacheInvalidationTest.assertTrueAllTheTime((AssertTask)new AssertTask(){

            public void run() throws Exception {
                Assert.assertEquals((long)0L, (long)counter.get());
            }
        }, (long)5L);
    }

    private void registerInvalidationListener(AtomicInteger counter) {
        NearCacheRepairingHandler handler = new NearCacheRepairingHandler(counter);
        ListenerMessageCodec listenerCodec = this.createInvalidationListenerCodec();
        HazelcastClientInstanceImpl clientInstance = this.testContext.client.client;
        clientInstance.getListenerService().registerListener(listenerCodec, (EventHandler)handler);
    }

    private ListenerMessageCodec createInvalidationListenerCodec() {
        return new ListenerMessageCodec(){

            public ClientMessage encodeAddRequest(boolean localOnly) {
                return CacheAddInvalidationListenerCodec.encodeRequest((String)CacheUtil.getDistributedObjectName((String)ClientNearCacheInvalidationTest.DEFAULT_CACHE_NAME), (boolean)localOnly);
            }

            public String decodeAddResponse(ClientMessage clientMessage) {
                return CacheAddInvalidationListenerCodec.decodeResponse((ClientMessage)clientMessage).response;
            }

            public ClientMessage encodeRemoveRequest(String realRegistrationId) {
                return CacheRemoveEntryListenerCodec.encodeRequest((String)CacheUtil.getDistributedObjectName((String)ClientNearCacheInvalidationTest.DEFAULT_CACHE_NAME), (String)realRegistrationId);
            }

            public boolean decodeRemoveResponse(ClientMessage clientMessage) {
                return CacheRemoveEntryListenerCodec.decodeResponse((ClientMessage)clientMessage).response;
            }
        };
    }

    private void clear() {
        if (this.invokeCacheOperationsFromMember) {
            this.testContext.memberCache.clear();
        } else {
            this.testContext.cache.clear();
        }
    }

    private void close() {
        if (this.invokeCacheOperationsFromMember) {
            this.testContext.memberCache.close();
        } else {
            this.testContext.cache.close();
        }
    }

    private void destroy() {
        if (this.invokeCacheOperationsFromMember) {
            this.testContext.memberCache.destroy();
        } else {
            this.testContext.cache.destroy();
        }
    }

    private void shutdown() {
        if (this.invokeCacheOperationsFromMember) {
            this.testContext.member.shutdown();
        } else {
            this.testContext.client.shutdown();
        }
    }

    private void destroyCacheFromCacheManager() {
        if (this.invokeCacheOperationsFromMember) {
            this.testContext.memberCacheManager.destroyCache(DEFAULT_CACHE_NAME);
        } else {
            this.testContext.cacheManager.destroyCache(DEFAULT_CACHE_NAME);
        }
    }

    protected ClientConfig createClientConfig() {
        return new ClientConfig();
    }

    protected NearCacheConfig createNearCacheConfig(InMemoryFormat inMemoryFormat) {
        return new NearCacheConfig().setInMemoryFormat(inMemoryFormat).setName(DEFAULT_CACHE_NAME);
    }

    protected CacheConfig createCacheConfig(InMemoryFormat inMemoryFormat) {
        return new CacheConfig().setName(DEFAULT_CACHE_NAME).setInMemoryFormat(inMemoryFormat).setBackupCount(1);
    }

    private final class NearCacheRepairingHandler
    extends CacheAddInvalidationListenerCodec.AbstractEventHandler
    implements EventHandler<ClientMessage> {
        private final AtomicInteger counter;

        NearCacheRepairingHandler(AtomicInteger counter) {
            this.counter = counter;
        }

        public void handle(String name, Data key, String sourceUuid, UUID partitionUuid, long sequence) {
            this.counter.incrementAndGet();
        }

        public void handle(String name, Collection<Data> keys, Collection<String> sourceUuids, Collection<UUID> partitionUuids, Collection<Long> sequences) {
            this.counter.incrementAndGet();
        }

        public void beforeListenerRegister() {
        }

        public void onListenerRegister() {
        }
    }
}

