/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.cache.impl.nearcache;

import com.hazelcast.client.cache.impl.nearcache.ClientNearCacheTestSupport;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.test.HazelcastParametersRunnerFactory;
import com.hazelcast.test.annotation.QuickTest;
import java.util.Arrays;
import java.util.Collection;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Parameterized.UseParametersRunnerFactory(value=HazelcastParametersRunnerFactory.class)
@Category(value={QuickTest.class})
public class ClientNearCacheTest
extends ClientNearCacheTestSupport {
    @Parameterized.Parameter
    public InMemoryFormat inMemoryFormat;

    @Parameterized.Parameters(name="format:{0}")
    public static Collection<Object[]> parameters() {
        return Arrays.asList({InMemoryFormat.BINARY}, {InMemoryFormat.OBJECT});
    }

    @Test
    public void putAndGetFromCacheAndThenGetFromClientNearCache() {
        this.putAndGetFromCacheAndThenGetFromClientNearCache(this.inMemoryFormat);
    }

    @Test
    public void putToCacheAndThenGetFromClientNearCache() {
        this.putToCacheAndThenGetFromClientNearCache(this.inMemoryFormat);
    }

    @Test
    public void putIfAbsentToCacheAndThenGetFromClientNearCache() {
        this.putIfAbsentToCacheAndThenGetFromClientNearCache(this.inMemoryFormat);
    }

    @Test
    public void putToCacheAndGetInvalidationEventWhenNodeShutdown() {
        this.putToCacheAndGetInvalidationEventWhenNodeShutdown(this.inMemoryFormat);
    }

    @Test
    public void putToCacheAndUpdateFromOtherNodeThenGetUpdatedFromClientNearCache() {
        this.putToCacheAndUpdateFromOtherNodeThenGetUpdatedFromClientNearCache(this.inMemoryFormat);
    }

    @Test
    public void putToCacheAndRemoveFromOtherNodeThenCantGetUpdatedFromClientNearCache() {
        this.putToCacheAndRemoveFromOtherNodeThenCantGetUpdatedFromClientNearCache(this.inMemoryFormat);
    }

    @Test
    public void testLoadAllNearCacheInvalidationBinary() throws Exception {
        this.testLoadAllNearCacheInvalidation(this.inMemoryFormat);
    }

    @Test
    public void putToCacheAndClearOrDestroyThenCantGetAnyRecordFromClientNearCache() {
        this.putToCacheAndClearOrDestroyThenCantGetAnyRecordFromClientNearCache(this.inMemoryFormat);
    }

    @Test
    public void testGetAllReturnsFromNearCache() {
        this.doTestGetAllReturnsFromNearCache(this.inMemoryFormat);
    }

    @Test
    public void putToCacheAndDontInvalidateFromClientNearCacheWhenPerEntryInvalidationIsDisabled() {
        this.putToCacheAndDontInvalidateFromClientNearCacheWhenPerEntryInvalidationIsDisabled(this.inMemoryFormat);
    }

    @Test
    public void putAsyncToCacheAndThenGetFromClientNearCacheImmediately() throws Exception {
        this.putAsyncToCacheAndThenGetFromClientNearCacheImmediately(this.inMemoryFormat);
    }

    @Test
    public void testNearCacheTTLRecordsExpired_() {
        this.testNearCacheExpiration_withTTL(this.inMemoryFormat);
    }

    @Test
    public void testNearCacheIdleRecordsExpired_() {
        this.testNearCacheExpiration_withMaxIdle(this.inMemoryFormat);
    }
}

