/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.cache.impl.nearcache;

import com.hazelcast.cache.ICache;
import com.hazelcast.client.cache.impl.HazelcastClientCacheManager;
import com.hazelcast.client.cache.impl.HazelcastClientCachingProvider;
import com.hazelcast.client.cache.impl.nearcache.NearCacheTestContext;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.impl.HazelcastClientProxy;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.CacheConfig;
import com.hazelcast.config.Config;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.ICompletableFuture;
import com.hazelcast.core.LifecycleEvent;
import com.hazelcast.instance.LifecycleServiceImpl;
import com.hazelcast.internal.nearcache.NearCache;
import com.hazelcast.internal.nearcache.NearCacheManager;
import com.hazelcast.monitor.NearCacheStats;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.properties.GroupProperty;
import com.hazelcast.test.AssertTask;
import com.hazelcast.test.HazelcastTestSupport;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.cache.configuration.Configuration;
import javax.cache.configuration.FactoryBuilder;
import javax.cache.integration.CacheLoader;
import javax.cache.integration.CacheLoaderException;
import javax.cache.integration.CompletionListener;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;

public abstract class ClientNearCacheTestSupport
extends HazelcastTestSupport {
    protected static final String DEFAULT_CACHE_NAME = "ClientCache";
    protected static final int DEFAULT_RECORD_COUNT = 100;
    protected static final int MAX_TTL_SECONDS = 2;
    protected static final int MAX_IDLE_SECONDS = 1;
    protected final TestHazelcastFactory hazelcastFactory = new TestHazelcastFactory();
    protected HazelcastInstance serverInstance;

    @Before
    public final void factoryInitialization() {
        this.serverInstance = this.hazelcastFactory.newHazelcastInstance(this.createConfig());
    }

    @After
    public final void factoryShutdown() {
        this.hazelcastFactory.shutdownAll();
    }

    protected Config createConfig() {
        return new Config();
    }

    protected ClientConfig createClientConfig() {
        return new ClientConfig();
    }

    protected CacheConfig createCacheConfig(InMemoryFormat inMemoryFormat) {
        CacheConfig cacheConfig = new CacheConfig().setName(DEFAULT_CACHE_NAME).setInMemoryFormat(inMemoryFormat);
        cacheConfig.setCacheLoaderFactory(FactoryBuilder.factoryOf(TestCacheLoader.class));
        return cacheConfig;
    }

    protected NearCacheConfig createNearCacheConfig(InMemoryFormat inMemoryFormat) {
        return new NearCacheConfig().setName(DEFAULT_CACHE_NAME).setInMemoryFormat(inMemoryFormat);
    }

    protected String generateValueFromKey(Integer key) {
        return "Value-" + key;
    }

    protected NearCacheTestContext createNearCacheTest(String cacheName, NearCacheConfig nearCacheConfig, CacheConfig cacheConfig) {
        ClientConfig clientConfig = this.createClientConfig();
        clientConfig.addNearCacheConfig(nearCacheConfig);
        HazelcastClientProxy client = (HazelcastClientProxy)this.hazelcastFactory.newHazelcastClient(clientConfig);
        NearCacheManager nearCacheManager = client.client.getNearCacheManager();
        HazelcastClientCachingProvider provider = HazelcastClientCachingProvider.createCachingProvider((HazelcastInstance)client);
        HazelcastClientCacheManager cacheManager = (HazelcastClientCacheManager)provider.getCacheManager();
        ICache cache = cacheManager.createCache(cacheName, (Configuration)cacheConfig);
        NearCache nearCache = nearCacheManager.getNearCache(cacheManager.getCacheNameWithPrefix(cacheName));
        return new NearCacheTestContext(client, cacheManager, nearCacheManager, (ICache<Object, String>)cache, (NearCache<Data, String>)nearCache);
    }

    protected NearCacheTestContext createNearCacheTest(String cacheName, NearCacheConfig nearCacheConfig) {
        CacheConfig cacheConfig = this.createCacheConfig(nearCacheConfig.getInMemoryFormat());
        return this.createNearCacheTest(cacheName, nearCacheConfig, cacheConfig);
    }

    protected NearCacheTestContext createNearCacheTestAndFillWithData(String cacheName, NearCacheConfig nearCacheConfig) {
        return this.createNearCacheTestAndFillWithData(cacheName, nearCacheConfig, false);
    }

    protected NearCacheTestContext createNearCacheTestAndFillWithData(String cacheName, NearCacheConfig nearCacheConfig, boolean putIfAbsent) {
        NearCacheTestContext nearCacheTestContext = this.createNearCacheTest(cacheName, nearCacheConfig);
        for (int i = 0; i < 100; ++i) {
            if (putIfAbsent) {
                nearCacheTestContext.cache.putIfAbsent((Object)i, (Object)this.generateValueFromKey(i));
                continue;
            }
            nearCacheTestContext.cache.put((Object)i, (Object)this.generateValueFromKey(i));
        }
        return nearCacheTestContext;
    }

    protected void putAndGetFromCacheAndThenGetFromClientNearCache(InMemoryFormat inMemoryFormat) {
        int i;
        NearCacheConfig nearCacheConfig = this.createNearCacheConfig(inMemoryFormat);
        NearCacheTestContext nearCacheTestContext = this.createNearCacheTestAndFillWithData(DEFAULT_CACHE_NAME, nearCacheConfig);
        for (i = 0; i < 100; ++i) {
            Assert.assertNull((Object)nearCacheTestContext.nearCache.get((Object)nearCacheTestContext.serializationService.toData((Object)i)));
        }
        for (i = 0; i < 100; ++i) {
            nearCacheTestContext.cache.get((Object)i);
        }
        for (i = 0; i < 100; ++i) {
            String expectedValue = this.generateValueFromKey(i);
            Data keyData = nearCacheTestContext.serializationService.toData((Object)i);
            Assert.assertEquals((Object)expectedValue, (Object)nearCacheTestContext.nearCache.get((Object)keyData));
        }
    }

    protected void putToCacheAndThenGetFromClientNearCacheInternal(InMemoryFormat inMemoryFormat, boolean putIfAbsent) {
        NearCacheConfig nearCacheConfig = this.createNearCacheConfig(inMemoryFormat);
        nearCacheConfig.setLocalUpdatePolicy(NearCacheConfig.LocalUpdatePolicy.CACHE_ON_UPDATE);
        NearCacheTestContext nearCacheTestContext = this.createNearCacheTestAndFillWithData(DEFAULT_CACHE_NAME, nearCacheConfig, putIfAbsent);
        for (int i = 0; i < 100; ++i) {
            String expectedValue = this.generateValueFromKey(i);
            Data keyData = nearCacheTestContext.serializationService.toData((Object)i);
            Assert.assertEquals((Object)expectedValue, (Object)nearCacheTestContext.nearCache.get((Object)keyData));
        }
    }

    protected void putToCacheAndThenGetFromClientNearCache(InMemoryFormat inMemoryFormat) {
        this.putToCacheAndThenGetFromClientNearCacheInternal(inMemoryFormat, false);
    }

    protected void putIfAbsentToCacheAndThenGetFromClientNearCache(InMemoryFormat inMemoryFormat) {
        this.putToCacheAndThenGetFromClientNearCacheInternal(inMemoryFormat, true);
    }

    protected void putAsyncToCacheAndThenGetFromClientNearCacheImmediately(InMemoryFormat inMemoryFormat) throws Exception {
        NearCacheConfig nearCacheConfig = this.createNearCacheConfig(inMemoryFormat);
        nearCacheConfig.setLocalUpdatePolicy(NearCacheConfig.LocalUpdatePolicy.CACHE_ON_UPDATE);
        NearCacheTestContext nearCacheTestContext = this.createNearCacheTest(DEFAULT_CACHE_NAME, nearCacheConfig);
        for (int i = 0; i < 1000; ++i) {
            String expectedValue = this.generateValueFromKey(i);
            Data keyData = nearCacheTestContext.serializationService.toData((Object)i);
            ICompletableFuture future = nearCacheTestContext.cache.putAsync((Object)i, (Object)expectedValue);
            future.get();
            Assert.assertEquals((Object)expectedValue, (Object)nearCacheTestContext.nearCache.get((Object)keyData));
        }
    }

    protected void putToCacheAndUpdateFromOtherNodeThenGetUpdatedFromClientNearCache(InMemoryFormat inMemoryFormat) {
        String value;
        int i;
        NearCacheConfig nearCacheConfig = this.createNearCacheConfig(inMemoryFormat);
        nearCacheConfig.setInvalidateOnChange(true);
        NearCacheTestContext nearCacheTestContext1 = this.createNearCacheTest(DEFAULT_CACHE_NAME, nearCacheConfig);
        final NearCacheTestContext nearCacheTestContext2 = this.createNearCacheTest(DEFAULT_CACHE_NAME, nearCacheConfig);
        for (i = 0; i < 100; ++i) {
            nearCacheTestContext1.cache.put((Object)i, (Object)this.generateValueFromKey(i));
        }
        for (i = 0; i < 100; ++i) {
            final Integer key = i;
            value = (String)nearCacheTestContext2.cache.get((Object)key);
            ClientNearCacheTestSupport.assertTrueEventually((AssertTask)new AssertTask(){

                public void run() throws Exception {
                    Data keyData = nearCacheTestContext2.serializationService.toData((Object)key);
                    Assert.assertEquals((Object)value, (Object)nearCacheTestContext2.nearCache.get((Object)keyData));
                }
            });
        }
        for (i = 0; i < 100; ++i) {
            nearCacheTestContext1.cache.put((Object)i, (Object)this.generateValueFromKey(100 + i));
        }
        i = 0;
        while (i < 100) {
            final int key = i++;
            ClientNearCacheTestSupport.assertTrueEventually((AssertTask)new AssertTask(){

                public void run() throws Exception {
                    Data keyData = nearCacheTestContext2.serializationService.toData((Object)key);
                    Assert.assertNull((Object)nearCacheTestContext2.nearCache.get((Object)keyData));
                }
            });
        }
        for (i = 0; i < 100; ++i) {
            final Integer key = i;
            value = (String)nearCacheTestContext2.cache.get((Object)key);
            ClientNearCacheTestSupport.assertTrueEventually((AssertTask)new AssertTask(){

                public void run() throws Exception {
                    Data keyData = nearCacheTestContext2.serializationService.toData((Object)key);
                    Assert.assertEquals((Object)value, (Object)nearCacheTestContext2.nearCache.get((Object)keyData));
                }
            });
        }
    }

    protected void putToCacheAndGetInvalidationEventWhenNodeShutdown(InMemoryFormat inMemoryFormat) {
        String key;
        Config config = this.createConfig();
        config.setProperty(GroupProperty.CACHE_INVALIDATION_MESSAGE_BATCH_SIZE.getName(), String.valueOf(Integer.MAX_VALUE));
        config.setProperty(GroupProperty.CACHE_INVALIDATION_MESSAGE_BATCH_FREQUENCY_SECONDS.getName(), String.valueOf(Integer.MAX_VALUE));
        HazelcastInstance instanceToShutdown = this.hazelcastFactory.newHazelcastInstance(config);
        ClientNearCacheTestSupport.warmUpPartitions((HazelcastInstance[])new HazelcastInstance[]{this.serverInstance, instanceToShutdown});
        ClientNearCacheTestSupport.waitAllForSafeState((HazelcastInstance[])new HazelcastInstance[]{this.serverInstance, instanceToShutdown});
        NearCacheConfig nearCacheConfig = this.createNearCacheConfig(inMemoryFormat);
        nearCacheConfig.setInvalidateOnChange(true);
        nearCacheConfig.setLocalUpdatePolicy(NearCacheConfig.LocalUpdatePolicy.CACHE_ON_UPDATE);
        final NearCacheTestContext nearCacheTestContext1 = this.createNearCacheTest(DEFAULT_CACHE_NAME, nearCacheConfig);
        NearCacheTestContext nearCacheTestContext2 = this.createNearCacheTest(DEFAULT_CACHE_NAME, nearCacheConfig);
        HashMap<String, String> keyAndValues = new HashMap<String, String>();
        for (int i = 0; i < 100; ++i) {
            String key2 = ClientNearCacheTestSupport.generateKeyOwnedBy((HazelcastInstance)instanceToShutdown);
            String value = this.generateValueFromKey(i);
            nearCacheTestContext1.cache.put((Object)key2, (Object)value);
            keyAndValues.put(key2, value);
        }
        for (Map.Entry entry : keyAndValues.entrySet()) {
            key = (String)entry.getKey();
            String exceptedValue = (String)entry.getValue();
            String actualValue = (String)nearCacheTestContext1.nearCache.get((Object)nearCacheTestContext1.serializationService.toData((Object)key));
            Assert.assertEquals((Object)exceptedValue, (Object)actualValue);
        }
        for (Map.Entry entry : keyAndValues.entrySet()) {
            nearCacheTestContext2.cache.remove(entry.getKey());
        }
        ((LifecycleServiceImpl)instanceToShutdown.getLifecycleService()).fireLifecycleEvent(LifecycleEvent.LifecycleState.SHUTTING_DOWN);
        for (Map.Entry entry : keyAndValues.entrySet()) {
            key = (String)entry.getKey();
            ClientNearCacheTestSupport.assertTrueEventually((AssertTask)new AssertTask(){

                public void run() throws Exception {
                    Data keyData = nearCacheTestContext1.serializationService.toData((Object)key);
                    Assert.assertNull((Object)nearCacheTestContext1.nearCache.get((Object)keyData));
                }
            });
        }
    }

    protected void putToCacheAndRemoveFromOtherNodeThenCantGetUpdatedFromClientNearCache(InMemoryFormat inMemoryFormat) {
        int i;
        NearCacheConfig nearCacheConfig = this.createNearCacheConfig(inMemoryFormat);
        nearCacheConfig.setInvalidateOnChange(true);
        NearCacheTestContext nearCacheTestContext1 = this.createNearCacheTest(DEFAULT_CACHE_NAME, nearCacheConfig);
        final NearCacheTestContext nearCacheTestContext2 = this.createNearCacheTest(DEFAULT_CACHE_NAME, nearCacheConfig);
        for (i = 0; i < 100; ++i) {
            nearCacheTestContext1.cache.put((Object)i, (Object)this.generateValueFromKey(i));
        }
        for (i = 0; i < 100; ++i) {
            final Integer key = i;
            final String value = (String)nearCacheTestContext2.cache.get((Object)key);
            ClientNearCacheTestSupport.assertTrueEventually((AssertTask)new AssertTask(){

                public void run() throws Exception {
                    Data keyData = nearCacheTestContext2.serializationService.toData((Object)key);
                    Assert.assertEquals((Object)value, (Object)nearCacheTestContext2.nearCache.get((Object)keyData));
                }
            });
        }
        for (i = 0; i < 100; ++i) {
            nearCacheTestContext1.cache.remove((Object)i);
        }
        i = 0;
        while (i < 100) {
            final int key = i++;
            ClientNearCacheTestSupport.assertTrueEventually((AssertTask)new AssertTask(){

                public void run() throws Exception {
                    Data keyData = nearCacheTestContext2.serializationService.toData((Object)key);
                    Assert.assertNull((Object)nearCacheTestContext2.nearCache.get((Object)keyData));
                }
            });
        }
    }

    protected void testLoadAllNearCacheInvalidation(InMemoryFormat inMemoryFormat) throws Exception {
        NearCacheConfig nearCacheConfig = this.createNearCacheConfig(inMemoryFormat);
        nearCacheConfig.setInvalidateOnChange(true);
        NearCacheTestContext nearCacheTestContext1 = this.createNearCacheTest(DEFAULT_CACHE_NAME, nearCacheConfig);
        final NearCacheTestContext nearCacheTestContext2 = this.createNearCacheTest(DEFAULT_CACHE_NAME, nearCacheConfig);
        HashSet<Integer> testKeys = new HashSet<Integer>(100);
        HashSet<Integer> loadKeys = new HashSet<Integer>(50);
        for (int i = 0; i < 100; ++i) {
            if (i % 2 == 0) {
                loadKeys.add(i);
            }
            testKeys.add(i);
        }
        Iterator i = testKeys.iterator();
        while (i.hasNext()) {
            int i2 = (Integer)i.next();
            nearCacheTestContext1.cache.put((Object)i2, (Object)this.generateValueFromKey(i2));
        }
        final CountDownLatch completed = new CountDownLatch(1);
        nearCacheTestContext1.cache.loadAll(loadKeys, true, new CompletionListener(){

            public void onCompletion() {
                completed.countDown();
            }

            public void onException(Exception e) {
            }
        });
        completed.await(3L, TimeUnit.SECONDS);
        Iterator iterator = loadKeys.iterator();
        while (iterator.hasNext()) {
            int i3;
            final int key = i3 = ((Integer)iterator.next()).intValue();
            ClientNearCacheTestSupport.assertTrueEventually((AssertTask)new AssertTask(){

                public void run() throws Exception {
                    Data keyData = nearCacheTestContext2.serializationService.toData((Object)key);
                    Assert.assertNull((Object)nearCacheTestContext2.nearCache.get((Object)keyData));
                }
            });
        }
    }

    protected void putToCacheAndClearOrDestroyThenCantGetAnyRecordFromClientNearCache(InMemoryFormat inMemoryFormat) {
        int i;
        NearCacheConfig nearCacheConfig = this.createNearCacheConfig(inMemoryFormat);
        nearCacheConfig.setInvalidateOnChange(true);
        NearCacheTestContext nearCacheTestContext1 = this.createNearCacheTest(DEFAULT_CACHE_NAME, nearCacheConfig);
        final NearCacheTestContext nearCacheTestContext2 = this.createNearCacheTest(DEFAULT_CACHE_NAME, nearCacheConfig);
        for (i = 0; i < 100; ++i) {
            nearCacheTestContext1.cache.put((Object)i, (Object)this.generateValueFromKey(i));
        }
        for (i = 0; i < 100; ++i) {
            final Integer key = i;
            final String value = (String)nearCacheTestContext2.cache.get((Object)key);
            ClientNearCacheTestSupport.assertTrueEventually((AssertTask)new AssertTask(){

                public void run() throws Exception {
                    Data keyData = nearCacheTestContext2.serializationService.toData((Object)key);
                    Assert.assertEquals((Object)value, (Object)nearCacheTestContext2.nearCache.get((Object)keyData));
                }
            });
        }
        nearCacheTestContext1.cache.clear();
        i = 0;
        while (i < 100) {
            final int key = i++;
            ClientNearCacheTestSupport.assertTrueEventually((AssertTask)new AssertTask(){

                public void run() throws Exception {
                    Data keyData = nearCacheTestContext2.serializationService.toData((Object)key);
                    Assert.assertNull((Object)nearCacheTestContext2.nearCache.get((Object)keyData));
                }
            });
        }
    }

    protected void doTestGetAllReturnsFromNearCache(InMemoryFormat inMemoryFormat) {
        int i;
        if (inMemoryFormat != InMemoryFormat.OBJECT) {
            return;
        }
        NearCacheConfig nearCacheConfig = this.createNearCacheConfig(inMemoryFormat);
        NearCacheTestContext nearCacheTestContext = this.createNearCacheTestAndFillWithData(DEFAULT_CACHE_NAME, nearCacheConfig);
        for (i = 0; i < 100; ++i) {
            Assert.assertNull((Object)nearCacheTestContext.nearCache.get((Object)nearCacheTestContext.serializationService.toData((Object)i)));
        }
        for (i = 0; i < 100; ++i) {
            nearCacheTestContext.cache.get((Object)i);
        }
        for (i = 0; i < 100; ++i) {
            Data keyData = nearCacheTestContext.serializationService.toData((Object)i);
            Assert.assertSame((Object)nearCacheTestContext.cache.get((Object)i), (Object)nearCacheTestContext.nearCache.get((Object)keyData));
        }
    }

    protected void putToCacheAndDontInvalidateFromClientNearCacheWhenPerEntryInvalidationIsDisabled(InMemoryFormat inMemoryFormat) {
        int i;
        int i2;
        CacheConfig cacheConfig = this.createCacheConfig(inMemoryFormat);
        cacheConfig.setDisablePerEntryInvalidationEvents(true);
        NearCacheConfig nearCacheConfig = this.createNearCacheConfig(inMemoryFormat);
        nearCacheConfig.setInvalidateOnChange(true);
        NearCacheTestContext nearCacheTestContext1 = this.createNearCacheTest(DEFAULT_CACHE_NAME, nearCacheConfig, cacheConfig);
        final NearCacheTestContext nearCacheTestContext2 = this.createNearCacheTest(DEFAULT_CACHE_NAME, nearCacheConfig, cacheConfig);
        for (i2 = 0; i2 < 100; ++i2) {
            nearCacheTestContext1.cache.put((Object)i2, (Object)this.generateValueFromKey(i2));
        }
        for (i2 = 0; i2 < 100; ++i2) {
            final Integer key = i2;
            final String value = (String)nearCacheTestContext2.cache.get((Object)key);
            ClientNearCacheTestSupport.assertTrueEventually((AssertTask)new AssertTask(){

                public void run() throws Exception {
                    Data keyData = nearCacheTestContext2.serializationService.toData((Object)key);
                    Assert.assertEquals((Object)value, (Object)nearCacheTestContext2.nearCache.get((Object)keyData));
                }
            });
        }
        for (i2 = 0; i2 < 100; ++i2) {
            nearCacheTestContext1.cache.put((Object)i2, (Object)this.generateValueFromKey(i2 + 100));
        }
        int invalidationEventFlushFreq = Integer.parseInt(GroupProperty.CACHE_INVALIDATION_MESSAGE_BATCH_FREQUENCY_SECONDS.getDefaultValue());
        ClientNearCacheTestSupport.sleepSeconds((int)(2 * invalidationEventFlushFreq));
        for (i = 0; i < 100; ++i) {
            String actualValue = (String)nearCacheTestContext2.cache.get((Object)i);
            String expectedValue = this.generateValueFromKey(i);
            Assert.assertEquals((Object)expectedValue, (Object)actualValue);
        }
        nearCacheTestContext1.cache.clear();
        i = 0;
        while (i < 100) {
            final int key = i++;
            ClientNearCacheTestSupport.assertTrueEventually((AssertTask)new AssertTask(){

                public void run() throws Exception {
                    Data keyData = nearCacheTestContext2.serializationService.toData((Object)key);
                    Assert.assertNull((Object)nearCacheTestContext2.nearCache.get((Object)keyData));
                }
            });
        }
    }

    protected void testNearCacheExpiration_withTTL(InMemoryFormat inMemoryFormat) {
        NearCacheConfig nearCacheConfig = this.createNearCacheConfig(inMemoryFormat);
        nearCacheConfig.setTimeToLiveSeconds(2);
        this.testNearCacheExpiration(nearCacheConfig, 2);
    }

    protected void testNearCacheExpiration_withMaxIdle(InMemoryFormat inMemoryFormat) {
        NearCacheConfig nearCacheConfig = this.createNearCacheConfig(inMemoryFormat);
        nearCacheConfig.setTimeToLiveSeconds(1);
        this.testNearCacheExpiration(nearCacheConfig, 1);
    }

    private void testNearCacheExpiration(NearCacheConfig nearCacheConfig, int expireSeconds) {
        int size = 147;
        final NearCacheTestContext context = this.createNearCacheTest(DEFAULT_CACHE_NAME, nearCacheConfig);
        for (int i = 0; i < 147; ++i) {
            context.cache.put((Object)i, (Object)("value-" + i));
            context.cache.get((Object)i);
        }
        final NearCacheStats statsBeforeExpiration = this.getNearCacheStats(context.cache);
        Assert.assertTrue((String)String.format("we expected to have all cache entries in the Near Cache or already expired (%s)", statsBeforeExpiration), (statsBeforeExpiration.getOwnedEntryCount() + statsBeforeExpiration.getExpirations() >= 0L ? 1 : 0) != 0);
        ClientNearCacheTestSupport.sleepSeconds((int)(expireSeconds + 1));
        ClientNearCacheTestSupport.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() {
                context.cache.get((Object)0);
                NearCacheStats stats = ClientNearCacheTestSupport.this.getNearCacheStats(context.cache);
                Assert.assertEquals((String)"we expect the same hits", (long)statsBeforeExpiration.getHits(), (long)stats.getHits());
                Assert.assertEquals((String)"we expect the same misses", (long)statsBeforeExpiration.getMisses(), (long)stats.getMisses());
                Assert.assertEquals((String)"we expect all entries beside the 'trigger entry' to be deleted from the Near Cache", (long)1L, (long)stats.getOwnedEntryCount());
                Assert.assertEquals((String)"we did not expect any entries to be evicted from the Near Cache", (long)0L, (long)stats.getEvictions());
                Assert.assertTrue((String)String.format("we expect at least %d entries to be expired from the Near Cache", 147), (stats.getExpirations() >= 147L ? 1 : 0) != 0);
            }
        });
    }

    protected NearCacheStats getNearCacheStats(ICache cache) {
        return cache.getLocalCacheStatistics().getNearCacheStatistics();
    }

    public static class TestCacheLoader
    implements CacheLoader<Integer, String> {
        public String load(Integer key) throws CacheLoaderException {
            return String.valueOf(2 * key);
        }

        public Map<Integer, String> loadAll(Iterable<? extends Integer> keys) throws CacheLoaderException {
            HashMap<Integer, String> entries = new HashMap<Integer, String>();
            Iterator<? extends Integer> iterator = keys.iterator();
            while (iterator.hasNext()) {
                int key = iterator.next();
                entries.put(key, String.valueOf(2 * key));
            }
            return entries;
        }
    }
}

