/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.cache.impl.nearcache.invalidation;

import com.hazelcast.cache.impl.CacheEventHandler;
import com.hazelcast.cache.impl.CacheService;
import com.hazelcast.client.cache.impl.ClientCacheProxy;
import com.hazelcast.client.cache.impl.HazelcastClientCachingProvider;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.impl.HazelcastClientProxy;
import com.hazelcast.client.spi.ClientContext;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.CacheConfig;
import com.hazelcast.config.EvictionConfig;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.internal.nearcache.impl.invalidation.MetaDataContainer;
import com.hazelcast.internal.nearcache.impl.invalidation.MetaDataFetcher;
import com.hazelcast.internal.nearcache.impl.invalidation.MetaDataGenerator;
import com.hazelcast.internal.nearcache.impl.invalidation.RepairingHandler;
import com.hazelcast.internal.nearcache.impl.invalidation.RepairingTask;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import com.hazelcast.util.RandomPicker;
import com.hazelcast.util.UuidUtil;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import javax.cache.Cache;
import javax.cache.configuration.Configuration;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientCacheMetaDataFetcherTest
extends HazelcastTestSupport {
    TestHazelcastFactory factory = new TestHazelcastFactory();

    @After
    public void tearDown() throws Exception {
        this.factory.shutdownAll();
    }

    @Test
    public void fetches_sequence_and_uuid() throws Exception {
        String cacheName = "test";
        int partition = 1;
        long givenSequence = RandomPicker.getInt((int)1, (int)Integer.MAX_VALUE);
        UUID givenUuid = UuidUtil.newSecureUUID();
        RepairingTask repairingTask = this.getRepairingTask(cacheName, partition, givenSequence, givenUuid);
        MetaDataFetcher metaDataFetcher = repairingTask.getMetaDataFetcher();
        ConcurrentMap handlers = repairingTask.getHandlers();
        metaDataFetcher.fetchMetadata(handlers);
        RepairingHandler repairingHandler = (RepairingHandler)handlers.get(this.getPrefixedName(cacheName));
        MetaDataContainer metaDataContainer = repairingHandler.getMetaDataContainer(partition);
        UUID foundUuid = metaDataContainer.getUuid();
        long foundSequence = metaDataContainer.getSequence();
        Assert.assertEquals((long)givenSequence, (long)foundSequence);
        Assert.assertEquals((Object)givenUuid, (Object)foundUuid);
    }

    private RepairingTask getRepairingTask(String cacheName, int partition, long givenSequence, UUID givenUuid) {
        HazelcastInstance member = this.factory.newHazelcastInstance();
        this.distortRandomPartitionSequence(this.getPrefixedName(cacheName), partition, givenSequence, member);
        this.distortRandomPartitionUuid(partition, givenUuid, member);
        ClientConfig clientConfig = new ClientConfig().addNearCacheConfig(new NearCacheConfig(cacheName));
        HazelcastClientProxy client = (HazelcastClientProxy)this.factory.newHazelcastClient(clientConfig);
        HazelcastClientCachingProvider clientCachingProvider = HazelcastClientCachingProvider.createCachingProvider((HazelcastInstance)client);
        Cache clientCache = clientCachingProvider.getCacheManager().createCache(cacheName, (Configuration)this.newCacheConfig());
        ClientContext clientContext = ((ClientCacheProxy)clientCache).getClientContext();
        return clientContext.getRepairingTask("hz:impl:cacheService");
    }

    private void distortRandomPartitionSequence(String cacheName, int partition, long sequence, HazelcastInstance member) {
        NodeEngineImpl nodeEngineImpl = ClientCacheMetaDataFetcherTest.getNodeEngineImpl((HazelcastInstance)member);
        CacheService service = (CacheService)nodeEngineImpl.getService("hz:impl:cacheService");
        CacheEventHandler cacheEventHandler = service.getCacheEventHandler();
        MetaDataGenerator metaDataGenerator = cacheEventHandler.getMetaDataGenerator();
        metaDataGenerator.setCurrentSequence(cacheName, partition, sequence);
    }

    private void distortRandomPartitionUuid(int partition, UUID uuid, HazelcastInstance member) {
        NodeEngineImpl nodeEngineImpl = ClientCacheMetaDataFetcherTest.getNodeEngineImpl((HazelcastInstance)member);
        CacheService service = (CacheService)nodeEngineImpl.getService("hz:impl:cacheService");
        CacheEventHandler cacheEventHandler = service.getCacheEventHandler();
        MetaDataGenerator metaDataGenerator = cacheEventHandler.getMetaDataGenerator();
        metaDataGenerator.setUuid(partition, uuid);
    }

    private CacheConfig newCacheConfig() {
        CacheConfig cacheConfig = new CacheConfig();
        cacheConfig.getEvictionConfig().setMaximumSizePolicy(EvictionConfig.MaxSizePolicy.ENTRY_COUNT).setSize(Integer.MAX_VALUE);
        return cacheConfig;
    }

    private String getPrefixedName(String cacheName) {
        return "/hz/" + cacheName;
    }
}

