/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.cache.instance;

import com.hazelcast.cache.instance.CacheThroughHazelcastInstanceTest;
import com.hazelcast.client.HazelcastClientNotActiveException;
import com.hazelcast.client.cache.impl.HazelcastClientCachingProvider;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.Config;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import javax.cache.spi.CachingProvider;
import org.junit.After;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientCacheThroughHazelcastInstanceTest
extends CacheThroughHazelcastInstanceTest {
    private TestHazelcastFactory instanceFactory;
    private HazelcastInstance ownerInstance;

    protected CachingProvider createCachingProvider(HazelcastInstance instance) {
        return HazelcastClientCachingProvider.createCachingProvider((HazelcastInstance)instance);
    }

    protected HazelcastInstance createInstance() {
        if (this.instanceFactory != null) {
            throw new IllegalStateException("There should not be multiple creation of TestHazelcastFactory!");
        }
        this.instanceFactory = new TestHazelcastFactory();
        this.ownerInstance = this.instanceFactory.newHazelcastInstance();
        return this.instanceFactory.newHazelcastClient();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HazelcastInstance createInstance(Config config) {
        if (this.instanceFactory != null) {
            throw new IllegalStateException("There should not be multiple creation of TestHazelcastFactory!");
        }
        this.instanceFactory = new TestHazelcastFactory();
        this.ownerInstance = this.instanceFactory.newHazelcastInstance(config);
        if (config.getClassLoader() != null) {
            ClassLoader tccl = Thread.currentThread().getContextClassLoader();
            try {
                ClientConfig clientConfig = new ClientConfig();
                clientConfig.setClassLoader(config.getClassLoader());
                Thread.currentThread().setContextClassLoader(config.getClassLoader());
                HazelcastInstance hazelcastInstance = this.instanceFactory.newHazelcastClient(clientConfig);
                return hazelcastInstance;
            }
            finally {
                Thread.currentThread().setContextClassLoader(tccl);
            }
        }
        return this.instanceFactory.newHazelcastClient();
    }

    protected void shutdownOwnerInstance(HazelcastInstance instance) {
        if (this.ownerInstance == null) {
            throw new IllegalStateException("");
        }
        this.ownerInstance.shutdown();
    }

    protected Class<? extends Exception> getInstanceNotActiveExceptionType() {
        return HazelcastClientNotActiveException.class;
    }

    @After
    public void tearDown() {
        if (this.instanceFactory != null) {
            this.ownerInstance = null;
            this.instanceFactory.shutdownAll();
            this.instanceFactory = null;
        }
    }
}

