/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.cache.nearcache;

import com.hazelcast.cache.ICache;
import com.hazelcast.cache.impl.HazelcastServerCacheManager;
import com.hazelcast.cache.impl.HazelcastServerCachingProvider;
import com.hazelcast.client.cache.impl.HazelcastClientCacheManager;
import com.hazelcast.client.cache.impl.HazelcastClientCachingProvider;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.impl.HazelcastClientProxy;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.CacheConfig;
import com.hazelcast.config.EvictionConfig;
import com.hazelcast.config.EvictionPolicy;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.internal.adapter.DataStructureAdapter;
import com.hazelcast.internal.adapter.ICacheDataStructureAdapter;
import com.hazelcast.internal.nearcache.AbstractBasicNearCacheTest;
import com.hazelcast.internal.nearcache.NearCache;
import com.hazelcast.internal.nearcache.NearCacheManager;
import com.hazelcast.internal.nearcache.NearCacheTestContext;
import com.hazelcast.internal.nearcache.NearCacheTestUtils;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.test.HazelcastParametersRunnerFactory;
import com.hazelcast.test.annotation.QuickTest;
import java.util.Arrays;
import java.util.Collection;
import javax.cache.Cache;
import javax.cache.CacheManager;
import org.junit.After;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Parameterized.UseParametersRunnerFactory(value=HazelcastParametersRunnerFactory.class)
@Category(value={QuickTest.class})
public class BasicClientCacheNearCacheTest
extends AbstractBasicNearCacheTest<Data, String> {
    @Parameterized.Parameter
    public InMemoryFormat inMemoryFormat;
    @Parameterized.Parameter(value=1)
    public NearCacheConfig.LocalUpdatePolicy localUpdatePolicy;
    private final TestHazelcastFactory hazelcastFactory = new TestHazelcastFactory();

    @Parameterized.Parameters(name="format:{0} {1}")
    public static Collection<Object[]> parameters() {
        return Arrays.asList({InMemoryFormat.BINARY, NearCacheConfig.LocalUpdatePolicy.INVALIDATE}, {InMemoryFormat.BINARY, NearCacheConfig.LocalUpdatePolicy.CACHE_ON_UPDATE}, {InMemoryFormat.OBJECT, NearCacheConfig.LocalUpdatePolicy.INVALIDATE}, {InMemoryFormat.OBJECT, NearCacheConfig.LocalUpdatePolicy.CACHE_ON_UPDATE});
    }

    @Before
    public void setUp() {
        this.nearCacheConfig = NearCacheTestUtils.createNearCacheConfig((InMemoryFormat)this.inMemoryFormat).setLocalUpdatePolicy(this.localUpdatePolicy);
    }

    @After
    public void tearDown() {
        this.hazelcastFactory.shutdownAll();
    }

    protected <K, V> NearCacheTestContext<K, V, Data, String> createContext() {
        ClientConfig clientConfig = this.getClientConfig().addNearCacheConfig(this.nearCacheConfig);
        CacheConfig<K, V> cacheConfig = this.createCacheConfig(this.nearCacheConfig);
        HazelcastInstance member = this.hazelcastFactory.newHazelcastInstance(this.getConfig());
        HazelcastClientProxy client = (HazelcastClientProxy)this.hazelcastFactory.newHazelcastClient(clientConfig);
        HazelcastServerCachingProvider memberProvider = HazelcastServerCachingProvider.createCachingProvider((HazelcastInstance)member);
        HazelcastServerCacheManager memberCacheManager = (HazelcastServerCacheManager)memberProvider.getCacheManager();
        NearCacheManager nearCacheManager = client.client.getNearCacheManager();
        HazelcastClientCachingProvider provider = HazelcastClientCachingProvider.createCachingProvider((HazelcastInstance)client);
        HazelcastClientCacheManager cacheManager = (HazelcastClientCacheManager)provider.getCacheManager();
        String cacheNameWithPrefix = cacheManager.getCacheNameWithPrefix("defaultNearCache");
        ICache clientCache = cacheManager.createCache("defaultNearCache", cacheConfig);
        ICache memberCache = memberCacheManager.createCache("defaultNearCache", cacheConfig);
        NearCache nearCache = nearCacheManager.getNearCache(cacheNameWithPrefix);
        return new NearCacheTestContext(client.getSerializationService(), (HazelcastInstance)client, member, (DataStructureAdapter)new ICacheDataStructureAdapter((Cache)clientCache), (DataStructureAdapter)new ICacheDataStructureAdapter((Cache)memberCache), false, nearCache, nearCacheManager, (CacheManager)cacheManager, memberCacheManager);
    }

    protected ClientConfig getClientConfig() {
        return new ClientConfig();
    }

    private <K, V> CacheConfig<K, V> createCacheConfig(NearCacheConfig nearCacheConfig) {
        CacheConfig cacheConfig = new CacheConfig().setName("defaultNearCache").setInMemoryFormat(nearCacheConfig.getInMemoryFormat());
        if (nearCacheConfig.getInMemoryFormat() == InMemoryFormat.NATIVE) {
            cacheConfig.getEvictionConfig().setEvictionPolicy(EvictionPolicy.LRU).setMaximumSizePolicy(EvictionConfig.MaxSizePolicy.USED_NATIVE_MEMORY_PERCENTAGE).setSize(90);
        }
        return cacheConfig;
    }

    @Test
    @Ignore(value="The AbstractClientCacheProxy is missing `invalidateNearCache(keyData)` calls")
    public void whenPutAllIsUsed_thenNearCacheShouldBeInvalidated_withUpdateOnNearCacheAdapter() {
    }
}

