/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.cache.nearcache;

import com.hazelcast.cache.CacheUtil;
import com.hazelcast.cache.ICache;
import com.hazelcast.cache.impl.HazelcastServerCacheManager;
import com.hazelcast.cache.impl.HazelcastServerCachingProvider;
import com.hazelcast.client.cache.impl.HazelcastClientCacheManager;
import com.hazelcast.client.cache.impl.HazelcastClientCachingProvider;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.impl.HazelcastClientProxy;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.CacheConfig;
import com.hazelcast.config.EvictionConfig;
import com.hazelcast.config.EvictionPolicy;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.internal.adapter.DataStructureAdapter;
import com.hazelcast.internal.adapter.ICacheDataStructureAdapter;
import com.hazelcast.internal.nearcache.AbstractNearCachePreloaderTest;
import com.hazelcast.internal.nearcache.NearCache;
import com.hazelcast.internal.nearcache.NearCacheManager;
import com.hazelcast.internal.nearcache.NearCacheTestContext;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.serialization.SerializationService;
import com.hazelcast.test.HazelcastParametersRunnerFactory;
import com.hazelcast.test.annotation.QuickTest;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import javax.cache.Cache;
import javax.cache.CacheManager;
import org.junit.After;
import org.junit.Before;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Parameterized.UseParametersRunnerFactory(value=HazelcastParametersRunnerFactory.class)
@Category(value={QuickTest.class})
public class ClientCacheNearCachePreloaderTest
extends AbstractNearCachePreloaderTest<Data, String> {
    private static final String CACHE_FILE_NAME = IOUtil.toFileName((String)CacheUtil.getDistributedObjectName((String)"defaultNearCache"));
    private static final File DEFAULT_STORE_FILE = new File("nearCache-" + CACHE_FILE_NAME + ".store").getAbsoluteFile();
    private static final File DEFAULT_STORE_LOCK_FILE = new File(DEFAULT_STORE_FILE.getName() + ".lock").getAbsoluteFile();
    @Parameterized.Parameter
    public boolean invalidationOnChange;
    private final TestHazelcastFactory hazelcastFactory = new TestHazelcastFactory();

    @Parameterized.Parameters(name="invalidationOnChange:{0}")
    public static Collection<Object[]> parameters() {
        return Arrays.asList({false}, {true});
    }

    @Before
    public void setUp() {
        this.nearCacheConfig = this.getNearCacheConfig(this.invalidationOnChange, 10023, DEFAULT_STORE_FILE.getParent());
    }

    @After
    public void tearDown() {
        this.hazelcastFactory.shutdownAll();
    }

    protected File getDefaultStoreFile() {
        return DEFAULT_STORE_FILE;
    }

    protected File getDefaultStoreLockFile() {
        return DEFAULT_STORE_LOCK_FILE;
    }

    protected <K, V> NearCacheTestContext<K, V, Data, String> createContext(boolean createClient) {
        CacheConfig<K, V> cacheConfig = this.createCacheConfig(this.nearCacheConfig);
        HazelcastInstance member = this.hazelcastFactory.newHazelcastInstance(this.getConfig());
        HazelcastServerCachingProvider memberProvider = HazelcastServerCachingProvider.createCachingProvider((HazelcastInstance)member);
        HazelcastServerCacheManager memberCacheManager = (HazelcastServerCacheManager)memberProvider.getCacheManager();
        ICache memberCache = memberCacheManager.createCache("defaultNearCache", cacheConfig);
        if (!createClient) {
            return new NearCacheTestContext((SerializationService)ClientCacheNearCachePreloaderTest.getSerializationService((HazelcastInstance)member), member, (DataStructureAdapter)new ICacheDataStructureAdapter((Cache)memberCache), false, null, null);
        }
        NearCacheTestContext<K, V, Data, String> clientContext = this.createClientContext(cacheConfig);
        return new NearCacheTestContext(clientContext.serializationService, clientContext.nearCacheInstance, member, clientContext.nearCacheAdapter, (DataStructureAdapter)new ICacheDataStructureAdapter((Cache)memberCache), false, clientContext.nearCache, clientContext.nearCacheManager, clientContext.cacheManager, memberCacheManager);
    }

    protected <K, V> NearCacheTestContext<K, V, Data, String> createClientContext() {
        CacheConfig<K, V> cacheConfig = this.createCacheConfig(this.nearCacheConfig);
        return this.createClientContext(cacheConfig);
    }

    protected ClientConfig getClientConfig() {
        return new ClientConfig();
    }

    private <K, V> CacheConfig<K, V> createCacheConfig(NearCacheConfig nearCacheConfig) {
        CacheConfig cacheConfig = new CacheConfig().setName("defaultNearCache").setInMemoryFormat(nearCacheConfig.getInMemoryFormat());
        if (nearCacheConfig.getInMemoryFormat() == InMemoryFormat.NATIVE) {
            cacheConfig.getEvictionConfig().setEvictionPolicy(EvictionPolicy.LRU).setMaximumSizePolicy(EvictionConfig.MaxSizePolicy.USED_NATIVE_MEMORY_PERCENTAGE).setSize(90);
        }
        return cacheConfig;
    }

    private <K, V> NearCacheTestContext<K, V, Data, String> createClientContext(CacheConfig<K, V> cacheConfig) {
        ClientConfig clientConfig = this.getClientConfig().addNearCacheConfig(this.nearCacheConfig);
        HazelcastClientProxy client = (HazelcastClientProxy)this.hazelcastFactory.newHazelcastClient(clientConfig);
        NearCacheManager nearCacheManager = client.client.getNearCacheManager();
        HazelcastClientCachingProvider provider = HazelcastClientCachingProvider.createCachingProvider((HazelcastInstance)client);
        HazelcastClientCacheManager cacheManager = (HazelcastClientCacheManager)provider.getCacheManager();
        String cacheNameWithPrefix = cacheManager.getCacheNameWithPrefix("defaultNearCache");
        ICache clientCache = cacheManager.createCache("defaultNearCache", cacheConfig);
        NearCache nearCache = nearCacheManager.getNearCache(cacheNameWithPrefix);
        return new NearCacheTestContext(client.getSerializationService(), (HazelcastInstance)client, null, (DataStructureAdapter)new ICacheDataStructureAdapter((Cache)clientCache), null, false, nearCache, nearCacheManager, (CacheManager)cacheManager, null);
    }
}

