/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.cache.stats;

import com.hazelcast.cache.CacheStatistics;
import com.hazelcast.cache.ICache;
import com.hazelcast.cache.stats.CacheStatsTest;
import com.hazelcast.client.cache.impl.HazelcastClientCachingProvider;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.impl.HazelcastClientProxy;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.CacheConfig;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.annotation.QuickTest;
import javax.cache.spi.CachingProvider;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class})
public class ClientCacheStatsTest
extends CacheStatsTest {
    private final TestHazelcastFactory instanceFactory = new TestHazelcastFactory();
    private HazelcastInstance client;

    protected void onSetup() {
        super.onSetup();
        this.getHazelcastInstance();
        ClientConfig clientConfig = this.createClientConfig();
        this.client = this.instanceFactory.newHazelcastClient(clientConfig);
    }

    protected void onTearDown() {
        super.onTearDown();
        this.instanceFactory.shutdownAll();
    }

    protected HazelcastInstance getHazelcastInstance() {
        return this.instanceFactory.newHazelcastInstance(this.createConfig());
    }

    protected CachingProvider getCachingProvider() {
        return HazelcastClientCachingProvider.createCachingProvider((HazelcastInstance)this.client);
    }

    protected ClientConfig createClientConfig() {
        return new ClientConfig();
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testOwnedEntryCountWhenThereIsNoBackup() {
        super.testOwnedEntryCountWhenThereIsNoBackup();
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testOwnedEntryCountWhenThereAreBackupsOnStaticCluster() {
        super.testOwnedEntryCountWhenThereAreBackupsOnStaticCluster();
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testOwnedEntryCountWhenThereAreBackupsOnDynamicCluster() {
        super.testOwnedEntryCountWhenThereAreBackupsOnDynamicCluster();
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testExpirations() {
        super.testExpirations();
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testEvictions() {
        super.testEvictions();
    }

    @Test
    public void testNearCacheStatsWhenNearCacheEnabled() {
        String cacheName = ClientCacheStatsTest.randomName();
        CacheConfig cacheConfig = this.createCacheConfig();
        cacheConfig.setName(cacheName);
        ClientConfig clientConfig = ((HazelcastClientProxy)this.client).getClientConfig();
        clientConfig.addNearCacheConfig(new NearCacheConfig().setName(cacheName));
        ICache cache = this.createCache(cacheName, cacheConfig);
        CacheStatistics stats = cache.getLocalCacheStatistics();
        Assert.assertNotNull((Object)stats.getNearCacheStatistics());
    }
}

