/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.cardinality;

import com.hazelcast.cardinality.CardinalityEstimator;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.SerializerConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.HazelcastSerializationException;
import com.hazelcast.nio.serialization.Serializer;
import com.hazelcast.nio.serialization.StreamSerializer;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.io.IOException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientCardinalityEstimatorTest
extends HazelcastTestSupport {
    private final TestHazelcastFactory hazelcastFactory = new TestHazelcastFactory();
    private HazelcastInstance client;
    private CardinalityEstimator estimator;

    @Before
    public void setup() {
        this.hazelcastFactory.newHazelcastInstance();
        this.client = this.hazelcastFactory.newHazelcastClient();
    }

    @After
    public void tearDown() {
        this.hazelcastFactory.terminateAll();
    }

    private HazelcastInstance createSerializationConfiguredClient() {
        SerializerConfig serializerConfig = new SerializerConfig();
        serializerConfig.setImplementation((Serializer)new CustomObjectSerializer());
        serializerConfig.setTypeClass(CustomObject.class);
        ClientConfig config = new ClientConfig();
        config.getSerializationConfig().addSerializerConfig(serializerConfig);
        return this.hazelcastFactory.newHazelcastClient(config);
    }

    @Test
    public void estimate() {
        this.estimator = this.client.getCardinalityEstimator("estimate");
        Assert.assertEquals((long)0L, (long)this.estimator.estimate());
    }

    @Test
    public void estimateAsync() throws Exception {
        this.estimator = this.client.getCardinalityEstimator("estimateAsync");
        Assert.assertEquals((long)0L, (long)((Long)this.estimator.estimateAsync().get()));
    }

    @Test
    public void add() {
        this.estimator = this.client.getCardinalityEstimator("aggregate");
        this.estimator.add((Object)1L);
        Assert.assertEquals((long)1L, (long)this.estimator.estimate());
        this.estimator.add((Object)1L);
        this.estimator.add((Object)1L);
        Assert.assertEquals((long)1L, (long)this.estimator.estimate());
        this.estimator.add((Object)2L);
        this.estimator.add((Object)3L);
        Assert.assertEquals((long)3L, (long)this.estimator.estimate());
        this.estimator.add((Object)"Test");
        Assert.assertEquals((long)4L, (long)this.estimator.estimate());
    }

    @Test
    public void addAsync() throws Exception {
        this.estimator = this.client.getCardinalityEstimator("aggregateAsync");
        this.estimator.addAsync((Object)1L).get();
        Assert.assertEquals((long)1L, (long)((Long)this.estimator.estimateAsync().get()));
        this.estimator.addAsync((Object)1L).get();
        this.estimator.addAsync((Object)1L).get();
        Assert.assertEquals((long)1L, (long)((Long)this.estimator.estimateAsync().get()));
        this.estimator.addAsync((Object)2L).get();
        this.estimator.addAsync((Object)3L);
        Assert.assertEquals((long)3L, (long)((Long)this.estimator.estimateAsync().get()));
        this.estimator.addAsync((Object)"Test").get();
        Assert.assertEquals((long)4L, (long)((Long)this.estimator.estimateAsync().get()));
    }

    @Test
    public void addString() {
        this.estimator = this.client.getCardinalityEstimator("aggregateString");
        this.estimator.add((Object)"String1");
        Assert.assertEquals((long)1L, (long)this.estimator.estimate());
    }

    @Test
    public void addStringAsync() throws Exception {
        this.estimator = this.client.getCardinalityEstimator("aggregateStringAsync");
        this.estimator.addAsync((Object)"String1").get();
        Assert.assertEquals((long)1L, (long)((Long)this.estimator.estimateAsync().get()));
    }

    @Test(expected=HazelcastSerializationException.class)
    public void addCustomObject() {
        this.estimator = this.client.getCardinalityEstimator("aggregateCustomObject");
        this.estimator.add((Object)new CustomObject(1, 2));
    }

    @Test
    public void addCustomObjectRegisteredAsync() {
        this.estimator = this.createSerializationConfiguredClient().getCardinalityEstimator("aggregateCustomObjectAsync");
        Assert.assertEquals((long)0L, (long)this.estimator.estimate());
        this.estimator.add((Object)new CustomObject(1, 2));
        Assert.assertEquals((long)1L, (long)this.estimator.estimate());
    }

    @Test
    public void addCustomObjectRegistered() {
        this.estimator = this.createSerializationConfiguredClient().getCardinalityEstimator("aggregateCustomObject");
        Assert.assertEquals((long)0L, (long)this.estimator.estimate());
        this.estimator.add((Object)new CustomObject(1, 2));
        Assert.assertEquals((long)1L, (long)this.estimator.estimate());
    }

    private class CustomObjectSerializer
    implements StreamSerializer<CustomObject> {
        private CustomObjectSerializer() {
        }

        public int getTypeId() {
            return 1;
        }

        public void destroy() {
        }

        public void write(ObjectDataOutput out, CustomObject object) throws IOException {
            out.writeLong((long)(object.x << 4 | object.y));
        }

        public CustomObject read(ObjectDataInput in) throws IOException {
            throw new UnsupportedOperationException();
        }
    }

    private class CustomObject {
        private final int x;
        private final int y;

        private CustomObject(int x, int y) {
            this.x = x;
            this.y = y;
        }
    }
}

