/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.config;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.config.ConfigPatternMatcher;
import com.hazelcast.config.ConfigurationException;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.config.matcher.MatchingPointConfigPatternMatcher;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class MatchingPointConfigPatternMatcherTest {
    @Test
    public void testNearCacheConfigWithoutWildcard() {
        NearCacheConfig nearCacheConfig = new NearCacheConfig().setName("someNearCache");
        ClientConfig config = new ClientConfig();
        config.setConfigPatternMatcher((ConfigPatternMatcher)new MatchingPointConfigPatternMatcher());
        config.addNearCacheConfig(nearCacheConfig);
        Assert.assertEquals((Object)nearCacheConfig, (Object)config.getNearCacheConfig("someNearCache"));
        Assert.assertNotEquals((Object)nearCacheConfig, (Object)config.getNearCacheConfig("doesNotExist"));
        Assert.assertNotEquals((Object)nearCacheConfig, (Object)config.getNearCacheConfig("SomeNearCache"));
    }

    @Test
    public void testNearCacheConfigWildcard1() {
        NearCacheConfig nearCacheConfig = new NearCacheConfig().setName("*hazelcast.test.myNearCache");
        ClientConfig config = new ClientConfig();
        config.setConfigPatternMatcher((ConfigPatternMatcher)new MatchingPointConfigPatternMatcher());
        config.addNearCacheConfig(nearCacheConfig);
        Assert.assertEquals((Object)nearCacheConfig, (Object)config.getNearCacheConfig("com.hazelcast.test.myNearCache"));
    }

    @Test
    public void testNearCacheConfigWildcard2() {
        NearCacheConfig nearCacheConfig = new NearCacheConfig().setName("com.hazelcast.*.myNearCache");
        ClientConfig config = new ClientConfig();
        config.setConfigPatternMatcher((ConfigPatternMatcher)new MatchingPointConfigPatternMatcher());
        config.addNearCacheConfig(nearCacheConfig);
        Assert.assertEquals((Object)nearCacheConfig, (Object)config.getNearCacheConfig("com.hazelcast.test.myNearCache"));
    }

    @Test
    public void testNearCacheConfigWildcard3() {
        NearCacheConfig nearCacheConfig = new NearCacheConfig().setName("com.hazelcast.test.*");
        ClientConfig config = new ClientConfig();
        config.setConfigPatternMatcher((ConfigPatternMatcher)new MatchingPointConfigPatternMatcher());
        config.addNearCacheConfig(nearCacheConfig);
        Assert.assertEquals((Object)nearCacheConfig, (Object)config.getNearCacheConfig("com.hazelcast.test.myNearCache"));
    }

    @Test
    public void testNearCacheConfigWildcardMultipleConfigs() {
        NearCacheConfig nearCacheConfig1 = new NearCacheConfig().setName("com.hazelcast.*");
        NearCacheConfig nearCacheConfig2 = new NearCacheConfig().setName("com.hazelcast.test.*");
        NearCacheConfig nearCacheConfig3 = new NearCacheConfig().setName("com.hazelcast.test.sub.*");
        ClientConfig config = new ClientConfig();
        config.setConfigPatternMatcher((ConfigPatternMatcher)new MatchingPointConfigPatternMatcher());
        config.addNearCacheConfig(nearCacheConfig1);
        config.addNearCacheConfig(nearCacheConfig2);
        config.addNearCacheConfig(nearCacheConfig3);
        Assert.assertEquals((Object)nearCacheConfig1, (Object)config.getNearCacheConfig("com.hazelcast.myNearCache"));
        Assert.assertEquals((Object)nearCacheConfig2, (Object)config.getNearCacheConfig("com.hazelcast.test.myNearCache"));
        Assert.assertEquals((Object)nearCacheConfig3, (Object)config.getNearCacheConfig("com.hazelcast.test.sub.myNearCache"));
    }

    @Test(expected=ConfigurationException.class)
    public void testMapConfigWildcardMultipleAmbiguousConfigs() {
        NearCacheConfig nearCacheConfig1 = new NearCacheConfig().setName("com.hazelcast*");
        NearCacheConfig nearCacheConfig2 = new NearCacheConfig().setName("*com.hazelcast");
        ClientConfig config = new ClientConfig();
        config.setConfigPatternMatcher((ConfigPatternMatcher)new MatchingPointConfigPatternMatcher());
        config.addNearCacheConfig(nearCacheConfig1);
        config.addNearCacheConfig(nearCacheConfig2);
        config.getNearCacheConfig("com.hazelcast");
    }

    @Test
    public void testNearCacheConfigWildcardMatchingPointStartsWith() {
        NearCacheConfig nearCacheConfig1 = new NearCacheConfig().setName("hazelcast.*");
        NearCacheConfig nearCacheConfig2 = new NearCacheConfig().setName("hazelcast.test.*");
        NearCacheConfig nearCacheConfig3 = new NearCacheConfig().setName("hazelcast.test.sub.*");
        ClientConfig config = new ClientConfig();
        config.setConfigPatternMatcher((ConfigPatternMatcher)new MatchingPointConfigPatternMatcher());
        config.addNearCacheConfig(nearCacheConfig1);
        config.addNearCacheConfig(nearCacheConfig2);
        config.addNearCacheConfig(nearCacheConfig3);
        Assert.assertEquals(null, (Object)config.getNearCacheConfig("com.hazelcast.myNearCache"));
        Assert.assertEquals(null, (Object)config.getNearCacheConfig("com.hazelcast.test.myNearCache"));
        Assert.assertEquals(null, (Object)config.getNearCacheConfig("com.hazelcast.test.sub.myNearCache"));
    }

    @Test
    public void testNearCacheConfigWildcardMatchingPointEndsWith() {
        NearCacheConfig nearCacheConfig1 = new NearCacheConfig().setName("*.sub");
        NearCacheConfig nearCacheConfig2 = new NearCacheConfig().setName("*.test.sub");
        NearCacheConfig nearCacheConfig3 = new NearCacheConfig().setName("*.hazelcast.test.sub");
        ClientConfig config = new ClientConfig();
        config.setConfigPatternMatcher((ConfigPatternMatcher)new MatchingPointConfigPatternMatcher());
        config.addNearCacheConfig(nearCacheConfig1);
        config.addNearCacheConfig(nearCacheConfig2);
        config.addNearCacheConfig(nearCacheConfig3);
        Assert.assertEquals(null, (Object)config.getNearCacheConfig("com.hazelFast.Fast.sub.myNearCache"));
        Assert.assertEquals(null, (Object)config.getNearCacheConfig("hazelFast.test.sub.myNearCache"));
        Assert.assertEquals(null, (Object)config.getNearCacheConfig("test.sub.myNearCache"));
    }

    @Test
    public void testNearCacheConfigWildcardOnly() {
        NearCacheConfig nearCacheConfig = new NearCacheConfig().setName("*");
        ClientConfig config = new ClientConfig();
        config.setConfigPatternMatcher((ConfigPatternMatcher)new MatchingPointConfigPatternMatcher());
        config.addNearCacheConfig(nearCacheConfig);
        Assert.assertEquals((Object)nearCacheConfig, (Object)config.getNearCacheConfig("com.hazelcast.myNearCache"));
    }

    @Test
    public void testNearCacheConfigWildcardOnlyMultipleConfigs() {
        NearCacheConfig nearCacheConfig1 = new NearCacheConfig().setName("*");
        NearCacheConfig nearCacheConfig2 = new NearCacheConfig().setName("com.hazelcast.*");
        ClientConfig config = new ClientConfig();
        config.setConfigPatternMatcher((ConfigPatternMatcher)new MatchingPointConfigPatternMatcher());
        config.addNearCacheConfig(nearCacheConfig1);
        config.addNearCacheConfig(nearCacheConfig2);
        Assert.assertEquals((Object)nearCacheConfig2, (Object)config.getNearCacheConfig("com.hazelcast.myNearCache"));
    }
}

