/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.config;

import com.hazelcast.client.config.ClientAwsConfig;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.ClientNetworkConfig;
import com.hazelcast.client.config.ProxyFactoryConfig;
import com.hazelcast.client.config.XmlClientConfigBuilder;
import com.hazelcast.config.EntryListenerConfig;
import com.hazelcast.config.EvictionConfig;
import com.hazelcast.config.EvictionPolicy;
import com.hazelcast.config.GlobalSerializerConfig;
import com.hazelcast.config.GroupConfig;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.InvalidConfigurationException;
import com.hazelcast.config.ListenerConfig;
import com.hazelcast.config.MapIndexConfig;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.config.QueryCacheConfig;
import com.hazelcast.config.SerializationConfig;
import com.hazelcast.config.SerializerConfig;
import com.hazelcast.config.SocketInterceptorConfig;
import com.hazelcast.config.XMLConfigBuilderTest;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.test.HazelcastSerialClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.QuickTest;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.nio.ByteOrder;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.xml.sax.SAXException;

@RunWith(value=HazelcastSerialClassRunner.class)
@Category(value={QuickTest.class})
public class XmlClientConfigBuilderTest
extends HazelcastTestSupport {
    static final String HAZELCAST_CLIENT_START_TAG = "<hazelcast-client xmlns=\"http://www.hazelcast.com/schema/client-config\">\n";
    private ClientConfig clientConfig;

    @Before
    public void init() throws Exception {
        URL schemaResource = XMLConfigBuilderTest.class.getClassLoader().getResource("hazelcast-client-full.xml");
        this.clientConfig = new XmlClientConfigBuilder(schemaResource).build();
    }

    @After
    @Before
    public void after() {
        System.clearProperty("hazelcast.client.config");
    }

    @Test(expected=InvalidConfigurationException.class)
    public void testInvalidRootElement() {
        String xml = "<hazelcast><group><name>dev</name><password>clusterpass</password></group></hazelcast>";
        XmlClientConfigBuilderTest.buildConfig(xml);
    }

    @Test(expected=HazelcastException.class)
    public void loadingThroughSystemProperty_nonExistingFile() throws IOException {
        File file = File.createTempFile("foo", "bar");
        IOUtil.delete((File)file);
        System.setProperty("hazelcast.client.config", file.getAbsolutePath());
        new XmlClientConfigBuilder();
    }

    @Test
    public void loadingThroughSystemProperty_existingFile() throws IOException {
        String xml = "<hazelcast-client xmlns=\"http://www.hazelcast.com/schema/client-config\">\n    <group>\n        <name>foobar</name>\n        <password>dev-pass</password>\n    </group>\n</hazelcast-client>";
        File file = File.createTempFile("foo", "bar");
        file.deleteOnExit();
        PrintWriter writer = new PrintWriter(file, "UTF-8");
        writer.println(xml);
        writer.close();
        System.setProperty("hazelcast.client.config", file.getAbsolutePath());
        XmlClientConfigBuilder configBuilder = new XmlClientConfigBuilder();
        ClientConfig config = configBuilder.build();
        Assert.assertEquals((Object)"foobar", (Object)config.getGroupConfig().getName());
    }

    @Test(expected=HazelcastException.class)
    public void loadingThroughSystemProperty_nonExistingClasspathResource() throws IOException {
        System.setProperty("hazelcast.client.config", "classpath:idontexist");
        new XmlClientConfigBuilder();
    }

    @Test
    public void loadingThroughSystemProperty_existingClasspathResource() throws IOException {
        System.setProperty("hazelcast.client.config", "classpath:test-hazelcast-client.xml");
        XmlClientConfigBuilder configBuilder = new XmlClientConfigBuilder();
        ClientConfig config = configBuilder.build();
        Assert.assertEquals((Object)"foobar", (Object)config.getGroupConfig().getName());
        Assert.assertEquals((Object)"com.hazelcast.nio.ssl.BasicSSLContextFactory", (Object)config.getNetworkConfig().getSSLConfig().getFactoryClassName());
        Assert.assertEquals((long)32L, (long)config.getNetworkConfig().getSocketOptions().getBufferSize());
        Assert.assertFalse((boolean)config.getNetworkConfig().getSocketOptions().isKeepAlive());
        Assert.assertFalse((boolean)config.getNetworkConfig().getSocketOptions().isTcpNoDelay());
        Assert.assertEquals((long)3L, (long)config.getNetworkConfig().getSocketOptions().getLingerSeconds());
    }

    @Test
    public void testGroupConfig() {
        GroupConfig groupConfig = this.clientConfig.getGroupConfig();
        Assert.assertEquals((Object)"dev", (Object)groupConfig.getName());
        Assert.assertEquals((Object)"dev-pass", (Object)groupConfig.getPassword());
    }

    @Test
    public void testProperties() {
        Assert.assertEquals((long)6L, (long)this.clientConfig.getProperties().size());
        Assert.assertEquals((Object)"60000", (Object)this.clientConfig.getProperty("hazelcast.client.heartbeat.timeout"));
    }

    @Test
    public void testNetworkConfig() {
        ClientNetworkConfig networkConfig = this.clientConfig.getNetworkConfig();
        Assert.assertEquals((long)2L, (long)networkConfig.getConnectionAttemptLimit());
        Assert.assertEquals((long)2L, (long)networkConfig.getAddresses().size());
        XmlClientConfigBuilderTest.assertContains((Collection)networkConfig.getAddresses(), (Object)"127.0.0.1");
        XmlClientConfigBuilderTest.assertContains((Collection)networkConfig.getAddresses(), (Object)"127.0.0.2");
        Assert.assertTrue((boolean)networkConfig.isSmartRouting());
        Assert.assertTrue((boolean)networkConfig.isRedoOperation());
        SocketInterceptorConfig socketInterceptorConfig = networkConfig.getSocketInterceptorConfig();
        Assert.assertTrue((boolean)socketInterceptorConfig.isEnabled());
        Assert.assertEquals((Object)"com.hazelcast.examples.MySocketInterceptor", (Object)socketInterceptorConfig.getClassName());
        Assert.assertEquals((Object)"bar", (Object)socketInterceptorConfig.getProperty("foo"));
        ClientAwsConfig awsConfig = networkConfig.getAwsConfig();
        Assert.assertTrue((boolean)awsConfig.isEnabled());
        Assert.assertTrue((boolean)awsConfig.isInsideAws());
        Assert.assertEquals((Object)"TEST_ACCESS_KEY", (Object)awsConfig.getAccessKey());
        Assert.assertEquals((Object)"TEST_ACCESS_KEY", (Object)awsConfig.getAccessKey());
        Assert.assertEquals((Object)"TEST_SECRET_KEY", (Object)awsConfig.getSecretKey());
        Assert.assertEquals((Object)"us-east-1", (Object)awsConfig.getRegion());
        Assert.assertEquals((Object)"ec2.amazonaws.com", (Object)awsConfig.getHostHeader());
        Assert.assertEquals((Object)"type", (Object)awsConfig.getTagKey());
        Assert.assertEquals((Object)"hz-nodes", (Object)awsConfig.getTagValue());
        Assert.assertEquals((long)11L, (long)awsConfig.getConnectionTimeoutSeconds());
    }

    @Test
    public void testSerializationConfig() {
        SerializationConfig serializationConfig = this.clientConfig.getSerializationConfig();
        Assert.assertEquals((long)3L, (long)serializationConfig.getPortableVersion());
        Map dsClasses = serializationConfig.getDataSerializableFactoryClasses();
        Assert.assertEquals((long)1L, (long)dsClasses.size());
        Assert.assertEquals((Object)"com.hazelcast.examples.DataSerializableFactory", dsClasses.get(1));
        Map pfClasses = serializationConfig.getPortableFactoryClasses();
        Assert.assertEquals((long)1L, (long)pfClasses.size());
        Assert.assertEquals((Object)"com.hazelcast.examples.PortableFactory", pfClasses.get(2));
        Collection serializerConfigs = serializationConfig.getSerializerConfigs();
        Assert.assertEquals((long)1L, (long)serializerConfigs.size());
        SerializerConfig serializerConfig = (SerializerConfig)serializerConfigs.iterator().next();
        Assert.assertEquals((Object)"com.hazelcast.examples.DummyType", (Object)serializerConfig.getTypeClassName());
        Assert.assertEquals((Object)"com.hazelcast.examples.SerializerFactory", (Object)serializerConfig.getClassName());
        GlobalSerializerConfig globalSerializerConfig = serializationConfig.getGlobalSerializerConfig();
        Assert.assertEquals((Object)"com.hazelcast.examples.GlobalSerializerFactory", (Object)globalSerializerConfig.getClassName());
        Assert.assertEquals((Object)ByteOrder.BIG_ENDIAN, (Object)serializationConfig.getByteOrder());
        Assert.assertEquals((Object)true, (Object)serializationConfig.isCheckClassDefErrors());
        Assert.assertEquals((Object)false, (Object)serializationConfig.isAllowUnsafe());
        Assert.assertEquals((Object)false, (Object)serializationConfig.isEnableCompression());
        Assert.assertEquals((Object)true, (Object)serializationConfig.isEnableSharedObject());
        Assert.assertEquals((Object)true, (Object)serializationConfig.isUseNativeByteOrder());
    }

    @Test
    public void testProxyFactories() {
        List pfc = this.clientConfig.getProxyFactoryConfigs();
        Assert.assertEquals((long)3L, (long)pfc.size());
        XmlClientConfigBuilderTest.assertContains((Collection)pfc, (Object)new ProxyFactoryConfig("com.hazelcast.examples.ProxyXYZ1", "sampleService1"));
        XmlClientConfigBuilderTest.assertContains((Collection)pfc, (Object)new ProxyFactoryConfig("com.hazelcast.examples.ProxyXYZ2", "sampleService1"));
        XmlClientConfigBuilderTest.assertContains((Collection)pfc, (Object)new ProxyFactoryConfig("com.hazelcast.examples.ProxyXYZ3", "sampleService3"));
    }

    @Test
    public void testNearCacheConfigs() {
        Assert.assertEquals((long)1L, (long)this.clientConfig.getNearCacheConfigMap().size());
        NearCacheConfig nearCacheConfig = this.clientConfig.getNearCacheConfig("asd");
        Assert.assertEquals((long)2000L, (long)nearCacheConfig.getMaxSize());
        Assert.assertEquals((long)2000L, (long)nearCacheConfig.getEvictionConfig().getSize());
        Assert.assertEquals((long)90L, (long)nearCacheConfig.getTimeToLiveSeconds());
        Assert.assertEquals((long)100L, (long)nearCacheConfig.getMaxIdleSeconds());
        Assert.assertEquals((Object)"LFU", (Object)nearCacheConfig.getEvictionPolicy());
        Assert.assertEquals((Object)EvictionPolicy.LFU, (Object)nearCacheConfig.getEvictionConfig().getEvictionPolicy());
        Assert.assertTrue((boolean)nearCacheConfig.isInvalidateOnChange());
        Assert.assertEquals((Object)InMemoryFormat.OBJECT, (Object)nearCacheConfig.getInMemoryFormat());
    }

    @Test
    public void testNearCacheConfig_withEvictionConfig_withPreloaderConfig() throws IOException {
        URL schemaResource = XMLConfigBuilderTest.class.getClassLoader().getResource("hazelcast-client-test.xml");
        ClientConfig clientConfig = new XmlClientConfigBuilder(schemaResource).build();
        Assert.assertEquals((Object)"MyInstanceName", (Object)clientConfig.getInstanceName());
        NearCacheConfig nearCacheConfig = clientConfig.getNearCacheConfig("nearCacheWithEvictionAndPreloader");
        Assert.assertEquals((long)10000L, (long)nearCacheConfig.getTimeToLiveSeconds());
        Assert.assertEquals((long)5000L, (long)nearCacheConfig.getMaxIdleSeconds());
        Assert.assertFalse((boolean)nearCacheConfig.isInvalidateOnChange());
        Assert.assertEquals((Object)InMemoryFormat.OBJECT, (Object)nearCacheConfig.getInMemoryFormat());
        Assert.assertTrue((boolean)nearCacheConfig.isCacheLocalEntries());
        Assert.assertNotNull((Object)nearCacheConfig.getEvictionConfig());
        Assert.assertEquals((long)100L, (long)nearCacheConfig.getEvictionConfig().getSize());
        Assert.assertEquals((Object)EvictionConfig.MaxSizePolicy.ENTRY_COUNT, (Object)nearCacheConfig.getEvictionConfig().getMaximumSizePolicy());
        Assert.assertEquals((Object)EvictionPolicy.LFU, (Object)nearCacheConfig.getEvictionConfig().getEvictionPolicy());
        Assert.assertNotNull((Object)nearCacheConfig.getPreloaderConfig());
        Assert.assertTrue((boolean)nearCacheConfig.getPreloaderConfig().isEnabled());
        Assert.assertEquals((Object)"/tmp/myNearCache", (Object)nearCacheConfig.getPreloaderConfig().getDirectory());
        Assert.assertEquals((long)2342L, (long)nearCacheConfig.getPreloaderConfig().getStoreInitialDelaySeconds());
        Assert.assertEquals((long)4223L, (long)nearCacheConfig.getPreloaderConfig().getStoreIntervalSeconds());
    }

    @Test
    public void testQueryCacheFullConfig() throws Exception {
        QueryCacheConfig queryCacheConfig = (QueryCacheConfig)((Map)this.clientConfig.getQueryCacheConfigs().get("map-name")).get("query-cache-name");
        EntryListenerConfig entryListenerConfig = (EntryListenerConfig)queryCacheConfig.getEntryListenerConfigs().get(0);
        Assert.assertEquals((Object)"query-cache-name", (Object)queryCacheConfig.getName());
        Assert.assertTrue((boolean)entryListenerConfig.isIncludeValue());
        Assert.assertFalse((boolean)entryListenerConfig.isLocal());
        Assert.assertEquals((Object)"com.hazelcast.examples.EntryListener", (Object)entryListenerConfig.getClassName());
        Assert.assertTrue((boolean)queryCacheConfig.isIncludeValue());
        Assert.assertEquals((long)1L, (long)queryCacheConfig.getBatchSize());
        Assert.assertEquals((long)16L, (long)queryCacheConfig.getBufferSize());
        Assert.assertEquals((long)0L, (long)queryCacheConfig.getDelaySeconds());
        Assert.assertEquals((Object)EvictionPolicy.LRU, (Object)queryCacheConfig.getEvictionConfig().getEvictionPolicy());
        Assert.assertEquals((Object)EvictionConfig.MaxSizePolicy.ENTRY_COUNT, (Object)queryCacheConfig.getEvictionConfig().getMaximumSizePolicy());
        Assert.assertEquals((long)10000L, (long)queryCacheConfig.getEvictionConfig().getSize());
        Assert.assertEquals((Object)InMemoryFormat.BINARY, (Object)queryCacheConfig.getInMemoryFormat());
        Assert.assertFalse((boolean)queryCacheConfig.isCoalesce());
        Assert.assertTrue((boolean)queryCacheConfig.isPopulate());
        for (MapIndexConfig mapIndexConfig : queryCacheConfig.getIndexConfigs()) {
            Assert.assertEquals((Object)"name", (Object)mapIndexConfig.getAttribute());
            Assert.assertFalse((boolean)mapIndexConfig.isOrdered());
        }
        Assert.assertEquals((Object)"com.hazelcast.examples.ExamplePredicate", (Object)queryCacheConfig.getPredicateConfig().getClassName());
    }

    @Test
    public void testLeftovers() {
        Assert.assertEquals((long)40L, (long)this.clientConfig.getExecutorPoolSize());
        Assert.assertEquals((Object)"com.hazelcast.security.UsernamePasswordCredentials", (Object)this.clientConfig.getSecurityConfig().getCredentialsClassname());
        Assert.assertEquals((long)40L, (long)this.clientConfig.getExecutorPoolSize());
        Assert.assertEquals((Object)"com.hazelcast.client.util.RandomLB", (Object)this.clientConfig.getLoadBalancer().getClass().getName());
        List listenerConfigs = this.clientConfig.getListenerConfigs();
        Assert.assertEquals((long)3L, (long)listenerConfigs.size());
        XmlClientConfigBuilderTest.assertContains((Collection)listenerConfigs, (Object)new ListenerConfig("com.hazelcast.examples.MembershipListener"));
        XmlClientConfigBuilderTest.assertContains((Collection)listenerConfigs, (Object)new ListenerConfig("com.hazelcast.examples.InstanceListener"));
        XmlClientConfigBuilderTest.assertContains((Collection)listenerConfigs, (Object)new ListenerConfig("com.hazelcast.examples.MigrationListener"));
    }

    @Test
    public void testXSDDefaultXML() throws SAXException, IOException {
        this.testXSDConfigXML("hazelcast-client-default.xml");
    }

    @Test
    public void testFullConfigXML() throws SAXException, IOException {
        this.testXSDConfigXML("hazelcast-client-full.xml");
    }

    @Test(expected=InvalidConfigurationException.class)
    public void testMissingNamespace() {
        String xml = "<hazelcast-client/>";
        XmlClientConfigBuilderTest.buildConfig(xml);
    }

    @Test(expected=InvalidConfigurationException.class)
    public void testInvalidNamespace() {
        String xml = "<hazelcast-client xmlns=\"http://foo.bar\"/>";
        XmlClientConfigBuilderTest.buildConfig(xml);
    }

    @Test
    public void testValidNamespace() {
        String xml = "<hazelcast-client xmlns=\"http://www.hazelcast.com/schema/client-config\">\n</hazelcast-client>";
        XmlClientConfigBuilderTest.buildConfig(xml);
    }

    @Test(expected=InvalidConfigurationException.class)
    public void testHazelcastClientTagAppearsTwice() {
        String xml = "<hazelcast-client xmlns=\"http://www.hazelcast.com/schema/client-config\">\n<hazelcast-client/></<hazelcast-client>";
        XmlClientConfigBuilderTest.buildConfig(xml);
    }

    static ClientConfig buildConfig(String xml, Properties properties) {
        ByteArrayInputStream bis = new ByteArrayInputStream(xml.getBytes());
        XmlClientConfigBuilder configBuilder = new XmlClientConfigBuilder((InputStream)bis);
        configBuilder.setProperties(properties);
        return configBuilder.build();
    }

    static ClientConfig buildConfig(String xml, String key, String value) {
        Properties properties = new Properties();
        properties.setProperty(key, value);
        return XmlClientConfigBuilderTest.buildConfig(xml, properties);
    }

    public static ClientConfig buildConfig(String xml) {
        return XmlClientConfigBuilderTest.buildConfig(xml, null);
    }

    private void testXSDConfigXML(String xmlFileName) throws SAXException, IOException {
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        URL schemaResource = XMLConfigBuilderTest.class.getClassLoader().getResource("hazelcast-client-config-3.8.xsd");
        InputStream xmlResource = XMLConfigBuilderTest.class.getClassLoader().getResourceAsStream(xmlFileName);
        Schema schema = factory.newSchema(schemaResource);
        StreamSource source = new StreamSource(xmlResource);
        Validator validator = schema.newValidator();
        try {
            validator.validate(source);
        }
        catch (SAXException ex) {
            Assert.fail((String)(xmlFileName + " is not valid because: " + ex.toString()));
        }
    }
}

