/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.executor;

import com.hazelcast.client.executor.tasks.AppendCallable;
import com.hazelcast.client.executor.tasks.GetMemberUuidTask;
import com.hazelcast.client.executor.tasks.MapPutPartitionAwareCallable;
import com.hazelcast.client.executor.tasks.MapPutPartitionAwareRunnable;
import com.hazelcast.client.executor.tasks.MapPutRunnable;
import com.hazelcast.client.executor.tasks.NullCallable;
import com.hazelcast.client.executor.tasks.SelectAllMembers;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IExecutorService;
import com.hazelcast.core.IMap;
import com.hazelcast.core.Member;
import com.hazelcast.core.MemberSelector;
import com.hazelcast.core.MultiExecutionCallback;
import com.hazelcast.test.AssertTask;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientExecutorServiceSubmitTest {
    private static final int CLUSTER_SIZE = 3;
    private final TestHazelcastFactory hazelcastFactory = new TestHazelcastFactory();
    private HazelcastInstance server;
    private HazelcastInstance client;

    @After
    public void tearDown() {
        this.hazelcastFactory.terminateAll();
    }

    @Before
    public void setup() throws IOException {
        this.hazelcastFactory.newHazelcastInstance();
        this.server = this.hazelcastFactory.newHazelcastInstance();
        this.hazelcastFactory.newHazelcastInstance();
        this.client = this.hazelcastFactory.newHazelcastClient();
    }

    @Test(expected=NullPointerException.class)
    public void testSubmitCallableNullTask() throws Exception {
        IExecutorService service = this.client.getExecutorService(HazelcastTestSupport.randomString());
        Callable callable = null;
        service.submit(callable);
    }

    @Test
    public void testSubmitCallableToMember() throws Exception {
        IExecutorService service = this.client.getExecutorService(HazelcastTestSupport.randomString());
        GetMemberUuidTask getUuidCallable = new GetMemberUuidTask();
        Member member = this.server.getCluster().getLocalMember();
        Future result = service.submitToMember((Callable)getUuidCallable, member);
        Assert.assertEquals((Object)member.getUuid(), result.get());
    }

    @Test
    public void testSubmitCallableToMembers() throws Exception {
        IExecutorService service = this.client.getExecutorService(HazelcastTestSupport.randomString());
        GetMemberUuidTask getUuidCallable = new GetMemberUuidTask();
        Set collection = this.server.getCluster().getMembers();
        Map map = service.submitToMembers((Callable)getUuidCallable, (Collection)collection);
        for (Member member : map.keySet()) {
            Future result = (Future)map.get(member);
            String uuid = (String)result.get();
            Assert.assertEquals((Object)member.getUuid(), (Object)uuid);
        }
    }

    @Test
    public void testSubmitCallable_withMemberSelector() throws Exception {
        IExecutorService service = this.client.getExecutorService(HazelcastTestSupport.randomString());
        String msg = HazelcastTestSupport.randomString();
        AppendCallable callable = new AppendCallable(msg);
        SelectAllMembers selectAll = new SelectAllMembers();
        Future f = service.submit((Callable)callable, (MemberSelector)selectAll);
        Assert.assertEquals((Object)(msg + ":CallableResult"), f.get());
    }

    @Test
    public void testSubmitCallableToMembers_withMemberSelector() throws Exception {
        IExecutorService service = this.client.getExecutorService(HazelcastTestSupport.randomString());
        GetMemberUuidTask getUuidCallable = new GetMemberUuidTask();
        SelectAllMembers selectAll = new SelectAllMembers();
        Map map = service.submitToMembers((Callable)getUuidCallable, (MemberSelector)selectAll);
        for (Member member : map.keySet()) {
            Future result = (Future)map.get(member);
            String uuid = (String)result.get();
            Assert.assertEquals((Object)member.getUuid(), (Object)uuid);
        }
    }

    @Test
    public void submitCallableToAllMembers() throws Exception {
        IExecutorService service = this.client.getExecutorService(HazelcastTestSupport.randomString());
        String msg = HazelcastTestSupport.randomString();
        AppendCallable callable = new AppendCallable(msg);
        Map map = service.submitToAllMembers((Callable)callable);
        for (Member member : map.keySet()) {
            Future result = (Future)map.get(member);
            Assert.assertEquals((Object)(msg + ":CallableResult"), result.get());
        }
    }

    @Test
    public void submitRunnableToMember_withExecutionCallback() {
        IExecutorService service = this.client.getExecutorService(HazelcastTestSupport.randomString());
        String mapName = HazelcastTestSupport.randomString();
        MapPutRunnable runnable = new MapPutRunnable(mapName);
        Member member = this.server.getCluster().getLocalMember();
        final CountDownLatch responseLatch = new CountDownLatch(1);
        service.submitToMember((Runnable)runnable, member, new ExecutionCallback(){

            public void onResponse(Object response) {
                responseLatch.countDown();
            }

            public void onFailure(Throwable t) {
            }
        });
        IMap map = this.client.getMap(mapName);
        HazelcastTestSupport.assertOpenEventually((String)"responseLatch", (CountDownLatch)responseLatch);
        Assert.assertEquals((long)1L, (long)map.size());
    }

    @Test
    public void submitRunnableToMembers_withMultiExecutionCallback() {
        IExecutorService service = this.client.getExecutorService(HazelcastTestSupport.randomString());
        String mapName = HazelcastTestSupport.randomString();
        MapPutRunnable runnable = new MapPutRunnable(mapName);
        Set collection = this.server.getCluster().getMembers();
        final CountDownLatch responseLatch = new CountDownLatch(3);
        final CountDownLatch completeLatch = new CountDownLatch(1);
        service.submitToMembers((Runnable)runnable, (Collection)collection, new MultiExecutionCallback(){

            public void onResponse(Member member, Object value) {
                responseLatch.countDown();
            }

            public void onComplete(Map<Member, Object> values) {
                completeLatch.countDown();
            }
        });
        IMap map = this.client.getMap(mapName);
        HazelcastTestSupport.assertOpenEventually((String)"responseLatch", (CountDownLatch)responseLatch);
        HazelcastTestSupport.assertOpenEventually((String)"completeLatch", (CountDownLatch)completeLatch);
        Assert.assertEquals((long)3L, (long)map.size());
    }

    @Test
    public void testSubmitCallableToMember_withExecutionCallback() throws Exception {
        IExecutorService service = this.client.getExecutorService(HazelcastTestSupport.randomString());
        GetMemberUuidTask getUuidCallable = new GetMemberUuidTask();
        Member member = this.server.getCluster().getLocalMember();
        final CountDownLatch responseLatch = new CountDownLatch(1);
        final AtomicReference result = new AtomicReference();
        service.submitToMember((Callable)getUuidCallable, member, new ExecutionCallback(){

            public void onResponse(Object response) {
                result.set(response);
                responseLatch.countDown();
            }

            public void onFailure(Throwable t) {
            }
        });
        HazelcastTestSupport.assertOpenEventually((String)"responseLatch", (CountDownLatch)responseLatch);
        Assert.assertEquals((Object)member.getUuid(), result.get());
    }

    @Test
    public void submitCallableToMember_withMultiExecutionCallback() throws Exception {
        IExecutorService service = this.client.getExecutorService(HazelcastTestSupport.randomString());
        final CountDownLatch responseLatch = new CountDownLatch(3);
        final CountDownLatch completeLatch = new CountDownLatch(3);
        final String msg = HazelcastTestSupport.randomString();
        AppendCallable callable = new AppendCallable(msg);
        Set collection = this.server.getCluster().getMembers();
        service.submitToMembers((Callable)callable, (Collection)collection, new MultiExecutionCallback(){

            public void onResponse(Member member, Object value) {
                if (value.equals(msg + ":CallableResult")) {
                    responseLatch.countDown();
                }
            }

            public void onComplete(Map<Member, Object> values) {
                for (Member member : values.keySet()) {
                    Object value = values.get(member);
                    if (!value.equals(msg + ":CallableResult")) continue;
                    completeLatch.countDown();
                }
            }
        });
        HazelcastTestSupport.assertOpenEventually((String)"responseLatch", (CountDownLatch)responseLatch);
        HazelcastTestSupport.assertOpenEventually((String)"completeLatch", (CountDownLatch)completeLatch);
    }

    @Test
    public void submitRunnable_withExecutionCallback() {
        IExecutorService service = this.client.getExecutorService(HazelcastTestSupport.randomString());
        final CountDownLatch responseLatch = new CountDownLatch(1);
        String mapName = HazelcastTestSupport.randomString();
        MapPutRunnable runnable = new MapPutRunnable(mapName);
        SelectAllMembers selector = new SelectAllMembers();
        service.submit((Runnable)runnable, (MemberSelector)selector, new ExecutionCallback(){

            public void onResponse(Object response) {
                responseLatch.countDown();
            }

            public void onFailure(Throwable t) {
            }
        });
        IMap map = this.client.getMap(mapName);
        HazelcastTestSupport.assertOpenEventually((String)"responseLatch", (CountDownLatch)responseLatch);
        Assert.assertEquals((long)1L, (long)map.size());
    }

    @Test
    public void submitRunnableToMembers_withExecutionCallback() {
        IExecutorService service = this.client.getExecutorService(HazelcastTestSupport.randomString());
        final CountDownLatch responseLatch = new CountDownLatch(3);
        final CountDownLatch completeLatch = new CountDownLatch(1);
        String mapName = HazelcastTestSupport.randomString();
        MapPutRunnable runnable = new MapPutRunnable(mapName);
        SelectAllMembers selector = new SelectAllMembers();
        service.submitToMembers((Runnable)runnable, (MemberSelector)selector, new MultiExecutionCallback(){

            public void onResponse(Member member, Object value) {
                responseLatch.countDown();
            }

            public void onComplete(Map<Member, Object> values) {
                completeLatch.countDown();
            }
        });
        IMap map = this.client.getMap(mapName);
        HazelcastTestSupport.assertOpenEventually((String)"responseLatch", (CountDownLatch)responseLatch);
        HazelcastTestSupport.assertOpenEventually((String)"completeLatch", (CountDownLatch)completeLatch);
        Assert.assertEquals((long)3L, (long)map.size());
    }

    @Test
    public void submitCallable_withExecutionCallback() {
        IExecutorService service = this.client.getExecutorService(HazelcastTestSupport.randomString());
        final CountDownLatch responseLatch = new CountDownLatch(1);
        String msg = HazelcastTestSupport.randomString();
        AppendCallable runnable = new AppendCallable(msg);
        SelectAllMembers selector = new SelectAllMembers();
        final AtomicReference result = new AtomicReference();
        service.submit((Callable)runnable, (MemberSelector)selector, new ExecutionCallback(){

            public void onResponse(Object response) {
                result.set(response);
                responseLatch.countDown();
            }

            public void onFailure(Throwable t) {
            }
        });
        HazelcastTestSupport.assertOpenEventually((String)"responseLatch", (CountDownLatch)responseLatch);
        Assert.assertEquals((Object)(msg + ":CallableResult"), result.get());
    }

    @Test
    public void submitCallableToMembers_withExecutionCallback() {
        IExecutorService service = this.client.getExecutorService(HazelcastTestSupport.randomString());
        final CountDownLatch responseLatch = new CountDownLatch(3);
        final CountDownLatch completeLatch = new CountDownLatch(1);
        final String msg = HazelcastTestSupport.randomString();
        AppendCallable callable = new AppendCallable(msg);
        SelectAllMembers selector = new SelectAllMembers();
        service.submitToMembers((Callable)callable, (MemberSelector)selector, new MultiExecutionCallback(){

            public void onResponse(Member member, Object value) {
                if (value.equals(msg + ":CallableResult")) {
                    responseLatch.countDown();
                }
            }

            public void onComplete(Map<Member, Object> values) {
                completeLatch.countDown();
            }
        });
        HazelcastTestSupport.assertOpenEventually((String)"responseLatch", (CountDownLatch)responseLatch);
        HazelcastTestSupport.assertOpenEventually((String)"completeLatch", (CountDownLatch)completeLatch);
    }

    @Test
    public void submitRunnableToAllMembers_withMultiExecutionCallback() throws Exception {
        IExecutorService service = this.client.getExecutorService(HazelcastTestSupport.randomString());
        final CountDownLatch responseLatch = new CountDownLatch(3);
        final CountDownLatch completeLatch = new CountDownLatch(1);
        String mapName = HazelcastTestSupport.randomString();
        MapPutRunnable runnable = new MapPutRunnable(mapName);
        service.submitToAllMembers((Runnable)runnable, new MultiExecutionCallback(){

            public void onResponse(Member member, Object value) {
                responseLatch.countDown();
            }

            public void onComplete(Map<Member, Object> values) {
                completeLatch.countDown();
            }
        });
        IMap map = this.client.getMap(mapName);
        HazelcastTestSupport.assertOpenEventually((String)"responseLatch", (CountDownLatch)responseLatch);
        HazelcastTestSupport.assertOpenEventually((String)"completeLatch", (CountDownLatch)completeLatch);
        Assert.assertEquals((long)3L, (long)map.size());
    }

    @Test
    public void submitCallableToAllMembers_withMultiExecutionCallback() throws Exception {
        IExecutorService service = this.client.getExecutorService(HazelcastTestSupport.randomString());
        final CountDownLatch responseLatch = new CountDownLatch(3);
        final CountDownLatch completeLatch = new CountDownLatch(3);
        final String msg = HazelcastTestSupport.randomString();
        AppendCallable callable = new AppendCallable(msg);
        service.submitToAllMembers((Callable)callable, new MultiExecutionCallback(){

            public void onResponse(Member member, Object value) {
                if (value.equals(msg + ":CallableResult")) {
                    responseLatch.countDown();
                }
            }

            public void onComplete(Map<Member, Object> values) {
                for (Member member : values.keySet()) {
                    Object value = values.get(member);
                    if (!value.equals(msg + ":CallableResult")) continue;
                    completeLatch.countDown();
                }
            }
        });
        HazelcastTestSupport.assertOpenEventually((String)"responseLatch", (CountDownLatch)responseLatch);
        HazelcastTestSupport.assertOpenEventually((String)"completeLatch", (CountDownLatch)completeLatch);
    }

    @Test
    public void submitCallableWithNullResultToAllMembers_withMultiExecutionCallback() throws Exception {
        IExecutorService service = this.client.getExecutorService(HazelcastTestSupport.randomString());
        final CountDownLatch responseLatch = new CountDownLatch(3);
        final CountDownLatch completeLatch = new CountDownLatch(3);
        NullCallable callable = new NullCallable();
        service.submitToAllMembers((Callable)callable, new MultiExecutionCallback(){

            public void onResponse(Member member, Object value) {
                if (value == null) {
                    responseLatch.countDown();
                }
            }

            public void onComplete(Map<Member, Object> values) {
                for (Member member : values.keySet()) {
                    Object value = values.get(member);
                    if (value != null) continue;
                    completeLatch.countDown();
                }
            }
        });
        HazelcastTestSupport.assertOpenEventually((String)"responseLatch", (CountDownLatch)responseLatch);
        HazelcastTestSupport.assertOpenEventually((String)"completeLatch", (CountDownLatch)completeLatch);
    }

    @Test
    public void submitRunnable() {
        IExecutorService service = this.client.getExecutorService(HazelcastTestSupport.randomString());
        String mapName = HazelcastTestSupport.randomString();
        MapPutRunnable runnable = new MapPutRunnable(mapName);
        service.submit((Runnable)runnable);
        IMap map = this.client.getMap(mapName);
        HazelcastTestSupport.assertSizeEventually((int)1, (Map)map);
    }

    @Test
    public void testSubmitRunnable_WithResult() throws ExecutionException, InterruptedException {
        IExecutorService service = this.client.getExecutorService(HazelcastTestSupport.randomString());
        String mapName = HazelcastTestSupport.randomString();
        String givenResult = "givenResult";
        Future future = service.submit((Runnable)new MapPutRunnable(mapName), (Object)givenResult);
        Object result = future.get();
        IMap map = this.client.getMap(mapName);
        Assert.assertEquals((Object)givenResult, result);
        Assert.assertEquals((long)1L, (long)map.size());
    }

    @Test
    public void testSubmitCallable() throws Exception {
        IExecutorService service = this.client.getExecutorService(HazelcastTestSupport.randomString());
        String msg = HazelcastTestSupport.randomString();
        AppendCallable callable = new AppendCallable(msg);
        Future result = service.submit((Callable)callable);
        Assert.assertEquals((Object)(msg + ":CallableResult"), result.get());
    }

    @Test
    public void testSubmitRunnable_withExecutionCallback() throws Exception {
        IExecutorService service = this.client.getExecutorService(HazelcastTestSupport.randomString());
        String mapName = HazelcastTestSupport.randomString();
        MapPutRunnable runnable = new MapPutRunnable(mapName);
        final CountDownLatch responseLatch = new CountDownLatch(1);
        service.submit((Runnable)runnable, new ExecutionCallback(){

            public void onResponse(Object response) {
                responseLatch.countDown();
            }

            public void onFailure(Throwable t) {
            }
        });
        IMap map = this.client.getMap(mapName);
        HazelcastTestSupport.assertOpenEventually((String)"responseLatch", (CountDownLatch)responseLatch);
        Assert.assertEquals((long)1L, (long)map.size());
    }

    @Test
    public void testSubmitCallable_withExecutionCallback() throws Exception {
        IExecutorService service = this.client.getExecutorService(HazelcastTestSupport.randomString());
        String msg = HazelcastTestSupport.randomString();
        AppendCallable callable = new AppendCallable(msg);
        final AtomicReference result = new AtomicReference();
        final CountDownLatch responseLatch = new CountDownLatch(1);
        service.submit((Callable)callable, (ExecutionCallback)new ExecutionCallback<String>(){

            public void onResponse(String response) {
                result.set(response);
                responseLatch.countDown();
            }

            public void onFailure(Throwable t) {
            }
        });
        HazelcastTestSupport.assertOpenEventually((String)"responseLatch", (CountDownLatch)responseLatch);
        Assert.assertEquals((Object)(msg + ":CallableResult"), result.get());
    }

    @Test
    public void submitCallableToKeyOwner() throws Exception {
        IExecutorService service = this.client.getExecutorService(HazelcastTestSupport.randomString());
        String msg = HazelcastTestSupport.randomString();
        AppendCallable callable = new AppendCallable(msg);
        Future result = service.submitToKeyOwner((Callable)callable, (Object)"key");
        Assert.assertEquals((Object)(msg + ":CallableResult"), result.get());
    }

    @Test
    public void submitRunnableToKeyOwner() throws Exception {
        IExecutorService service = this.client.getExecutorService(HazelcastTestSupport.randomString());
        String mapName = HazelcastTestSupport.randomString();
        MapPutRunnable runnable = new MapPutRunnable(mapName);
        final CountDownLatch responseLatch = new CountDownLatch(1);
        service.submitToKeyOwner((Runnable)runnable, (Object)"key", new ExecutionCallback(){

            public void onResponse(Object response) {
                responseLatch.countDown();
            }

            public void onFailure(Throwable t) {
            }
        });
        IMap map = this.client.getMap(mapName);
        HazelcastTestSupport.assertOpenEventually((String)"responseLatch", (CountDownLatch)responseLatch);
        Assert.assertEquals((long)1L, (long)map.size());
    }

    @Test
    public void submitCallableToKeyOwner_withExecutionCallback() throws Exception {
        IExecutorService service = this.client.getExecutorService(HazelcastTestSupport.randomString());
        String msg = HazelcastTestSupport.randomString();
        AppendCallable callable = new AppendCallable(msg);
        final CountDownLatch responseLatch = new CountDownLatch(1);
        final AtomicReference result = new AtomicReference();
        service.submitToKeyOwner((Callable)callable, (Object)"key", (ExecutionCallback)new ExecutionCallback<String>(){

            public void onResponse(String response) {
                result.set(response);
                responseLatch.countDown();
            }

            public void onFailure(Throwable t) {
            }
        });
        HazelcastTestSupport.assertOpenEventually((String)"responseLatch", (CountDownLatch)responseLatch);
        Assert.assertEquals((Object)(msg + ":CallableResult"), result.get());
    }

    @Test
    public void submitRunnablePartitionAware() throws Exception {
        IExecutorService service = this.client.getExecutorService(HazelcastTestSupport.randomString());
        String mapName = HazelcastTestSupport.randomString();
        String key = HazelcastTestSupport.generateKeyOwnedBy((HazelcastInstance)this.server);
        final Member member = this.server.getCluster().getLocalMember();
        MapPutPartitionAwareRunnable<String> runnable = new MapPutPartitionAwareRunnable<String>(mapName, key);
        service.submit(runnable);
        final IMap map = this.client.getMap(mapName);
        HazelcastTestSupport.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() throws Exception {
                Assert.assertTrue((boolean)map.containsKey((Object)member.getUuid()));
            }
        });
    }

    @Test
    public void submitRunnablePartitionAware_withResult() throws Exception {
        IExecutorService service = this.client.getExecutorService(HazelcastTestSupport.randomString());
        String expectedResult = "result";
        String mapName = HazelcastTestSupport.randomString();
        String key = HazelcastTestSupport.generateKeyOwnedBy((HazelcastInstance)this.server);
        final Member member = this.server.getCluster().getLocalMember();
        MapPutPartitionAwareRunnable<String> runnable = new MapPutPartitionAwareRunnable<String>(mapName, key);
        Future result = service.submit(runnable, (Object)expectedResult);
        final IMap map = this.client.getMap(mapName);
        Assert.assertEquals((Object)expectedResult, result.get());
        HazelcastTestSupport.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() throws Exception {
                Assert.assertTrue((boolean)map.containsKey((Object)member.getUuid()));
            }
        });
    }

    @Test
    public void submitRunnablePartitionAware_withExecutionCallback() throws Exception {
        IExecutorService service = this.client.getExecutorService(HazelcastTestSupport.randomString());
        String mapName = HazelcastTestSupport.randomString();
        String key = HazelcastTestSupport.generateKeyOwnedBy((HazelcastInstance)this.server);
        Member member = this.server.getCluster().getLocalMember();
        MapPutPartitionAwareRunnable<String> runnable = new MapPutPartitionAwareRunnable<String>(mapName, key);
        final CountDownLatch responseLatch = new CountDownLatch(1);
        service.submit(runnable, new ExecutionCallback(){

            public void onResponse(Object response) {
                responseLatch.countDown();
            }

            public void onFailure(Throwable t) {
            }
        });
        IMap map = this.client.getMap(mapName);
        HazelcastTestSupport.assertOpenEventually((String)"responseLatch", (CountDownLatch)responseLatch);
        Assert.assertTrue((boolean)map.containsKey((Object)member.getUuid()));
    }

    @Test
    public void submitCallablePartitionAware() throws Exception {
        IExecutorService service = this.client.getExecutorService(HazelcastTestSupport.randomString());
        String mapName = HazelcastTestSupport.randomString();
        IMap map = this.client.getMap(mapName);
        String key = HazelcastTestSupport.generateKeyOwnedBy((HazelcastInstance)this.server);
        Member member = this.server.getCluster().getLocalMember();
        MapPutPartitionAwareCallable callable = new MapPutPartitionAwareCallable(mapName, key);
        Future result = service.submit(callable);
        Assert.assertEquals((Object)member.getUuid(), result.get());
        Assert.assertTrue((boolean)map.containsKey((Object)member.getUuid()));
    }

    @Test
    public void submitCallablePartitionAware_WithExecutionCallback() throws Exception {
        IExecutorService service = this.client.getExecutorService(HazelcastTestSupport.randomString());
        String mapName = HazelcastTestSupport.randomString();
        IMap map = this.client.getMap(mapName);
        String key = HazelcastTestSupport.generateKeyOwnedBy((HazelcastInstance)this.server);
        Member member = this.server.getCluster().getLocalMember();
        MapPutPartitionAwareCallable runnable = new MapPutPartitionAwareCallable(mapName, key);
        final AtomicReference result = new AtomicReference();
        final CountDownLatch responseLatch = new CountDownLatch(1);
        service.submit(runnable, (ExecutionCallback)new ExecutionCallback<String>(){

            public void onResponse(String response) {
                result.set(response);
                responseLatch.countDown();
            }

            public void onFailure(Throwable t) {
            }
        });
        HazelcastTestSupport.assertOpenEventually((String)"responseLatch", (CountDownLatch)responseLatch);
        Assert.assertEquals((Object)member.getUuid(), result.get());
        Assert.assertTrue((boolean)map.containsKey((Object)member.getUuid()));
    }
}

