/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.executor.tasks;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.HazelcastInstanceAware;
import com.hazelcast.core.IMap;
import com.hazelcast.core.Member;
import com.hazelcast.core.PartitionAware;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import java.io.IOException;
import java.util.concurrent.Callable;

public class MapPutPartitionAwareCallable<T, P>
implements Callable<T>,
DataSerializable,
PartitionAware<P>,
HazelcastInstanceAware {
    private HazelcastInstance instance;
    public String mapName;
    public P partitionKey;

    public MapPutPartitionAwareCallable() {
    }

    public MapPutPartitionAwareCallable(String mapName, P partitionKey) {
        this.mapName = mapName;
        this.partitionKey = partitionKey;
    }

    @Override
    public T call() throws Exception {
        Member member = this.instance.getCluster().getLocalMember();
        IMap map = this.instance.getMap(this.mapName);
        map.put((Object)member.getUuid(), (Object)(member.getUuid() + "value"));
        return (T)member.getUuid();
    }

    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeUTF(this.mapName);
    }

    public void readData(ObjectDataInput in) throws IOException {
        this.mapName = in.readUTF();
    }

    public P getPartitionKey() {
        return this.partitionKey;
    }

    public void setHazelcastInstance(HazelcastInstance hazelcastInstance) {
        this.instance = hazelcastInstance;
    }

    public String getMapName() {
        return this.mapName;
    }

    public void setMapName(String mapName) {
        this.mapName = mapName;
    }
}

