/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.executor.tasks;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.HazelcastInstanceAware;
import com.hazelcast.core.IMap;
import com.hazelcast.core.Member;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import java.io.IOException;

public class MapPutRunnable
implements Runnable,
DataSerializable,
HazelcastInstanceAware {
    private HazelcastInstance instance;
    private String mapName;

    public MapPutRunnable() {
    }

    public MapPutRunnable(String mapName) {
        this.mapName = mapName;
    }

    @Override
    public void run() {
        Member member = this.instance.getCluster().getLocalMember();
        IMap map = this.instance.getMap(this.mapName);
        map.put((Object)member.getUuid(), (Object)(member.getUuid() + "value"));
    }

    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeUTF(this.mapName);
    }

    public void readData(ObjectDataInput in) throws IOException {
        this.mapName = in.readUTF();
    }

    public void setHazelcastInstance(HazelcastInstance hazelcastInstance) {
        this.instance = hazelcastInstance;
    }

    public String getMapName() {
        return this.mapName;
    }

    public void setMapName(String mapName) {
        this.mapName = mapName;
    }
}

