/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl;

import com.hazelcast.client.impl.ClientICacheManager;
import com.hazelcast.client.spi.impl.ClientServiceNotFoundException;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.spi.exception.ServiceNotFoundException;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mockito;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientICacheManagerTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void getCache_when_hazelcastExceptionIsThrown_then_isRethrown() {
        HazelcastInstance hzInstance = (HazelcastInstance)Mockito.mock(HazelcastInstance.class);
        Mockito.when((Object)hzInstance.getDistributedObject(Matchers.anyString(), Matchers.anyString())).thenThrow(new Throwable[]{new HazelcastException("mock exception")});
        ClientICacheManager clientCacheManager = new ClientICacheManager(hzInstance);
        this.thrown.expect(HazelcastException.class);
        clientCacheManager.getCache("any-cache");
    }

    @Test
    public void getCache_when_serviceNotFoundExceptionIsThrown_then_illegalStateExceptionIsThrown() {
        HazelcastInstance hzInstance = (HazelcastInstance)Mockito.mock(HazelcastInstance.class);
        HazelcastException hzException = new HazelcastException("mock exception", (Throwable)new ServiceNotFoundException("mock exception"));
        Mockito.when((Object)hzInstance.getDistributedObject(Matchers.anyString(), Matchers.anyString())).thenThrow(new Throwable[]{hzException});
        ClientICacheManager clientCacheManager = new ClientICacheManager(hzInstance);
        this.thrown.expect(IllegalStateException.class);
        clientCacheManager.getCache("any-cache");
    }

    @Test
    public void getCache_when_clientServiceNotFoundExceptionIsThrown_then_illegalStateExceptionIsThrown() {
        HazelcastInstance hzInstance = (HazelcastInstance)Mockito.mock(HazelcastInstance.class);
        Mockito.when((Object)hzInstance.getDistributedObject(Matchers.anyString(), Matchers.anyString())).thenThrow(new Throwable[]{new ClientServiceNotFoundException("mock exception")});
        ClientICacheManager clientCacheManager = new ClientICacheManager(hzInstance);
        this.thrown.expect(IllegalStateException.class);
        clientCacheManager.getCache("any-cache");
    }
}

