/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.listeners;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.impl.ClientTestUtil;
import com.hazelcast.client.impl.HazelcastClientInstanceImpl;
import com.hazelcast.client.spi.impl.listener.ClientEventRegistration;
import com.hazelcast.client.spi.impl.listener.ClientListenerServiceImpl;
import com.hazelcast.client.spi.properties.ClientProperty;
import com.hazelcast.client.test.ClientTestSupport;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.Config;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.LifecycleEvent;
import com.hazelcast.core.LifecycleListener;
import com.hazelcast.core.Member;
import com.hazelcast.core.MemberAttributeEvent;
import com.hazelcast.core.MembershipEvent;
import com.hazelcast.core.MembershipListener;
import com.hazelcast.nio.Connection;
import com.hazelcast.spi.properties.GroupProperty;
import com.hazelcast.test.AssertTask;
import com.hazelcast.test.HazelcastTestSupport;
import java.util.Collection;
import java.util.Collections;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractListenersOnReconnectTest
extends ClientTestSupport {
    protected HazelcastInstance client;
    private AtomicInteger eventCount;
    private String registrationId;
    private int clusterSize;
    private static final int EVENT_COUNT = 10;
    private TestHazelcastFactory factory = new TestHazelcastFactory();
    private Set<String> events = Collections.newSetFromMap(new ConcurrentHashMap());
    private CountDownLatch eventsLatch = new CountDownLatch(1);

    @After
    public void tearDown() {
        this.factory.terminateAll();
    }

    @Test
    public void testListenersNonSmartRoutingTerminateRandomNode() {
        this.factory.newInstances(null, 3);
        ClientConfig clientConfig = this.getNonSmartClientConfig();
        this.client = this.factory.newHazelcastClient(clientConfig);
        this.testListenersTerminateRandomNode();
    }

    @Test
    public void testListenersSmartRoutingTerminateRandomNode() {
        this.factory.newInstances(null, 3);
        ClientConfig clientConfig = this.getSmartClientConfig();
        this.client = this.factory.newHazelcastClient(clientConfig);
        this.testListenersTerminateRandomNode();
    }

    private void testListenersTerminateRandomNode() {
        this.setupListener();
        this.terminateRandomNode();
        HazelcastClientInstanceImpl clientInstanceImpl = this.getHazelcastClientInstanceImpl(this.client);
        final CountDownLatch memberAddedLatch = new CountDownLatch(1);
        clientInstanceImpl.getClientClusterService().addMembershipListener(new MembershipListener(){

            public void memberAdded(MembershipEvent membershipEvent) {
                memberAddedLatch.countDown();
            }

            public void memberRemoved(MembershipEvent membershipEvent) {
            }

            public void memberAttributeChanged(MemberAttributeEvent memberAttributeEvent) {
            }
        });
        this.factory.newHazelcastInstance();
        AbstractListenersOnReconnectTest.assertOpenEventually((CountDownLatch)memberAddedLatch);
        this.validateRegistrationsAndListenerFunctionality();
    }

    @Test
    public void testListenersWaitMemberDestroySmartRouting() {
        Config config = new Config();
        int endpointDelaySeconds = 2;
        config.setProperty(GroupProperty.CLIENT_ENDPOINT_REMOVE_DELAY_SECONDS.getName(), String.valueOf(endpointDelaySeconds));
        this.factory.newInstances(config, 3);
        this.client = this.factory.newHazelcastClient(this.getSmartClientConfig());
        this.setupListener();
        Collection allHazelcastInstances = this.factory.getAllHazelcastInstances();
        final CountDownLatch disconnectedLatch = new CountDownLatch(1);
        final CountDownLatch connectedLatch = new CountDownLatch(1);
        this.client.getLifecycleService().addLifecycleListener(new LifecycleListener(){

            public void stateChanged(LifecycleEvent event) {
                if (LifecycleEvent.LifecycleState.CLIENT_DISCONNECTED == event.getState()) {
                    disconnectedLatch.countDown();
                }
                if (LifecycleEvent.LifecycleState.CLIENT_CONNECTED == event.getState()) {
                    connectedLatch.countDown();
                }
            }
        });
        final HazelcastClientInstanceImpl clientInstanceImpl = this.getHazelcastClientInstanceImpl(this.client);
        AbstractListenersOnReconnectTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() throws Exception {
                Assert.assertEquals((long)3L, (long)clientInstanceImpl.getConnectionManager().getActiveConnections().size());
            }
        });
        HazelcastInstance ownerMember = this.getOwnerServer(this.factory, clientInstanceImpl);
        for (HazelcastInstance member : allHazelcastInstances) {
            this.blockMessagesFromInstance(member, this.client);
        }
        ownerMember.getLifecycleService().terminate();
        for (HazelcastInstance member : allHazelcastInstances) {
            this.unblockMessagesFromInstance(member, this.client);
        }
        AbstractListenersOnReconnectTest.assertOpenEventually((CountDownLatch)disconnectedLatch);
        AbstractListenersOnReconnectTest.assertOpenEventually((CountDownLatch)connectedLatch);
        AbstractListenersOnReconnectTest.sleepAtLeastMillis((long)(endpointDelaySeconds * 1000 + 2000));
        --this.clusterSize;
        this.validateRegistrationsAndListenerFunctionality();
    }

    @Test
    public void testListenersWhenClientDisconnectedOperationRuns_whenOwnerMemberRemoved() {
        Config config = new Config();
        int endpointDelaySeconds = 2;
        config.setProperty(GroupProperty.CLIENT_ENDPOINT_REMOVE_DELAY_SECONDS.getName(), String.valueOf(endpointDelaySeconds));
        HazelcastInstance ownerServer = this.factory.newHazelcastInstance(config);
        this.client = this.factory.newHazelcastClient(this.getSmartClientConfig());
        HazelcastInstance server2 = this.factory.newHazelcastInstance(config);
        this.setupListener();
        final CountDownLatch disconnectedLatch = new CountDownLatch(1);
        final CountDownLatch connectedLatch = new CountDownLatch(1);
        this.client.getLifecycleService().addLifecycleListener(new LifecycleListener(){

            public void stateChanged(LifecycleEvent event) {
                if (LifecycleEvent.LifecycleState.CLIENT_DISCONNECTED == event.getState()) {
                    disconnectedLatch.countDown();
                }
                if (LifecycleEvent.LifecycleState.CLIENT_CONNECTED == event.getState()) {
                    connectedLatch.countDown();
                }
            }
        });
        this.blockMessagesToInstance(server2, this.client);
        ownerServer.shutdown();
        AbstractListenersOnReconnectTest.sleepAtLeastMillis((long)(TimeUnit.SECONDS.toMillis(endpointDelaySeconds) * 2L));
        this.unblockMessagesToInstance(server2, this.client);
        AbstractListenersOnReconnectTest.assertOpenEventually((CountDownLatch)disconnectedLatch);
        AbstractListenersOnReconnectTest.assertOpenEventually((CountDownLatch)connectedLatch);
        --this.clusterSize;
        this.validateRegistrationsAndListenerFunctionality();
    }

    @Test
    public void testListenersWhenClientDisconnectedOperationRuns_whenOwnerConnectionRemoved() {
        Config config = new Config();
        int endpointDelaySeconds = 2;
        config.setProperty(GroupProperty.CLIENT_ENDPOINT_REMOVE_DELAY_SECONDS.getName(), String.valueOf(endpointDelaySeconds));
        config.setProperty(GroupProperty.CLIENT_HEARTBEAT_TIMEOUT_SECONDS.getName(), "4");
        HazelcastInstance ownerServer = this.factory.newHazelcastInstance(config);
        ClientConfig smartClientConfig = this.getSmartClientConfig();
        smartClientConfig.setProperty(ClientProperty.HEARTBEAT_INTERVAL.getName(), "500");
        this.client = this.factory.newHazelcastClient(smartClientConfig);
        this.factory.newHazelcastInstance(config);
        this.setupListener();
        final CountDownLatch disconnectedLatch = new CountDownLatch(1);
        final CountDownLatch connectedLatch = new CountDownLatch(1);
        this.client.getLifecycleService().addLifecycleListener(new LifecycleListener(){

            public void stateChanged(LifecycleEvent event) {
                if (LifecycleEvent.LifecycleState.CLIENT_DISCONNECTED == event.getState()) {
                    disconnectedLatch.countDown();
                }
                if (LifecycleEvent.LifecycleState.CLIENT_CONNECTED == event.getState()) {
                    connectedLatch.countDown();
                }
            }
        });
        this.blockMessagesToInstance(ownerServer, this.client);
        AbstractListenersOnReconnectTest.assertOpenEventually((CountDownLatch)disconnectedLatch);
        AbstractListenersOnReconnectTest.sleepAtLeastMillis((long)(TimeUnit.SECONDS.toMillis(endpointDelaySeconds) * 2L));
        this.unblockMessagesToInstance(ownerServer, this.client);
        AbstractListenersOnReconnectTest.assertOpenEventually((CountDownLatch)connectedLatch);
        this.validateRegistrationsAndListenerFunctionality();
    }

    @Test
    public void testTemporaryBlockedNoDisconnectionSmartRouting() {
        this.factory.newHazelcastInstance();
        ClientConfig clientConfig = this.getSmartClientConfig(4, 1);
        this.client = this.factory.newHazelcastClient(clientConfig);
        this.testListenersTemporaryNetworkBlockage();
    }

    @Test
    public void testTemporaryBlockedNoDisconnectionNonSmartRouting() {
        this.factory.newHazelcastInstance();
        ClientConfig clientConfig = this.getNonSmartClientConfig(4, 1);
        this.client = this.factory.newHazelcastClient(clientConfig);
        this.testListenersTemporaryNetworkBlockage();
    }

    @Test
    public void testTemporaryBlockedNoDisconnectionMultipleServerSmartRouting() {
        this.factory.newInstances(null, 3);
        ClientConfig clientConfig = this.getSmartClientConfig(4, 1);
        this.client = this.factory.newHazelcastClient(clientConfig);
        this.testListenersTemporaryNetworkBlockage();
    }

    @Test
    public void testTemporaryBlockedNoDisconnectionMultipleServerNonSmartRouting() {
        this.factory.newInstances(null, 3);
        ClientConfig clientConfig = this.getNonSmartClientConfig(4, 1);
        this.client = this.factory.newHazelcastClient(clientConfig);
        this.testListenersTemporaryNetworkBlockage();
    }

    private void testListenersTemporaryNetworkBlockage() {
        this.setupListener();
        HazelcastClientInstanceImpl clientInstanceImpl = this.getHazelcastClientInstanceImpl(this.client);
        HazelcastInstance server = this.getOwnerServer(this.factory, clientInstanceImpl);
        long timeout = clientInstanceImpl.getProperties().getMillis(ClientProperty.HEARTBEAT_TIMEOUT);
        long heartbeatTimeout = timeout > 0L ? timeout : (long)Integer.parseInt(ClientProperty.HEARTBEAT_TIMEOUT.getDefaultValue());
        long waitTime = heartbeatTimeout / 2L;
        long endTime = System.currentTimeMillis() + waitTime;
        this.blockMessagesFromInstance(server, this.client);
        long sleepTime = endTime - System.currentTimeMillis();
        if (sleepTime > 0L) {
            AbstractListenersOnReconnectTest.sleepMillis((int)((int)sleepTime));
        }
        this.unblockMessagesFromInstance(server, this.client);
        this.validateRegistrationsAndListenerFunctionality();
    }

    @Test
    public void testClusterReconnectDueToHeartbeatSmartRouting() {
        this.factory.newHazelcastInstance();
        ClientConfig clientConfig = this.getSmartClientConfig(4, 1);
        this.client = this.factory.newHazelcastClient(clientConfig);
        this.testListenersHeartbeatTimeoutToOwner();
    }

    @Test
    public void testClusterReconnectMultipleServersDueToHeartbeatSmartRouting() {
        this.factory.newInstances(null, 3);
        ClientConfig clientConfig = this.getSmartClientConfig(4, 1);
        this.client = this.factory.newHazelcastClient(clientConfig);
        this.testListenersHeartbeatTimeoutToOwner();
    }

    @Test
    public void testClusterReconnectDueToHeartbeatNonSmartRouting() {
        this.factory.newHazelcastInstance();
        ClientConfig clientConfig = this.getNonSmartClientConfig(4, 1);
        this.client = this.factory.newHazelcastClient(clientConfig);
        this.testListenersHeartbeatTimeoutToOwner();
    }

    @Test
    public void testClusterReconnectMultipleServerDueToHeartbeatNonSmartRouting() {
        this.factory.newInstances(null, 3);
        ClientConfig clientConfig = this.getNonSmartClientConfig(4, 1);
        this.client = this.factory.newHazelcastClient(clientConfig);
        this.testListenersHeartbeatTimeoutToOwner();
    }

    private void testListenersHeartbeatTimeoutToOwner() {
        this.setupListener();
        HazelcastClientInstanceImpl clientInstanceImpl = this.getHazelcastClientInstanceImpl(this.client);
        HazelcastInstance server = this.getOwnerServer(this.factory, clientInstanceImpl);
        final CountDownLatch disconnectedLatch = new CountDownLatch(1);
        final CountDownLatch connectedLatch = new CountDownLatch(1);
        this.client.getLifecycleService().addLifecycleListener(new LifecycleListener(){

            public void stateChanged(LifecycleEvent event) {
                if (LifecycleEvent.LifecycleState.CLIENT_DISCONNECTED == event.getState()) {
                    disconnectedLatch.countDown();
                }
                if (LifecycleEvent.LifecycleState.CLIENT_CONNECTED == event.getState()) {
                    connectedLatch.countDown();
                }
            }
        });
        this.blockMessagesFromInstance(server, this.client);
        AbstractListenersOnReconnectTest.assertOpenEventually((CountDownLatch)disconnectedLatch);
        this.unblockMessagesFromInstance(server, this.client);
        AbstractListenersOnReconnectTest.assertOpenEventually((CountDownLatch)connectedLatch);
        this.validateRegistrationsAndListenerFunctionality();
    }

    @Test
    public void testListenersSmartRoutingMultipleServer() {
        this.factory.newInstances(null, 3);
        ClientConfig clientConfig = this.getSmartClientConfig();
        this.client = this.factory.newHazelcastClient(clientConfig);
        this.testListenersTerminateOwnerNode();
    }

    @Test
    public void testListenersNonSmartRoutingMultipleServer() {
        this.factory.newInstances(null, 3);
        ClientConfig clientConfig = this.getNonSmartClientConfig();
        this.client = this.factory.newHazelcastClient(clientConfig);
        this.testListenersTerminateOwnerNode();
    }

    @Test
    public void testListenersSmartRouting() {
        this.factory.newHazelcastInstance();
        ClientConfig clientConfig = this.getSmartClientConfig();
        this.client = this.factory.newHazelcastClient(clientConfig);
        this.testListenersTerminateOwnerNode();
    }

    @Test
    public void testListenersNonSmartRouting() {
        this.factory.newHazelcastInstance();
        ClientConfig clientConfig = this.getNonSmartClientConfig();
        this.client = this.factory.newHazelcastClient(clientConfig);
        this.testListenersTerminateOwnerNode();
    }

    private void testListenersTerminateOwnerNode() {
        this.setupListener();
        final CountDownLatch disconnectedLatch = new CountDownLatch(1);
        final CountDownLatch connectedLatch = new CountDownLatch(1);
        this.client.getLifecycleService().addLifecycleListener(new LifecycleListener(){

            public void stateChanged(LifecycleEvent event) {
                if (LifecycleEvent.LifecycleState.CLIENT_DISCONNECTED == event.getState()) {
                    disconnectedLatch.countDown();
                }
                if (LifecycleEvent.LifecycleState.CLIENT_CONNECTED == event.getState()) {
                    connectedLatch.countDown();
                }
            }
        });
        HazelcastClientInstanceImpl clientInstanceImpl = this.getHazelcastClientInstanceImpl(this.client);
        HazelcastInstance server = this.getOwnerServer(this.factory, clientInstanceImpl);
        server.getLifecycleService().terminate();
        this.factory.newHazelcastInstance();
        AbstractListenersOnReconnectTest.assertClusterSizeEventually((int)this.clusterSize, (HazelcastInstance)this.client);
        AbstractListenersOnReconnectTest.assertOpenEventually((CountDownLatch)disconnectedLatch);
        AbstractListenersOnReconnectTest.assertOpenEventually((CountDownLatch)connectedLatch);
        this.validateRegistrationsAndListenerFunctionality();
    }

    private void setupListener() {
        this.clusterSize = this.factory.getAllHazelcastInstances().size();
        AbstractListenersOnReconnectTest.assertClusterSizeEventually((int)this.clusterSize, (HazelcastInstance)this.client);
        this.eventCount = new AtomicInteger();
        this.registrationId = this.addListener();
    }

    private void validateRegistrationsAndListenerFunctionality() {
        AbstractListenersOnReconnectTest.assertClusterSizeEventually((int)this.clusterSize, (HazelcastInstance)this.client);
        this.validateRegistrations(this.clusterSize, this.registrationId, this.getHazelcastClientInstanceImpl(this.client));
        this.validateListenerFunctionality();
        Assert.assertTrue((boolean)this.removeListener(this.registrationId));
    }

    private void validateRegistrations(final int clusterSize, final String registrationId, final HazelcastClientInstanceImpl clientInstanceImpl) {
        final boolean smartRouting = clientInstanceImpl.getClientConfig().getNetworkConfig().isSmartRouting();
        AbstractListenersOnReconnectTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() throws Exception {
                int size = smartRouting ? clusterSize : 1;
                Collection registrations = AbstractListenersOnReconnectTest.this.getClientEventRegistrations(AbstractListenersOnReconnectTest.this.client, registrationId);
                Assert.assertEquals((long)size, (long)registrations.size());
                if (smartRouting) {
                    Collection members = clientInstanceImpl.getClientClusterService().getMemberList();
                    for (ClientEventRegistration registration : registrations) {
                        Connection registeredSubscriber = registration.getSubscriber();
                        boolean contains = false;
                        for (Member member : members) {
                            contains |= registeredSubscriber.getEndPoint().equals((Object)member.getAddress());
                        }
                        Assert.assertTrue((String)("Registered member " + registeredSubscriber + " is not in the cluster member list " + members), (boolean)contains);
                    }
                } else {
                    ClientEventRegistration registration = (ClientEventRegistration)registrations.iterator().next();
                    Assert.assertEquals((Object)clientInstanceImpl.getClientClusterService().getOwnerConnectionAddress(), (Object)registration.getSubscriber().getEndPoint());
                }
            }
        });
    }

    private void validateListenerFunctionality() {
        AbstractListenersOnReconnectTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() throws Exception {
                AbstractListenersOnReconnectTest.this.events.clear();
                AbstractListenersOnReconnectTest.this.eventCount.set(0);
                for (int i = 0; i < 10; ++i) {
                    AbstractListenersOnReconnectTest.this.events.add(HazelcastTestSupport.randomString());
                }
                for (String event : AbstractListenersOnReconnectTest.this.events) {
                    AbstractListenersOnReconnectTest.this.produceEvent(event);
                }
                HazelcastTestSupport.assertOpenEventually((CountDownLatch)AbstractListenersOnReconnectTest.this.eventsLatch);
                HazelcastTestSupport.assertTrueAllTheTime((AssertTask)new AssertTask(){

                    public void run() throws Exception {
                        int count = AbstractListenersOnReconnectTest.this.eventCount.get();
                        Assert.assertEquals((String)("Received event count is " + count + " but it is expected to stay at " + 10), (long)10L, (long)AbstractListenersOnReconnectTest.this.eventCount.get());
                    }
                }, (long)3L);
            }
        });
    }

    private void terminateRandomNode() {
        int clusterSize = this.factory.getAllHazelcastInstances().size();
        HazelcastInstance[] instances = new HazelcastInstance[clusterSize];
        this.factory.getAllHazelcastInstances().toArray(instances);
        int randNode = new Random().nextInt(clusterSize);
        instances[randNode].getLifecycleService().terminate();
    }

    private Collection<ClientEventRegistration> getClientEventRegistrations(HazelcastInstance client, String id) {
        HazelcastClientInstanceImpl clientImpl = ClientTestUtil.getHazelcastClientInstanceImpl(client);
        ClientListenerServiceImpl listenerService = (ClientListenerServiceImpl)clientImpl.getListenerService();
        return listenerService.getActiveRegistrations(id);
    }

    private ClientConfig getNonSmartClientConfig(int heartbeatTimeoutSeconds, int heartbeatIntervalSeconds) {
        ClientConfig clientConfig = this.getSmartClientConfig(heartbeatTimeoutSeconds, heartbeatIntervalSeconds);
        clientConfig.getNetworkConfig().setSmartRouting(false);
        return clientConfig;
    }

    private ClientConfig getSmartClientConfig(int heartbeatTimeoutSeconds, int heartbeatIntervalSeconds) {
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.getNetworkConfig().setConnectionAttemptLimit(Integer.MAX_VALUE);
        clientConfig.getNetworkConfig().setRedoOperation(true);
        clientConfig.setProperty(ClientProperty.HEARTBEAT_TIMEOUT.getName(), String.valueOf(TimeUnit.SECONDS.toMillis(heartbeatTimeoutSeconds)));
        clientConfig.setProperty(ClientProperty.HEARTBEAT_INTERVAL.getName(), String.valueOf(TimeUnit.SECONDS.toMillis(heartbeatIntervalSeconds)));
        return clientConfig;
    }

    private ClientConfig getSmartClientConfig() {
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.getNetworkConfig().setConnectionAttemptLimit(Integer.MAX_VALUE);
        clientConfig.getNetworkConfig().setRedoOperation(true);
        return clientConfig;
    }

    private ClientConfig getNonSmartClientConfig() {
        ClientConfig clientConfig = this.getSmartClientConfig();
        clientConfig.getNetworkConfig().setSmartRouting(false);
        return clientConfig;
    }

    protected abstract String addListener();

    protected abstract void produceEvent(String var1);

    void onEvent(String event) {
        this.events.remove(event);
        this.eventCount.incrementAndGet();
        if (this.events.isEmpty()) {
            this.eventsLatch.countDown();
        }
    }

    protected abstract boolean removeListener(String var1);
}

