/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.listeners.leak;

import com.hazelcast.client.ClientEndpoint;
import com.hazelcast.client.impl.ClientTestUtil;
import com.hazelcast.client.impl.HazelcastClientInstanceImpl;
import com.hazelcast.client.spi.impl.listener.ClientEventRegistration;
import com.hazelcast.client.spi.impl.listener.ClientListenerServiceImpl;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.instance.Node;
import com.hazelcast.test.HazelcastTestSupport;
import java.util.ArrayList;
import java.util.Collection;
import org.junit.After;
import org.junit.Assert;

public class ListenerLeakTestSupport
extends HazelcastTestSupport {
    protected final TestHazelcastFactory hazelcastFactory = new TestHazelcastFactory();

    @After
    public void cleanup() {
        this.hazelcastFactory.terminateAll();
    }

    protected void assertNoLeftOver(Collection<Node> nodes, HazelcastInstance client, String id, Collection<ClientEventRegistration> registrations) {
        for (Node node : nodes) {
            this.assertNoLeftOverOnNode(node, registrations);
        }
        Assert.assertEquals((long)0L, (long)this.getClientEventRegistrations(client, id).size());
    }

    protected Collection<Node> createNodes() {
        int NODE_COUNT = 3;
        ArrayList<Node> nodes = new ArrayList<Node>(3);
        for (int i = 0; i < NODE_COUNT; ++i) {
            HazelcastInstance hazelcast = this.hazelcastFactory.newHazelcastInstance();
            nodes.add(ListenerLeakTestSupport.getNode((HazelcastInstance)hazelcast));
        }
        return nodes;
    }

    protected void assertNoLeftOverOnNode(Node node, Collection<ClientEventRegistration> registrations) {
        Collection endpoints = node.clientEngine.getEndpointManager().getEndpoints();
        for (ClientEndpoint endpoint : endpoints) {
            for (ClientEventRegistration registration : registrations) {
                Assert.assertFalse((boolean)endpoint.removeDestroyAction(registration.getServerRegistrationId()));
            }
        }
    }

    protected Collection<ClientEventRegistration> getClientEventRegistrations(HazelcastInstance client, String id) {
        HazelcastClientInstanceImpl clientImpl = ClientTestUtil.getHazelcastClientInstanceImpl(client);
        ClientListenerServiceImpl listenerService = (ClientListenerServiceImpl)clientImpl.getListenerService();
        return listenerService.getActiveRegistrations(id);
    }
}

