/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.loadBalancer;

import com.hazelcast.client.LoadBalancer;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.util.RandomLB;
import com.hazelcast.core.Cluster;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.Member;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.TestHazelcastInstanceFactory;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientRandomLBTest {
    @Test
    public void testRandomLB_withoutMembers() {
        RandomLB lb = new RandomLB();
        Member m = lb.next();
        Assert.assertNull((Object)m);
    }

    @Test
    public void testRandomLB_withMembers() {
        RandomLB randomLB = new RandomLB();
        TestHazelcastInstanceFactory factory = new TestHazelcastInstanceFactory();
        HazelcastInstance server = factory.newHazelcastInstance();
        Cluster cluster = server.getCluster();
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.setLoadBalancer((LoadBalancer)randomLB);
        randomLB.init(cluster, clientConfig);
        Member member = cluster.getLocalMember();
        Member nextMember = randomLB.next();
        Assert.assertEquals((Object)member, (Object)nextMember);
        factory.terminateAll();
    }
}

