/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.lock;

import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.ILock;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientLockWithTerminationTest {
    private final TestHazelcastFactory hazelcastFactory = new TestHazelcastFactory();
    private HazelcastInstance node2;
    private HazelcastInstance client1;
    private HazelcastInstance client2;
    private String keyOwnedByNode2;

    @Before
    public void setup() throws InterruptedException {
        this.hazelcastFactory.newHazelcastInstance();
        this.node2 = this.hazelcastFactory.newHazelcastInstance();
        this.client1 = this.hazelcastFactory.newHazelcastClient();
        this.client2 = this.hazelcastFactory.newHazelcastClient();
        HazelcastTestSupport.warmUpPartitions((HazelcastInstance[])new HazelcastInstance[]{this.node2});
        this.keyOwnedByNode2 = HazelcastTestSupport.generateKeyOwnedBy((HazelcastInstance)this.node2);
    }

    @After
    public void tearDown() throws IOException {
        this.hazelcastFactory.terminateAll();
    }

    @Test
    public void testLockOnClientCrash() throws InterruptedException {
        ILock lock = this.client1.getLock(this.keyOwnedByNode2);
        lock.lock();
        this.client1.getLifecycleService().terminate();
        lock = this.client2.getLock(this.keyOwnedByNode2);
        boolean lockObtained = lock.tryLock(120L, TimeUnit.SECONDS);
        Assert.assertTrue((String)"Lock was Not Obtained, lock should be released on client crash", (boolean)lockObtained);
    }

    @Test
    public void testLockOnClient_withNodeCrash() throws InterruptedException {
        ILock lock = this.client1.getLock(this.keyOwnedByNode2);
        lock.lock();
        this.node2.getLifecycleService().terminate();
        lock = this.client2.getLock(this.keyOwnedByNode2);
        boolean lockObtained = lock.tryLock();
        Assert.assertFalse((String)"Lock was obtained by 2 different clients ", (boolean)lockObtained);
    }
}

