/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.lock;

import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.ICondition;
import com.hazelcast.core.ILock;
import com.hazelcast.spi.exception.DistributedObjectDestroyedException;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class LegacyClientConditionTest
extends HazelcastTestSupport {
    private final TestHazelcastFactory hazelcastFactory = new TestHazelcastFactory();
    private HazelcastInstance client;
    private ILock lock;

    @Before
    public void setup() {
        this.hazelcastFactory.newHazelcastInstance();
        this.client = this.hazelcastFactory.newHazelcastClient();
        this.lock = this.client.getLock(LegacyClientConditionTest.randomString());
    }

    @After
    public void tearDown() {
        this.lock.forceUnlock();
        this.hazelcastFactory.terminateAll();
    }

    @Test
    public void testLockConditionSimpleUsage() throws InterruptedException {
        String name = LegacyClientConditionTest.randomString();
        final ILock lock = this.client.getLock(name);
        final ICondition condition = lock.newCondition(LegacyClientConditionTest.randomString());
        final AtomicInteger count = new AtomicInteger(0);
        final CountDownLatch threadGetTheLock = new CountDownLatch(1);
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                lock.lock();
                threadGetTheLock.countDown();
                try {
                    if (lock.isLockedByCurrentThread()) {
                        count.incrementAndGet();
                    }
                    condition.await();
                    if (lock.isLockedByCurrentThread()) {
                        count.incrementAndGet();
                    }
                }
                catch (InterruptedException interruptedException) {
                }
                finally {
                    lock.unlock();
                }
            }
        });
        t.start();
        LegacyClientConditionTest.assertOpenEventually((CountDownLatch)threadGetTheLock);
        lock.lock();
        Assert.assertEquals((Object)true, (Object)lock.isLocked());
        condition.signal();
        lock.unlock();
        t.join();
        Assert.assertEquals((long)2L, (long)count.get());
    }

    @Test
    public void testLockConditionSignalAll() throws InterruptedException {
        String name = "testLockConditionSimpleUsage";
        final ILock lock = this.client.getLock("testLockConditionSimpleUsage");
        final ICondition condition = lock.newCondition("testLockConditionSimpleUsagec");
        final AtomicInteger count = new AtomicInteger(0);
        int k = 50;
        final CountDownLatch awaitLatch = new CountDownLatch(50);
        final CountDownLatch finalLatch = new CountDownLatch(50);
        for (int i = 0; i < 50; ++i) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    lock.lock();
                    try {
                        if (lock.isLockedByCurrentThread()) {
                            count.incrementAndGet();
                        }
                        awaitLatch.countDown();
                        condition.await();
                        if (lock.isLockedByCurrentThread()) {
                            count.incrementAndGet();
                        }
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    finally {
                        lock.unlock();
                        finalLatch.countDown();
                    }
                }
            }).start();
        }
        awaitLatch.await(1L, TimeUnit.MINUTES);
        lock.lock();
        condition.signalAll();
        lock.unlock();
        finalLatch.await(1L, TimeUnit.MINUTES);
        Assert.assertEquals((long)100L, (long)count.get());
    }

    @Test(expected=DistributedObjectDestroyedException.class)
    public void testDestroyLockWhenOtherWaitingOnConditionAwait() {
        final ILock lock = this.client.getLock("testDestroyLockWhenOtherWaitingOnConditionAwait");
        ICondition condition = lock.newCondition("condition");
        final CountDownLatch latch = new CountDownLatch(1);
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    latch.await(30L, TimeUnit.SECONDS);
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                lock.destroy();
            }
        }).start();
        lock.lock();
        try {
            latch.countDown();
            condition.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        lock.unlock();
    }

    @Test(expected=IllegalMonitorStateException.class)
    public void testIllegalConditionUsageWithoutAcquiringLock() {
        ICondition condition = this.lock.newCondition("condition");
        try {
            condition.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Test(expected=IllegalMonitorStateException.class)
    public void testIllegalConditionUsageSignalToNonAwaiter() {
        ICondition condition = this.lock.newCondition("condition");
        condition.signal();
    }

    @Test
    public void testConditionUsage() throws InterruptedException {
        this.lock.lock();
        ICondition condition = this.lock.newCondition("condition");
        condition.await(1L, TimeUnit.SECONDS);
        this.lock.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAwaitNanos_remainingTime() throws InterruptedException {
        ICondition condition = this.lock.newCondition("condition");
        this.lock.lock();
        try {
            long timeout = 1000L;
            long remainingTimeout = condition.awaitNanos(timeout);
            Assert.assertTrue((String)("Remaining timeout should be <= 0, but it's = " + remainingTimeout), (remainingTimeout <= 0L ? 1 : 0) != 0);
        }
        finally {
            this.lock.unlock();
        }
    }
}

