/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.map;

import com.hazelcast.client.proxy.ClientMapProxy;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.test.HazelcastTestSupport;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;

public abstract class AbstractMapPartitionIteratorTest
extends HazelcastTestSupport {
    @Parameterized.Parameter
    public boolean prefetchValues;
    protected TestHazelcastFactory factory;
    protected HazelcastInstance server;
    protected HazelcastInstance client;

    @Parameterized.Parameters(name="prefetchValues:{0}")
    public static Iterable<Object[]> parameters() {
        return Arrays.asList({Boolean.TRUE}, {Boolean.FALSE});
    }

    @After
    public void teardown() {
        this.factory.terminateAll();
    }

    @Test
    public void test_HasNext_Returns_False_On_EmptyPartition() throws Exception {
        ClientMapProxy map = this.getMapProxy();
        Iterator iterator = map.iterator(10, 1, this.prefetchValues);
        junit.framework.Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void test_HasNext_Returns_True_On_NonEmptyPartition() throws Exception {
        ClientMapProxy map = this.getMapProxy();
        String key = AbstractMapPartitionIteratorTest.generateKeyForPartition((HazelcastInstance)this.server, (int)1);
        String value = AbstractMapPartitionIteratorTest.randomString();
        map.put((Object)key, (Object)value);
        Iterator iterator = map.iterator(10, 1, this.prefetchValues);
        junit.framework.Assert.assertTrue((boolean)iterator.hasNext());
    }

    @Test
    public void test_Next_Returns_Value_On_NonEmptyPartition() throws Exception {
        ClientMapProxy map = this.getMapProxy();
        String key = AbstractMapPartitionIteratorTest.generateKeyForPartition((HazelcastInstance)this.server, (int)1);
        String value = AbstractMapPartitionIteratorTest.randomString();
        map.put((Object)key, (Object)value);
        Iterator iterator = map.iterator(10, 1, this.prefetchValues);
        Map.Entry entry = (Map.Entry)iterator.next();
        Assert.assertEquals((Object)value, entry.getValue());
    }

    @Test
    public void test_Next_Returns_Values_When_FetchSizeExceeds_On_NonEmptyPartition() throws Exception {
        ClientMapProxy map = this.getMapProxy();
        String value = AbstractMapPartitionIteratorTest.randomString();
        int count = 1000;
        for (int i = 0; i < count; ++i) {
            String key = AbstractMapPartitionIteratorTest.generateKeyForPartition((HazelcastInstance)this.server, (int)42);
            map.put((Object)key, (Object)value);
        }
        Iterator iterator = map.iterator(10, 42, this.prefetchValues);
        for (int i = 0; i < count; ++i) {
            Map.Entry entry = (Map.Entry)iterator.next();
            Assert.assertEquals((Object)value, entry.getValue());
        }
    }

    private <K, V> ClientMapProxy<K, V> getMapProxy() {
        String mapName = AbstractMapPartitionIteratorTest.randomString();
        return (ClientMapProxy)this.client.getMap(mapName);
    }
}

