/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.map;

import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.Config;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.core.ReadOnly;
import com.hazelcast.map.AbstractEntryProcessor;
import com.hazelcast.map.EntryBackupProcessor;
import com.hazelcast.map.EntryProcessor;
import com.hazelcast.query.IndexAwarePredicate;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.TruePredicate;
import com.hazelcast.query.impl.FalsePredicate;
import com.hazelcast.query.impl.QueryContext;
import com.hazelcast.query.impl.QueryableEntry;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientEntryProcessorTest
extends HazelcastTestSupport {
    private static final String MAP_NAME = "default";
    private HazelcastInstance client;
    private HazelcastInstance member1;
    private HazelcastInstance member2;

    @Before
    public void setUp() throws Exception {
        Config config = this.getConfig();
        TestHazelcastFactory hazelcastFactory = new TestHazelcastFactory();
        this.member1 = hazelcastFactory.newHazelcastInstance(config);
        this.member2 = hazelcastFactory.newHazelcastInstance(config);
        this.client = hazelcastFactory.newHazelcastClient();
    }

    @After
    public void tearDown() throws Exception {
        this.client.shutdown();
        this.member1.shutdown();
        this.member2.shutdown();
    }

    @Test
    public void test_executeOnEntries_updatesValue_onOwnerAndBackupPartition() {
        String member1Key = ClientEntryProcessorTest.generateKeyOwnedBy((HazelcastInstance)this.member1);
        IMap clientMap = this.client.getMap(MAP_NAME);
        clientMap.put((Object)member1Key, (Object)"value");
        clientMap.executeOnEntries((EntryProcessor)new ValueUpdater("newValue"));
        IMap member1Map = this.member1.getMap(MAP_NAME);
        String member1Value = (String)member1Map.get((Object)member1Key);
        this.member1.shutdown();
        IMap member2Map = this.member2.getMap(MAP_NAME);
        String member2Value = (String)member2Map.get((Object)member1Key);
        Assert.assertEquals((Object)"newValue", (Object)member1Value);
        Assert.assertEquals((Object)"newValue", (Object)member2Value);
    }

    @Test
    public void test_executeOnEntries_notUpdatesValue_with_FalsePredicate() {
        String member1Key = ClientEntryProcessorTest.generateKeyOwnedBy((HazelcastInstance)this.member1);
        IMap clientMap = this.client.getMap(MAP_NAME);
        clientMap.put((Object)member1Key, (Object)"value");
        clientMap.executeOnEntries((EntryProcessor)new ValueUpdater("newValue"), (Predicate)FalsePredicate.INSTANCE);
        IMap member1Map = this.member1.getMap(MAP_NAME);
        String member1Value = (String)member1Map.get((Object)member1Key);
        Assert.assertEquals((Object)"value", (Object)member1Value);
    }

    @Test
    public void test_executeOnEntries_updatesValue_with_TruePredicate() {
        String member1Key = ClientEntryProcessorTest.generateKeyOwnedBy((HazelcastInstance)this.member1);
        IMap clientMap = this.client.getMap(MAP_NAME);
        clientMap.put((Object)member1Key, (Object)"value");
        clientMap.executeOnEntries((EntryProcessor)new ValueUpdater("newValue"), (Predicate)TruePredicate.INSTANCE);
        IMap member1Map = this.member1.getMap(MAP_NAME);
        String member1Value = (String)member1Map.get((Object)member1Key);
        Assert.assertEquals((Object)"newValue", (Object)member1Value);
    }

    @Test
    public void test_executeOnEntriesWithPredicate_usesIndexes_whenIndexesAvailable() {
        IMap map = this.client.getMap("test");
        map.addIndex("__key", true);
        for (int i = 0; i < 10; ++i) {
            map.put((Object)i, (Object)i);
        }
        IndexedTestPredicate predicate = new IndexedTestPredicate();
        map.executeOnEntries((EntryProcessor)new EP(), (Predicate)predicate);
        Assert.assertTrue((String)"isIndexed method of IndexAwarePredicate should be called", (boolean)IndexedTestPredicate.INDEX_CALLED.get());
    }

    @Test(expected=UnsupportedOperationException.class)
    public void test_executeOnKey_readOnly_setValue() {
        String member1Key = ClientEntryProcessorTest.generateKeyOwnedBy((HazelcastInstance)this.member1);
        IMap clientMap = this.client.getMap(MAP_NAME);
        clientMap.put((Object)member1Key, (Object)"value");
        clientMap.executeOnKey((Object)member1Key, (EntryProcessor)new ValueUpdaterReadOnly("newValue"));
    }

    public static class ValueUpdaterReadOnly
    implements EntryProcessor,
    ReadOnly {
        private final String newValue;

        public ValueUpdaterReadOnly(String newValue) {
            this.newValue = newValue;
        }

        public Object process(Map.Entry entry) {
            entry.setValue(this.newValue);
            return null;
        }

        public EntryBackupProcessor getBackupProcessor() {
            return null;
        }
    }

    public static class ValueUpdater
    extends AbstractEntryProcessor {
        private final String newValue;

        public ValueUpdater(String newValue) {
            this.newValue = newValue;
        }

        public Object process(Map.Entry entry) {
            entry.setValue(this.newValue);
            return null;
        }
    }

    private static class IndexedTestPredicate
    implements IndexAwarePredicate {
        public static final AtomicBoolean INDEX_CALLED = new AtomicBoolean(false);

        private IndexedTestPredicate() {
        }

        public Set<QueryableEntry> filter(QueryContext queryContext) {
            return null;
        }

        public boolean isIndexed(QueryContext queryContext) {
            INDEX_CALLED.set(true);
            return true;
        }

        public boolean apply(Map.Entry mapEntry) {
            return false;
        }
    }

    public static final class EP
    extends AbstractEntryProcessor {
        public Object process(Map.Entry entry) {
            return null;
        }
    }
}

