/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.map;

import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.Config;
import com.hazelcast.core.EntryAdapter;
import com.hazelcast.core.EntryListener;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.core.MapEvent;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientMapEvictAllTest
extends HazelcastTestSupport {
    private final TestHazelcastFactory hazelcastFactory = new TestHazelcastFactory();

    @After
    public void tearDown() {
        this.hazelcastFactory.terminateAll();
    }

    @Test
    public void evictAll_firesEvent() throws Exception {
        String mapName = ClientMapEvictAllTest.randomMapName();
        Config config = this.getConfig();
        this.hazelcastFactory.newHazelcastInstance(config);
        this.hazelcastFactory.newHazelcastInstance(config);
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient();
        IMap map = client.getMap(mapName);
        final CountDownLatch evictedEntryCount = new CountDownLatch(3);
        map.addEntryListener((EntryListener)new EntryAdapter<Object, Object>(){

            public void mapEvicted(MapEvent event) {
                int affected = event.getNumberOfEntriesAffected();
                for (int i = 0; i < affected; ++i) {
                    evictedEntryCount.countDown();
                }
            }
        }, true);
        map.put((Object)1, (Object)1);
        map.put((Object)2, (Object)1);
        map.put((Object)3, (Object)1);
        map.evictAll();
        ClientMapEvictAllTest.assertOpenEventually((CountDownLatch)evictedEntryCount);
        Assert.assertEquals((long)0L, (long)map.size());
    }

    @Test
    public void evictAll_firesOnlyOneEvent() throws Exception {
        String mapName = ClientMapEvictAllTest.randomMapName();
        Config config = this.getConfig();
        this.hazelcastFactory.newHazelcastInstance(config);
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient();
        IMap map = client.getMap(mapName);
        final CountDownLatch eventCount = new CountDownLatch(2);
        map.addEntryListener((EntryListener)new EntryAdapter<Object, Object>(){

            public void mapEvicted(MapEvent event) {
                eventCount.countDown();
            }
        }, true);
        map.put((Object)1, (Object)1);
        map.put((Object)2, (Object)1);
        map.put((Object)3, (Object)1);
        map.evictAll();
        Assert.assertFalse((boolean)eventCount.await(10L, TimeUnit.SECONDS));
        Assert.assertEquals((long)1L, (long)eventCount.getCount());
    }
}

