/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.map;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.spi.properties.ClientProperty;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.Config;
import com.hazelcast.core.EntryAdapter;
import com.hazelcast.core.EntryListener;
import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.ICompletableFuture;
import com.hazelcast.core.IMap;
import com.hazelcast.instance.TestUtil;
import com.hazelcast.map.EntryBackupProcessor;
import com.hazelcast.map.EntryProcessor;
import com.hazelcast.query.PagingPredicate;
import com.hazelcast.query.Predicate;
import com.hazelcast.spi.EventService;
import com.hazelcast.spi.impl.eventservice.InternalEventService;
import com.hazelcast.spi.properties.GroupProperty;
import com.hazelcast.test.AssertTask;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.NightlyTest;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientMapIssueTest
extends HazelcastTestSupport {
    private final TestHazelcastFactory hazelcastFactory = new TestHazelcastFactory();

    @After
    public void tearDown() {
        this.hazelcastFactory.terminateAll();
    }

    @Test
    public void testListenerRegistrations() throws Exception {
        Config config = this.getConfig();
        HazelcastInstance instance1 = this.hazelcastFactory.newHazelcastInstance(config);
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient();
        String mapName = ClientMapIssueTest.randomMapName();
        IMap map = client.getMap(mapName);
        map.addEntryListener((EntryListener)new EntryAdapter(), true);
        HazelcastInstance instance2 = this.hazelcastFactory.newHazelcastInstance(config);
        instance1.getLifecycleService().terminate();
        instance1 = this.hazelcastFactory.newHazelcastInstance(config);
        InternalEventService eventService1 = TestUtil.getNode((HazelcastInstance)instance1).nodeEngine.getEventService();
        InternalEventService eventService2 = TestUtil.getNode((HazelcastInstance)instance2).nodeEngine.getEventService();
        ClientMapIssueTest.assertTrueEventually((AssertTask)new AssertTask((EventService)eventService1, mapName, (EventService)eventService2){
            final /* synthetic */ EventService val$eventService1;
            final /* synthetic */ String val$mapName;
            final /* synthetic */ EventService val$eventService2;
            {
                this.val$eventService1 = eventService;
                this.val$mapName = string;
                this.val$eventService2 = eventService2;
            }

            public void run() throws Exception {
                Collection regs1 = this.val$eventService1.getRegistrations("hz:impl:mapService", this.val$mapName);
                Collection regs2 = this.val$eventService2.getRegistrations("hz:impl:mapService", this.val$mapName);
                Assert.assertEquals((String)"there should be only one registration", (long)1L, (long)regs1.size());
                Assert.assertEquals((String)"there should be only one registration", (long)1L, (long)regs2.size());
            }
        });
    }

    @Test
    public void testFutureGetCalledInCallback() {
        this.hazelcastFactory.newHazelcastInstance();
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient();
        IMap map = client.getMap("map");
        final ICompletableFuture future = map.getAsync((Object)1);
        final CountDownLatch latch = new CountDownLatch(1);
        future.andThen((ExecutionCallback)new ExecutionCallback<Integer>(){

            public void onResponse(Integer response) {
                try {
                    future.get();
                    latch.countDown();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            public void onFailure(Throwable t) {
            }
        });
        ClientMapIssueTest.assertOpenEventually((CountDownLatch)latch, (long)10L);
    }

    @Test
    @Category(value={NightlyTest.class})
    public void testOperationNotBlockingAfterClusterShutdown() throws InterruptedException {
        Config config = this.getConfig();
        HazelcastInstance instance1 = this.hazelcastFactory.newHazelcastInstance(config);
        HazelcastInstance instance2 = this.hazelcastFactory.newHazelcastInstance(config);
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.setExecutorPoolSize(1);
        clientConfig.getNetworkConfig().setConnectionAttemptLimit(Integer.MAX_VALUE);
        clientConfig.setProperty(ClientProperty.INVOCATION_TIMEOUT_SECONDS.getName(), "10");
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient(clientConfig);
        final IMap map = client.getMap(ClientMapIssueTest.randomMapName());
        map.put((Object)ClientMapIssueTest.randomString(), (Object)ClientMapIssueTest.randomString());
        instance1.getLifecycleService().terminate();
        instance2.getLifecycleService().terminate();
        final CountDownLatch latch = new CountDownLatch(1);
        new Thread(){

            @Override
            public void run() {
                try {
                    map.get((Object)HazelcastTestSupport.randomString());
                }
                catch (Exception exception) {
                }
                finally {
                    latch.countDown();
                }
            }
        }.start();
        ClientMapIssueTest.assertOpenEventually((CountDownLatch)latch);
    }

    @Test
    @Category(value={NightlyTest.class})
    public void testOperationNotBlockingAfterClusterShutdown_withOneExecutorPoolSize() throws InterruptedException {
        Config config = this.getConfig();
        HazelcastInstance instance1 = this.hazelcastFactory.newHazelcastInstance(config);
        HazelcastInstance instance2 = this.hazelcastFactory.newHazelcastInstance(config);
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.setExecutorPoolSize(1);
        clientConfig.getNetworkConfig().setConnectionAttemptLimit(Integer.MAX_VALUE);
        clientConfig.setProperty(ClientProperty.INVOCATION_TIMEOUT_SECONDS.getName(), "10");
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient(clientConfig);
        final IMap map = client.getMap(ClientMapIssueTest.randomMapName());
        map.put((Object)ClientMapIssueTest.randomString(), (Object)ClientMapIssueTest.randomString());
        instance1.getLifecycleService().terminate();
        instance2.getLifecycleService().terminate();
        final CountDownLatch latch = new CountDownLatch(1);
        new Thread(){

            @Override
            public void run() {
                try {
                    map.get((Object)HazelcastTestSupport.randomString());
                }
                catch (Exception exception) {
                }
                finally {
                    latch.countDown();
                }
            }
        }.start();
        ClientMapIssueTest.assertOpenEventually((CountDownLatch)latch);
    }

    @Test
    public void testMapPagingEntries() {
        Config config = this.getConfig();
        this.hazelcastFactory.newHazelcastInstance(config);
        this.hazelcastFactory.newHazelcastInstance(config);
        ClientConfig clientConfig = new ClientConfig();
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient(clientConfig);
        IMap map = client.getMap("map");
        int size = 50;
        int pageSize = 5;
        for (int i = 0; i < 50; ++i) {
            map.put((Object)i, (Object)i);
        }
        PagingPredicate predicate = new PagingPredicate(5);
        predicate.nextPage();
        Set entries = map.entrySet((Predicate)predicate);
        Assert.assertEquals((long)5L, (long)entries.size());
    }

    @Test
    public void testMapPagingValues() {
        Config config = this.getConfig();
        this.hazelcastFactory.newHazelcastInstance(config);
        this.hazelcastFactory.newHazelcastInstance(config);
        ClientConfig clientConfig = new ClientConfig();
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient(clientConfig);
        IMap map = client.getMap("map");
        int size = 50;
        int pageSize = 5;
        for (int i = 0; i < 50; ++i) {
            map.put((Object)i, (Object)i);
        }
        PagingPredicate predicate = new PagingPredicate(5);
        predicate.nextPage();
        Collection values = map.values((Predicate)predicate);
        Assert.assertEquals((long)5L, (long)values.size());
        predicate.setPage(0);
        values = map.values((Predicate)predicate);
        Assert.assertEquals((long)5L, (long)values.size());
        int i = 0;
        for (Integer value : values) {
            Assert.assertEquals((long)i, (long)value.intValue());
            ++i;
        }
        values = map.values((Predicate)predicate);
        Assert.assertEquals((long)5L, (long)values.size());
        i = 0;
        for (Integer value : values) {
            Assert.assertEquals((long)i, (long)value.intValue());
            ++i;
        }
        predicate.nextPage();
        values = map.values((Predicate)predicate);
        Assert.assertEquals((long)5L, (long)values.size());
        i = 5;
        for (Integer value : values) {
            Assert.assertEquals((long)i, (long)value.intValue());
            ++i;
        }
        Map.Entry anchor = predicate.getAnchor();
        Assert.assertEquals((Object)9, anchor.getKey());
        Assert.assertEquals((Object)9, anchor.getValue());
        predicate.setPage(4);
        values = map.values((Predicate)predicate);
        Assert.assertEquals((long)5L, (long)values.size());
        i = 20;
        for (Integer value : values) {
            Assert.assertEquals((long)i, (long)value.intValue());
            ++i;
        }
        anchor = predicate.getAnchor();
        Assert.assertEquals((Object)24, anchor.getKey());
        Assert.assertEquals((Object)24, anchor.getValue());
        predicate.setPage(9);
        values = map.values((Predicate)predicate);
        Assert.assertEquals((long)5L, (long)values.size());
        i = 45;
        for (Integer value : values) {
            Assert.assertEquals((long)i, (long)value.intValue());
            ++i;
        }
        anchor = predicate.getAnchor();
        Assert.assertEquals((Object)49, anchor.getKey());
        Assert.assertEquals((Object)49, anchor.getValue());
    }

    @Test
    public void testMapPagingKeySet() {
        Config config = this.getConfig();
        this.hazelcastFactory.newHazelcastInstance(config);
        this.hazelcastFactory.newHazelcastInstance(config);
        ClientConfig clientConfig = new ClientConfig();
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient(clientConfig);
        IMap map = client.getMap("map");
        int size = 50;
        int pageSize = 5;
        for (int i = 0; i < 50; ++i) {
            map.put((Object)(50 - i), (Object)i);
        }
        PagingPredicate predicate = new PagingPredicate(5);
        predicate.nextPage();
        Set values = map.keySet((Predicate)predicate);
        Assert.assertEquals((long)5L, (long)values.size());
    }

    @Test
    public void testNoOperationTimeoutException_whenUserCodeLongRunning() {
        Config config = this.getConfig();
        config.setProperty(GroupProperty.OPERATION_CALL_TIMEOUT_MILLIS.getName(), "2000");
        this.hazelcastFactory.newHazelcastInstance(config);
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient();
        IMap map = client.getMap(ClientMapIssueTest.randomMapName());
        SleepyProcessor sleepyProcessor = new SleepyProcessor(TimeUnit.SECONDS.toMillis(10L));
        String key = ClientMapIssueTest.randomString();
        String value = ClientMapIssueTest.randomString();
        map.put((Object)key, (Object)value);
        Assert.assertEquals((Object)value, (Object)map.executeOnKey((Object)key, (EntryProcessor)sleepyProcessor));
    }

    static class SleepyProcessor
    implements EntryProcessor,
    Serializable {
        private long millis;

        SleepyProcessor(long millis) {
            this.millis = millis;
        }

        public Object process(Map.Entry entry) {
            try {
                Thread.sleep(this.millis);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            return entry.getValue();
        }

        public EntryBackupProcessor getBackupProcessor() {
            return null;
        }
    }
}

