/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.map;

import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.map.EntryBackupProcessor;
import com.hazelcast.map.EntryProcessor;
import com.hazelcast.test.AssertTask;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientMapLockTest {
    private final TestHazelcastFactory hazelcastFactory = new TestHazelcastFactory();
    private HazelcastInstance client;

    @Before
    public void setup() {
        this.hazelcastFactory.newHazelcastInstance();
        this.client = this.hazelcastFactory.newHazelcastClient();
    }

    @After
    public void tearDown() {
        this.hazelcastFactory.terminateAll();
    }

    @Test(expected=NullPointerException.class)
    public void testisLocked_whenKeyNull_fromSameThread() {
        IMap map = this.client.getMap(HazelcastTestSupport.randomString());
        map.isLocked(null);
    }

    @Test
    public void testisLocked_whenKeyAbsent_fromSameThread() {
        IMap map = this.client.getMap(HazelcastTestSupport.randomString());
        boolean isLocked = map.isLocked((Object)"NOT_THERE");
        Assert.assertFalse((boolean)isLocked);
    }

    @Test
    public void testisLocked_whenKeyPresent_fromSameThread() {
        IMap map = this.client.getMap(HazelcastTestSupport.randomString());
        String key = "key";
        map.put((Object)key, (Object)"value");
        boolean isLocked = map.isLocked((Object)key);
        Assert.assertFalse((boolean)isLocked);
    }

    @Test(expected=NullPointerException.class)
    public void testLock_whenKeyNull_fromSameThread() {
        IMap map = this.client.getMap(HazelcastTestSupport.randomString());
        map.lock(null);
    }

    @Test
    public void testLock_whenKeyAbsent_fromSameThread() {
        IMap map = this.client.getMap(HazelcastTestSupport.randomString());
        String key = "key";
        map.lock((Object)key);
        Assert.assertTrue((boolean)map.isLocked((Object)key));
    }

    @Test
    public void testLock_whenKeyPresent_fromSameThread() {
        IMap map = this.client.getMap(HazelcastTestSupport.randomString());
        String key = "key";
        map.put((Object)key, (Object)"value");
        map.lock((Object)key);
        Assert.assertTrue((boolean)map.isLocked((Object)key));
    }

    @Test
    public void testLock_whenLockedRepeatedly_fromSameThread() {
        IMap map = this.client.getMap(HazelcastTestSupport.randomString());
        String key = "key";
        map.lock((Object)key);
        map.lock((Object)key);
        Assert.assertTrue((boolean)map.isLocked((Object)key));
    }

    @Test(expected=NullPointerException.class)
    public void testUnLock_whenKeyNull_fromSameThread() {
        IMap map = this.client.getMap(HazelcastTestSupport.randomString());
        map.unlock(null);
    }

    @Test(expected=IllegalMonitorStateException.class)
    public void testUnLock_whenKeyNotPresentAndNotLocked_fromSameThread() {
        IMap map = this.client.getMap(HazelcastTestSupport.randomString());
        map.unlock((Object)"NOT_THERE_OR_LOCKED");
    }

    @Test(expected=IllegalMonitorStateException.class)
    public void testUnLock_whenKeyPresentAndNotLocked_fromSameThread() {
        IMap map = this.client.getMap(HazelcastTestSupport.randomString());
        String key = "key";
        map.put((Object)"key", (Object)"value");
        map.unlock((Object)"key");
    }

    @Test
    public void testUnLock_fromSameThread() {
        IMap map = this.client.getMap(HazelcastTestSupport.randomString());
        String key = "key";
        map.lock((Object)"key");
        map.unlock((Object)"key");
        Assert.assertFalse((boolean)map.isLocked((Object)"key"));
    }

    @Test
    public void testUnLock_whenKeyLockedRepeatedly_fromSameThread() {
        IMap map = this.client.getMap(HazelcastTestSupport.randomString());
        String key = "key";
        map.lock((Object)"key");
        map.lock((Object)"key");
        map.unlock((Object)"key");
        Assert.assertTrue((boolean)map.isLocked((Object)"key"));
    }

    @Test(expected=NullPointerException.class)
    public void testForceUnlock_whenKeyNull_fromSameThread() {
        IMap map = this.client.getMap(HazelcastTestSupport.randomString());
        map.forceUnlock(null);
    }

    @Test
    public void testForceUnlock_whenKeyNotPresentAndNotLocked_fromSameThread() {
        IMap map = this.client.getMap(HazelcastTestSupport.randomString());
        map.forceUnlock((Object)"NOT_THERE_OR_LOCKED");
    }

    @Test
    public void testForceUnlock_whenKeyPresentAndNotLocked_fromSameThread() {
        IMap map = this.client.getMap(HazelcastTestSupport.randomString());
        String key = "key";
        map.put((Object)"key", (Object)"value");
        map.forceUnlock((Object)"key");
    }

    @Test
    public void testForceUnlock_fromSameThread() {
        IMap map = this.client.getMap(HazelcastTestSupport.randomString());
        String key = "key";
        map.lock((Object)"key");
        map.forceUnlock((Object)"key");
        Assert.assertFalse((boolean)map.isLocked((Object)"key"));
    }

    @Test
    public void testForceUnLock_whenKeyLockedRepeatedly_fromSameThread() {
        IMap map = this.client.getMap(HazelcastTestSupport.randomString());
        String key = "key";
        map.lock((Object)"key");
        map.lock((Object)"key");
        map.unlock((Object)"key");
        Assert.assertTrue((boolean)map.isLocked((Object)"key"));
    }

    @Test
    public void testLockAbsentKey_thenPutKey_fromSameThread() {
        IMap map = this.client.getMap(HazelcastTestSupport.randomString());
        String key = "key";
        String value = "value";
        map.lock((Object)"key");
        map.put((Object)"key", (Object)"value");
        map.unlock((Object)"key");
        Assert.assertEquals((Object)"value", (Object)map.get((Object)"key"));
    }

    @Test
    public void testLockAbsentKey_thenPutKeyIfAbsent_fromSameThread() {
        IMap map = this.client.getMap(HazelcastTestSupport.randomString());
        String key = "key";
        String value = "value";
        map.lock((Object)"key");
        map.putIfAbsent((Object)"key", (Object)"value");
        map.unlock((Object)"key");
        Assert.assertEquals((Object)"value", (Object)map.get((Object)"key"));
    }

    @Test
    public void testLockPresentKey_thenPutKey_fromSameThread() {
        IMap map = this.client.getMap(HazelcastTestSupport.randomString());
        String key = "key";
        String oldValue = "oldValue";
        String newValue = "newValue";
        map.put((Object)"key", (Object)"oldValue");
        map.lock((Object)"key");
        map.put((Object)"key", (Object)"newValue");
        map.unlock((Object)"key");
        Assert.assertEquals((Object)"newValue", (Object)map.get((Object)"key"));
    }

    @Test
    public void testLockPresentKey_thenSetKey_fromSameThread() {
        IMap map = this.client.getMap(HazelcastTestSupport.randomString());
        String key = "key";
        String oldValue = "oldValue";
        String newValue = "newValue";
        map.put((Object)"key", (Object)"oldValue");
        map.lock((Object)"key");
        map.set((Object)"key", (Object)"newValue");
        map.unlock((Object)"key");
        Assert.assertEquals((Object)"newValue", (Object)map.get((Object)"key"));
    }

    @Test
    public void testLockPresentKey_thenReplace_fromSameThread() {
        IMap map = this.client.getMap(HazelcastTestSupport.randomString());
        String key = "key";
        String oldValue = "oldValue";
        String newValue = "newValue";
        map.put((Object)"key", (Object)"oldValue");
        map.lock((Object)"key");
        map.replace((Object)"key", (Object)"newValue");
        map.unlock((Object)"key");
        Assert.assertEquals((Object)"newValue", (Object)map.get((Object)"key"));
    }

    @Test
    public void testLockPresentKey_thenRemoveKey_fromSameThread() {
        IMap map = this.client.getMap(HazelcastTestSupport.randomString());
        String key = "key";
        String oldValue = "oldValue";
        map.put((Object)"key", (Object)"oldValue");
        map.lock((Object)"key");
        map.remove((Object)"key");
        map.unlock((Object)"key");
        Assert.assertFalse((boolean)map.isLocked((Object)"key"));
        Assert.assertEquals(null, (Object)map.get((Object)"key"));
    }

    @Test
    public void testLockPresentKey_thenDeleteKey_fromSameThread() {
        IMap map = this.client.getMap(HazelcastTestSupport.randomString());
        String key = "key";
        String oldValue = "oldValue";
        map.put((Object)"key", (Object)"oldValue");
        map.lock((Object)"key");
        map.delete((Object)"key");
        map.unlock((Object)"key");
        Assert.assertFalse((boolean)map.isLocked((Object)"key"));
        Assert.assertEquals(null, (Object)map.get((Object)"key"));
    }

    @Test
    public void testLockPresentKey_thenEvictKey_fromSameThread() {
        IMap map = this.client.getMap(HazelcastTestSupport.randomString());
        String key = "key";
        String oldValue = "oldValue";
        map.put((Object)"key", (Object)"oldValue");
        map.lock((Object)"key");
        map.evict((Object)"key");
        map.unlock((Object)"key");
        Assert.assertFalse((boolean)map.isLocked((Object)"key"));
        Assert.assertEquals(null, (Object)map.get((Object)"key"));
    }

    @Test
    public void testLockKey_thenPutAndCheckKeySet_fromOtherThread() throws InterruptedException {
        final IMap map = this.client.getMap(HazelcastTestSupport.randomString());
        String key = "key";
        String value = "oldValue";
        final CountDownLatch putWhileLocked = new CountDownLatch(1);
        final CountDownLatch checkingKeySet = new CountDownLatch(1);
        new Thread(){

            @Override
            public void run() {
                try {
                    map.lock((Object)"key");
                    map.put((Object)"key", (Object)"oldValue");
                    putWhileLocked.countDown();
                    checkingKeySet.await();
                    map.unlock((Object)"key");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }.start();
        putWhileLocked.await();
        Set keySet = map.keySet();
        Assert.assertFalse((boolean)keySet.isEmpty());
        checkingKeySet.countDown();
    }

    @Test
    public void testLockKey_thenPutAndGet_fromOtherThread() throws InterruptedException {
        final IMap map = this.client.getMap(HazelcastTestSupport.randomString());
        String key = "key";
        String value = "oldValue";
        final CountDownLatch putWhileLocked = new CountDownLatch(1);
        final CountDownLatch checkingKeySet = new CountDownLatch(1);
        new Thread(){

            @Override
            public void run() {
                try {
                    map.lock((Object)"key");
                    map.put((Object)"key", (Object)"oldValue");
                    putWhileLocked.countDown();
                    checkingKeySet.await();
                    map.unlock((Object)"key");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }.start();
        putWhileLocked.await();
        Assert.assertEquals((Object)"oldValue", (Object)map.get((Object)"key"));
        checkingKeySet.countDown();
    }

    @Test
    public void testLockKey_thenRemoveAndGet_fromOtherThread() throws InterruptedException {
        final IMap map = this.client.getMap(HazelcastTestSupport.randomString());
        String key = "key";
        String value = "oldValue";
        final CountDownLatch removeWhileLocked = new CountDownLatch(1);
        final CountDownLatch checkingKey = new CountDownLatch(1);
        map.put((Object)"key", (Object)"oldValue");
        new Thread(){

            @Override
            public void run() {
                try {
                    map.lock((Object)"key");
                    map.remove((Object)"key");
                    removeWhileLocked.countDown();
                    checkingKey.await();
                    map.unlock((Object)"key");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }.start();
        removeWhileLocked.await();
        Assert.assertEquals(null, (Object)map.get((Object)"key"));
        checkingKey.countDown();
    }

    @Test
    public void testLockKey_thenTryPutOnKey() throws Exception {
        final IMap map = this.client.getMap(HazelcastTestSupport.randomString());
        String key = "key";
        String value = "value";
        map.put((Object)"key", (Object)"value");
        map.lock((Object)"key");
        final CountDownLatch tryPutReturned = new CountDownLatch(1);
        new Thread(){

            @Override
            public void run() {
                map.tryPut((Object)"key", (Object)"NEW_VALUE", 1L, TimeUnit.SECONDS);
                tryPutReturned.countDown();
            }
        }.start();
        HazelcastTestSupport.assertOpenEventually((CountDownLatch)tryPutReturned);
        Assert.assertEquals((Object)"value", (Object)map.get((Object)"key"));
    }

    @Test
    public void testLockTTLExpires_usingIsLocked() throws Exception {
        final IMap map = this.client.getMap(HazelcastTestSupport.randomString());
        String key = "key";
        map.lock((Object)"key", 2L, TimeUnit.SECONDS);
        HazelcastTestSupport.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() throws Exception {
                Assert.assertFalse((boolean)map.isLocked((Object)"key"));
            }
        }, (long)10L);
    }

    @Test
    public void testLockTTLExpires() throws Exception {
        final IMap map = this.client.getMap(HazelcastTestSupport.randomString());
        String key = "key";
        String oldValue = "value";
        String newValue = "NEW_VALUE";
        map.put((Object)"key", (Object)"value");
        map.lock((Object)"key", 1L, TimeUnit.SECONDS);
        final CountDownLatch tryPutReturned = new CountDownLatch(1);
        new Thread(){

            @Override
            public void run() {
                map.tryPut((Object)"key", (Object)"NEW_VALUE", 60L, TimeUnit.SECONDS);
                tryPutReturned.countDown();
            }
        }.start();
        HazelcastTestSupport.assertOpenEventually((CountDownLatch)tryPutReturned);
        Assert.assertEquals((Object)"NEW_VALUE", (Object)map.get((Object)"key"));
    }

    @Test
    public void testLockTTLExpires_onAbsentKey() throws Exception {
        final IMap map = this.client.getMap(HazelcastTestSupport.randomString());
        String key = "key";
        String value = "value";
        map.lock((Object)"key", 1L, TimeUnit.SECONDS);
        final CountDownLatch tryPutReturned = new CountDownLatch(1);
        new Thread(){

            @Override
            public void run() {
                map.tryPut((Object)"key", (Object)"value", 60L, TimeUnit.SECONDS);
                tryPutReturned.countDown();
            }
        }.start();
        HazelcastTestSupport.assertOpenEventually((CountDownLatch)tryPutReturned);
        Assert.assertEquals((Object)"value", (Object)map.get((Object)"key"));
    }

    @Test
    public void testisLocked_whenLockedFromOtherThread() throws Exception {
        final IMap map = this.client.getMap(HazelcastTestSupport.randomString());
        String key = "key";
        final CountDownLatch lockedLatch = new CountDownLatch(1);
        new Thread(){

            @Override
            public void run() {
                map.lock((Object)"key");
                lockedLatch.countDown();
            }
        }.start();
        HazelcastTestSupport.assertOpenEventually((CountDownLatch)lockedLatch);
        Assert.assertTrue((boolean)map.isLocked((Object)"key"));
    }

    @Test(expected=IllegalMonitorStateException.class)
    public void testUnLocked_whenLockedFromOtherThread() throws Exception {
        final IMap map = this.client.getMap(HazelcastTestSupport.randomString());
        String key = "key";
        final CountDownLatch lockedLatch = new CountDownLatch(1);
        new Thread(){

            @Override
            public void run() {
                map.lock((Object)"key");
                lockedLatch.countDown();
            }
        }.start();
        HazelcastTestSupport.assertOpenEventually((CountDownLatch)lockedLatch);
        map.unlock((Object)"key");
    }

    @Test
    public void testForceUnLocked_whenLockedFromOtherThread() throws Exception {
        final IMap map = this.client.getMap(HazelcastTestSupport.randomString());
        String key = "key";
        final CountDownLatch lockedLatch = new CountDownLatch(1);
        new Thread(){

            @Override
            public void run() {
                map.lock((Object)"key");
                map.lock((Object)"key");
                lockedLatch.countDown();
            }
        }.start();
        lockedLatch.await(10L, TimeUnit.SECONDS);
        map.forceUnlock((Object)"key");
        Assert.assertFalse((boolean)map.isLocked((Object)"key"));
    }

    @Test
    public void testTryPut_whenLockedFromOtherThread() throws Exception {
        final IMap map = this.client.getMap(HazelcastTestSupport.randomString());
        String key = "key";
        final CountDownLatch lockedLatch = new CountDownLatch(1);
        new Thread(){

            @Override
            public void run() {
                map.lock((Object)"key");
                lockedLatch.countDown();
            }
        }.start();
        HazelcastTestSupport.assertOpenEventually((CountDownLatch)lockedLatch);
        Assert.assertFalse((boolean)map.tryPut((Object)"key", (Object)"value", 1L, TimeUnit.SECONDS));
    }

    @Test
    public void testTryRemove_whenLockedFromOtherThread() throws Exception {
        final IMap map = this.client.getMap(HazelcastTestSupport.randomString());
        String key = "key";
        final CountDownLatch lockedLatch = new CountDownLatch(1);
        new Thread(){

            @Override
            public void run() {
                map.lock((Object)"key");
                lockedLatch.countDown();
            }
        }.start();
        HazelcastTestSupport.assertOpenEventually((CountDownLatch)lockedLatch);
        Assert.assertFalse((boolean)map.tryRemove((Object)"key", 1L, TimeUnit.SECONDS));
    }

    @Test
    public void testTryLock_whenLockedFromOtherThread() throws Exception {
        final IMap map = this.client.getMap(HazelcastTestSupport.randomString());
        String key = "key";
        final CountDownLatch lockedLatch = new CountDownLatch(1);
        new Thread(){

            @Override
            public void run() {
                map.lock((Object)"key");
                lockedLatch.countDown();
            }
        }.start();
        HazelcastTestSupport.assertOpenEventually((CountDownLatch)lockedLatch);
        Assert.assertFalse((boolean)map.tryLock((Object)"key"));
    }

    @Test
    public void testLock_whenUnLockedFromOtherThread() throws Exception {
        final IMap map = this.client.getMap(HazelcastTestSupport.randomString());
        String key = "key";
        map.lock((Object)"key");
        final CountDownLatch beforeLock = new CountDownLatch(1);
        final CountDownLatch afterLock = new CountDownLatch(1);
        new Thread(){

            @Override
            public void run() {
                beforeLock.countDown();
                map.lock((Object)"key");
                afterLock.countDown();
            }
        }.start();
        beforeLock.await();
        map.unlock((Object)"key");
        HazelcastTestSupport.assertOpenEventually((CountDownLatch)afterLock);
    }

    @Test(timeout=60000L)
    public void testTryLockLeaseTime_whenLockFree() throws InterruptedException {
        IMap map = this.getMapForLock();
        String key = HazelcastTestSupport.randomString();
        boolean isLocked = map.tryLock((Object)key, 1000L, TimeUnit.MILLISECONDS, 1000L, TimeUnit.MILLISECONDS);
        Assert.assertTrue((boolean)isLocked);
    }

    @Test(timeout=60000L)
    public void testTryLockLeaseTime_whenLockAcquiredByOther() throws InterruptedException {
        final IMap map = this.getMapForLock();
        final String key = HazelcastTestSupport.randomString();
        Thread thread = new Thread(){

            @Override
            public void run() {
                map.lock((Object)key);
            }
        };
        thread.start();
        thread.join();
        boolean isLocked = map.tryLock((Object)key, 1000L, TimeUnit.MILLISECONDS, 1000L, TimeUnit.MILLISECONDS);
        Assert.assertFalse((boolean)isLocked);
    }

    @Test
    public void testTryLockLeaseTime_lockIsReleasedEventually() throws InterruptedException {
        final IMap map = this.getMapForLock();
        final String key = HazelcastTestSupport.randomString();
        map.tryLock((Object)key, 1000L, TimeUnit.MILLISECONDS, 1000L, TimeUnit.MILLISECONDS);
        HazelcastTestSupport.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() throws Exception {
                Assert.assertFalse((boolean)map.isLocked((Object)key));
            }
        }, (long)30L);
    }

    @Test
    public void testExecuteOnKeyWhenLock() throws InterruptedException {
        final IMap map = this.getMapForLock();
        final String key = HazelcastTestSupport.randomString();
        map.lock((Object)key);
        HazelcastTestSupport.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() throws Exception {
                String payload = HazelcastTestSupport.randomString();
                Object ret = map.executeOnKey((Object)key, (EntryProcessor)new LockEntryProcessor(payload));
                Assert.assertEquals((Object)payload, (Object)ret);
            }
        }, (long)30L);
        map.unlock((Object)key);
    }

    private IMap getMapForLock() {
        return this.client.getMap(HazelcastTestSupport.randomString());
    }

    private static class LockEntryProcessor
    implements EntryProcessor<Object, Object>,
    Serializable {
        public final String payload;

        public LockEntryProcessor(String payload) {
            this.payload = payload;
        }

        public Object process(Map.Entry entry) {
            return this.payload;
        }

        public EntryBackupProcessor getBackupProcessor() {
            return null;
        }
    }
}

