/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.map;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.impl.ClientTestUtil;
import com.hazelcast.client.impl.HazelcastClientInstanceImpl;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.Config;
import com.hazelcast.core.DistributedObject;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.map.MapPartitionLostEvent;
import com.hazelcast.map.TestEventCollectingMapPartitionLostListener;
import com.hazelcast.map.impl.MapPartitionLostEventFilter;
import com.hazelcast.map.impl.MapService;
import com.hazelcast.map.listener.MapPartitionLostListener;
import com.hazelcast.nio.Address;
import com.hazelcast.spi.EventRegistration;
import com.hazelcast.spi.impl.eventservice.InternalEventService;
import com.hazelcast.spi.impl.proxyservice.InternalProxyService;
import com.hazelcast.spi.partition.IPartitionLostEvent;
import com.hazelcast.test.AssertTask;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.Collection;
import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.mockito.Mockito;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientMapPartitionLostListenerTest {
    private final TestHazelcastFactory hazelcastFactory = new TestHazelcastFactory();

    @After
    public void tearDown() {
        this.hazelcastFactory.terminateAll();
    }

    @Test
    public void test_mapPartitionLostListener_registered() {
        HazelcastInstance instance = this.hazelcastFactory.newHazelcastInstance();
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient();
        String mapName = HazelcastTestSupport.randomMapName();
        client.getMap(mapName).addPartitionLostListener((MapPartitionLostListener)Mockito.mock(MapPartitionLostListener.class));
        this.assertRegistrationEventually(instance, mapName, true);
    }

    @Test
    public void test_mapPartitionLostListener_removed() {
        HazelcastInstance instance = this.hazelcastFactory.newHazelcastInstance();
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient();
        String mapName = HazelcastTestSupport.randomMapName();
        String registrationId = client.getMap(mapName).addPartitionLostListener((MapPartitionLostListener)Mockito.mock(MapPartitionLostListener.class));
        this.assertRegistrationEventually(instance, mapName, true);
        Assert.assertTrue((boolean)client.getMap(mapName).removePartitionLostListener(registrationId));
        this.assertRegistrationEventually(instance, mapName, false);
    }

    @Test
    public void test_mapPartitionLostListener_invoked() {
        String mapName = HazelcastTestSupport.randomMapName();
        Config config = new Config();
        config.getMapConfig(mapName).setBackupCount(0);
        HazelcastInstance instance = this.hazelcastFactory.newHazelcastInstance(config);
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient();
        HazelcastTestSupport.warmUpPartitions((HazelcastInstance[])new HazelcastInstance[]{instance, client});
        TestEventCollectingMapPartitionLostListener listener = new TestEventCollectingMapPartitionLostListener(0);
        client.getMap(mapName).addPartitionLostListener((MapPartitionLostListener)listener);
        MapService mapService = (MapService)HazelcastTestSupport.getNode((HazelcastInstance)instance).getNodeEngine().getService("hz:impl:mapService");
        int partitionId = 5;
        mapService.onPartitionLost(new IPartitionLostEvent(5, 0, null));
        this.assertMapPartitionLostEventEventually(listener, 5);
    }

    private void assertMapPartitionLostEventEventually(final TestEventCollectingMapPartitionLostListener listener, final int partitionId) {
        HazelcastTestSupport.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() throws Exception {
                List events = listener.getEvents();
                Assert.assertFalse((boolean)events.isEmpty());
                Assert.assertEquals((long)partitionId, (long)((MapPartitionLostEvent)events.get(0)).getPartitionId());
            }
        });
    }

    @Test
    public void test_mapPartitionLostListener_invoked_fromOtherNode() {
        String mapName = HazelcastTestSupport.randomMapName();
        Config config = new Config();
        config.getMapConfig(mapName).setBackupCount(0);
        HazelcastInstance instance1 = this.hazelcastFactory.newHazelcastInstance(config);
        HazelcastInstance instance2 = this.hazelcastFactory.newHazelcastInstance(config);
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.getNetworkConfig().setSmartRouting(false);
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient(clientConfig);
        HazelcastClientInstanceImpl clientInstanceImpl = ClientTestUtil.getHazelcastClientInstanceImpl(client);
        Address clientOwnerAddress = clientInstanceImpl.getClientClusterService().getOwnerConnectionAddress();
        HazelcastInstance other = HazelcastTestSupport.getAddress((HazelcastInstance)instance1).equals((Object)clientOwnerAddress) ? instance2 : instance1;
        TestEventCollectingMapPartitionLostListener listener = new TestEventCollectingMapPartitionLostListener(0);
        client.getMap(mapName).addPartitionLostListener((MapPartitionLostListener)listener);
        this.assertRegistrationEventually(instance1, mapName, true);
        this.assertRegistrationEventually(instance2, mapName, true);
        this.assertProxyExistsEventually(instance1, mapName);
        this.assertProxyExistsEventually(instance2, mapName);
        MapService mapService = (MapService)HazelcastTestSupport.getNode((HazelcastInstance)other).getNodeEngine().getService("hz:impl:mapService");
        int partitionId = 5;
        mapService.onPartitionLost(new IPartitionLostEvent(5, 0, null));
        this.assertMapPartitionLostEventEventually(listener, 5);
    }

    private void assertProxyExistsEventually(HazelcastInstance instance, final String proxyName) {
        final InternalProxyService proxyService = HazelcastTestSupport.getNodeEngineImpl((HazelcastInstance)instance).getProxyService();
        HazelcastTestSupport.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() throws Exception {
                Collection allDistributedObjects = proxyService.getAllDistributedObjects();
                for (DistributedObject distributedObject : allDistributedObjects) {
                    if (!distributedObject.getName().equals(proxyName)) continue;
                    return;
                }
                Assert.fail((String)("There is no proxy with name " + proxyName + " created (yet)"));
            }
        });
    }

    private void assertRegistrationEventually(final HazelcastInstance instance, final String mapName, final boolean shouldBeRegistered) {
        HazelcastTestSupport.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() throws Exception {
                InternalEventService eventService = HazelcastTestSupport.getNode((HazelcastInstance)instance).getNodeEngine().getEventService();
                boolean registered = false;
                for (EventRegistration registration : eventService.getRegistrations("hz:impl:mapService", mapName)) {
                    if (!(registration.getFilter() instanceof MapPartitionLostEventFilter)) continue;
                    registered = true;
                    break;
                }
                if (shouldBeRegistered != registered) {
                    Assert.fail((String)("shouldBeRegistered: " + shouldBeRegistered + " registered: " + registered));
                }
            }
        });
    }
}

