/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.map;

import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.Config;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.map.MapLiteMemberTest;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientMapQueryLiteMemberTest {
    private TestHazelcastFactory factory;
    private IMap<Integer, Object> map;

    @Before
    public void setUp() {
        this.factory = new TestHazelcastFactory();
        this.factory.newHazelcastInstance();
        this.factory.newHazelcastInstance(new Config().setLiteMember(true));
        HazelcastInstance client = this.factory.newHazelcastClient();
        this.map = client.getMap(HazelcastTestSupport.randomMapName());
    }

    @After
    public void tearDown() {
        this.factory.terminateAll();
    }

    @Test
    public void testMapValuesQuery() {
        MapLiteMemberTest.testMapValuesQuery(this.map);
    }

    @Test
    public void testMapKeysQuery() {
        MapLiteMemberTest.testMapKeysQuery(this.map);
    }
}

