/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.map;

import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientMapTryLockConcurrentTests {
    private final TestHazelcastFactory hazelcastFactory = new TestHazelcastFactory();
    private HazelcastInstance client;

    @After
    public void tearDown() {
        this.hazelcastFactory.terminateAll();
    }

    @Before
    public void setup() {
        this.hazelcastFactory.newHazelcastInstance();
        this.client = this.hazelcastFactory.newHazelcastClient();
    }

    @Test
    public void concurrent_MapTryLockTest() throws InterruptedException {
        this.concurrent_MapTryLock(false);
    }

    @Test
    public void concurrent_MapTryLockTimeOutTest() throws InterruptedException {
        this.concurrent_MapTryLock(true);
    }

    private void concurrent_MapTryLock(boolean withTimeOut) throws InterruptedException {
        int maxThreads = 8;
        IMap map = this.client.getMap(HazelcastTestSupport.randomString());
        String upKey = "upKey";
        String downKey = "downKey";
        map.put((Object)"upKey", (Object)0);
        map.put((Object)"downKey", (Object)0);
        Thread[] threads = new Thread[8];
        for (int i = 0; i < threads.length; ++i) {
            TestHelper t = withTimeOut ? new MapTryLockTimeOutThread(map, "upKey", "downKey") : new MapTryLockThread(map, "upKey", "downKey");
            t.start();
            threads[i] = t;
        }
        HazelcastTestSupport.assertJoinable((Thread[])threads);
        int upTotal = (Integer)map.get((Object)"upKey");
        int downTotal = (Integer)map.get((Object)"downKey");
        Assert.assertTrue((String)"concurrent access to locked code caused wrong total", (upTotal + downTotal == 0 ? 1 : 0) != 0);
    }

    static abstract class TestHelper
    extends Thread {
        protected static final int ITERATIONS = 10000;
        protected final Random random = new Random();
        protected final IMap<String, Integer> map;
        protected final String upKey;
        protected final String downKey;

        public TestHelper(IMap map, String upKey, String downKey) {
            this.map = map;
            this.upKey = upKey;
            this.downKey = downKey;
        }

        @Override
        public void run() {
            try {
                for (int i = 0; i < 10000; ++i) {
                    this.doRun();
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Test Thread crashed with ", e);
            }
        }

        abstract void doRun() throws Exception;

        public void work() {
            int upTotal = (Integer)this.map.get((Object)this.upKey);
            int downTotal = (Integer)this.map.get((Object)this.downKey);
            int dif = this.random.nextInt(1000);
            this.map.put((Object)this.upKey, (Object)(upTotal += dif));
            this.map.put((Object)this.downKey, (Object)(downTotal -= dif));
        }
    }

    static class MapTryLockTimeOutThread
    extends TestHelper {
        public MapTryLockTimeOutThread(IMap map, String upKey, String downKey) {
            super(map, upKey, downKey);
        }

        @Override
        public void doRun() throws Exception {
            block7: {
                if (this.map.tryLock((Object)this.upKey, 1L, TimeUnit.MILLISECONDS)) {
                    try {
                        if (!this.map.tryLock((Object)this.downKey, 1L, TimeUnit.MILLISECONDS)) break block7;
                        try {
                            this.work();
                        }
                        finally {
                            this.map.unlock((Object)this.downKey);
                        }
                    }
                    finally {
                        this.map.unlock((Object)this.upKey);
                    }
                }
            }
        }
    }

    static class MapTryLockThread
    extends TestHelper {
        public MapTryLockThread(IMap map, String upKey, String downKey) {
            super(map, upKey, downKey);
        }

        @Override
        public void doRun() throws Exception {
            block7: {
                if (this.map.tryLock((Object)this.upKey)) {
                    try {
                        if (!this.map.tryLock((Object)this.downKey)) break block7;
                        try {
                            this.work();
                        }
                        finally {
                            this.map.unlock((Object)this.downKey);
                        }
                    }
                    finally {
                        this.map.unlock((Object)this.upKey);
                    }
                }
            }
        }
    }
}

