/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.map;

import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.Config;
import com.hazelcast.config.MapConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.core.TransactionalMap;
import com.hazelcast.map.QueryResultSizeExceededException;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.TruePredicate;
import com.hazelcast.spi.properties.GroupProperty;
import com.hazelcast.transaction.TransactionContext;
import com.hazelcast.util.EmptyStatement;
import com.hazelcast.util.ExceptionUtil;
import java.util.UUID;
import org.junit.After;
import org.junit.Assert;

public abstract class ClientMapUnboundReturnValuesTestSupport {
    protected static final int PARTITION_COUNT = 271;
    protected static final int SMALL_LIMIT = 100000;
    protected static final int PRE_CHECK_TRIGGER_LIMIT_INACTIVE = -1;
    protected static final int PRE_CHECK_TRIGGER_LIMIT_ACTIVE = Integer.MAX_VALUE;
    private final TestHazelcastFactory hazelcastFactory = new TestHazelcastFactory();
    private HazelcastInstance instance;
    private IMap<Integer, Integer> serverMap;
    private IMap<Integer, Integer> clientMap;
    private int configLimit;
    private int upperLimit;

    @After
    public void tearDown() {
        if (this.serverMap != null) {
            this.serverMap.destroy();
        }
        this.hazelcastFactory.terminateAll();
    }

    protected void runClientMapTestWithException(int partitionCount, int limit, int preCheckTrigger) {
        this.internalSetUpClient(partitionCount, 1, limit, preCheckTrigger);
        this.fillToUpperLimit(this.serverMap, this.clientMap);
        this.internalRunWithException(this.clientMap);
    }

    protected void runClientMapTestCheckUnsupported() {
        this.internalSetUpClient(271, 1, 1, -1);
        this.internalRunCheckUnsupported(this.clientMap);
    }

    protected void runClientMapTestTxn(int partitionCount, int limit, int preCheckTrigger) {
        this.internalSetUpClient(partitionCount, 1, limit, preCheckTrigger);
        this.fillToUpperLimit(this.serverMap, this.clientMap);
        this.internalRunTxn(this.clientMap.getName());
    }

    private void internalSetUpClient(int partitionCount, int clusterSize, int limit, int preCheckTrigger) {
        Config config = this.createConfig(partitionCount, limit, preCheckTrigger);
        this.serverMap = this.getMapWithNodeCount(clusterSize, config);
        this.instance = this.hazelcastFactory.newHazelcastClient();
        this.clientMap = this.instance.getMap(this.serverMap.getName());
        this.configLimit = limit;
        this.upperLimit = Math.round((float)limit * 1.5f);
    }

    private Config createConfig(int partitionCount, int limit, int preCheckTrigger) {
        Config config = new Config();
        config.setProperty(GroupProperty.PARTITION_COUNT.getName(), String.valueOf(partitionCount));
        config.setProperty(GroupProperty.QUERY_RESULT_SIZE_LIMIT.getName(), String.valueOf(limit));
        config.setProperty(GroupProperty.QUERY_MAX_LOCAL_PARTITION_LIMIT_FOR_PRE_CHECK.getName(), String.valueOf(preCheckTrigger));
        return config;
    }

    private <K, V> IMap<K, V> getMapWithNodeCount(int nodeCount, Config config) {
        String mapName = UUID.randomUUID().toString();
        MapConfig mapConfig = new MapConfig();
        mapConfig.setName(mapName);
        mapConfig.setAsyncBackupCount(0);
        mapConfig.setBackupCount(0);
        config.addMapConfig(mapConfig);
        while (nodeCount > 1) {
            this.hazelcastFactory.newHazelcastInstance(config);
            --nodeCount;
        }
        HazelcastInstance node = this.hazelcastFactory.newHazelcastInstance(config);
        return node.getMap(mapName);
    }

    private void fillToUpperLimit(IMap<Integer, Integer> fillMap, IMap<Integer, Integer> queryMap) {
        for (int index = 1; index <= this.upperLimit; ++index) {
            fillMap.put((Object)index, (Object)index);
        }
        Assert.assertEquals((String)"Expected map size of server map to match upperLimit", (long)this.upperLimit, (long)fillMap.size());
        Assert.assertEquals((String)"Expected map size of client map to match upperLimit", (long)this.upperLimit, (long)queryMap.size());
    }

    private void checkException(QueryResultSizeExceededException e) {
        String exception = ExceptionUtil.toString((Throwable)e);
        if (exception.contains("QueryPartitionOperation")) {
            Assert.fail((String)("QueryResultSizeExceededException was thrown by QueryPartitionOperation:\n" + exception));
        }
    }

    private void failExpectedException(String methodName) {
        Assert.fail((String)String.format("Expected QueryResultSizeExceededException while calling %s with limit %d and upperLimit %d", methodName, this.configLimit, this.upperLimit));
    }

    private void failUnwantedException(String methodName) {
        Assert.fail((String)String.format("Unwanted QueryResultSizeExceededException was thrown while calling %s with limit %d and upperLimit %d", methodName, this.configLimit, this.upperLimit));
    }

    private void internalRunWithException(IMap<Integer, Integer> queryMap) {
        try {
            queryMap.values((Predicate)TruePredicate.INSTANCE);
            this.failExpectedException("IMap.values(predicate)");
        }
        catch (QueryResultSizeExceededException e) {
            this.checkException(e);
        }
        try {
            queryMap.keySet((Predicate)TruePredicate.INSTANCE);
            this.failExpectedException("IMap.keySet(predicate)");
        }
        catch (QueryResultSizeExceededException e) {
            this.checkException(e);
        }
        try {
            queryMap.entrySet((Predicate)TruePredicate.INSTANCE);
            this.failExpectedException("IMap.entrySet(predicate)");
        }
        catch (QueryResultSizeExceededException e) {
            this.checkException(e);
        }
        try {
            queryMap.values();
            this.failExpectedException("IMap.values()");
        }
        catch (QueryResultSizeExceededException e) {
            this.checkException(e);
        }
        try {
            queryMap.keySet();
            this.failExpectedException("IMap.keySet()");
        }
        catch (QueryResultSizeExceededException e) {
            this.checkException(e);
        }
        try {
            queryMap.entrySet();
            this.failExpectedException("IMap.entrySet()");
        }
        catch (QueryResultSizeExceededException e) {
            this.checkException(e);
        }
    }

    private void internalRunCheckUnsupported(IMap<Integer, Integer> queryMap) {
        try {
            queryMap.localKeySet();
            this.failExpectedException("IMap.localKeySet()");
        }
        catch (UnsupportedOperationException e) {
            EmptyStatement.ignore((Throwable)e);
        }
        catch (QueryResultSizeExceededException e) {
            this.failUnwantedException("IMap.localKeySet()");
        }
        try {
            queryMap.localKeySet((Predicate)TruePredicate.INSTANCE);
            this.failExpectedException("IMap.localKeySet(predicate)");
        }
        catch (UnsupportedOperationException e) {
            EmptyStatement.ignore((Throwable)e);
        }
        catch (QueryResultSizeExceededException e) {
            this.failUnwantedException("IMap.localKeySet()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalRunTxn(String mapName) {
        TransactionContext transactionContext = this.instance.newTransactionContext();
        try {
            transactionContext.beginTransaction();
            TransactionalMap txnMap = transactionContext.getMap(mapName);
            try {
                txnMap.values((Predicate)TruePredicate.INSTANCE);
                this.failExpectedException("TransactionalMap.values(predicate)");
            }
            catch (QueryResultSizeExceededException e) {
                this.checkException(e);
            }
            try {
                txnMap.keySet((Predicate)TruePredicate.INSTANCE);
                this.failExpectedException("TransactionalMap.keySet(predicate)");
            }
            catch (QueryResultSizeExceededException e) {
                this.checkException(e);
            }
            try {
                txnMap.values();
                this.failExpectedException("TransactionalMap.values()");
            }
            catch (QueryResultSizeExceededException e) {
                this.checkException(e);
            }
            try {
                txnMap.keySet();
                this.failExpectedException("TransactionalMap.keySet()");
            }
            catch (QueryResultSizeExceededException e) {
                this.checkException(e);
            }
        }
        finally {
            transactionContext.rollbackTransaction();
        }
    }
}

