/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.map;

import com.hazelcast.client.LoadBalancer;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.client.util.StaticLB;
import com.hazelcast.config.Config;
import com.hazelcast.config.MapConfig;
import com.hazelcast.config.MapIndexConfig;
import com.hazelcast.config.XmlConfigBuilder;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.core.Member;
import com.hazelcast.query.SampleObjects;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.List;
import org.junit.After;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientMapWithIndexCreationTest
extends HazelcastTestSupport {
    private final TestHazelcastFactory factory = new TestHazelcastFactory();

    @After
    public void tearDown() {
        this.factory.shutdownAll();
    }

    @Test
    public void test_createMapWithIndexes_whenProxyCreatedOnMemberOtherThanClientOwner() {
        Config config = new XmlConfigBuilder().build();
        MapConfig mapConfig = config.getMapConfig("test");
        List mapIndexConfigs = mapConfig.getMapIndexConfigs();
        MapIndexConfig mapIndexConfig = new MapIndexConfig();
        mapIndexConfig.setAttribute("name");
        mapIndexConfig.setOrdered(true);
        mapIndexConfigs.add(mapIndexConfig);
        HazelcastInstance hz1 = this.factory.newHazelcastInstance(config);
        HazelcastInstance hz2 = this.factory.newHazelcastInstance(config);
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.setLoadBalancer((LoadBalancer)new StaticLB((Member)hz1.getLocalEndpoint()));
        clientConfig.getNetworkConfig().setSmartRouting(false);
        clientConfig.getNetworkConfig().addAddress(new String[]{hz2.getCluster().getLocalMember().getAddress().getHost() + ":" + hz2.getCluster().getLocalMember().getAddress().getPort()});
        HazelcastInstance client = this.factory.newHazelcastClient(clientConfig);
        IMap test = client.getMap("test");
        test.put((Object)"foo", (Object)new SampleObjects.Employee(1L, "name", "age", 32, true, 230.0));
    }
}

