/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.map;

import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.Config;
import com.hazelcast.config.MapConfig;
import com.hazelcast.config.MapStoreConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.core.MapStore;
import com.hazelcast.map.impl.mapstore.writebehind.MapStoreWithCounter;
import com.hazelcast.map.impl.mapstore.writebehind.TemporaryBlockerMapStore;
import com.hazelcast.map.impl.mapstore.writebehind.WriteBehindOnBackupsTest;
import com.hazelcast.test.AssertTask;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.Arrays;
import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientWriteBehindFlushTest
extends HazelcastTestSupport {
    private static final String MAP_NAME = "default";
    private HazelcastInstance client;
    private HazelcastInstance member1;
    private HazelcastInstance member2;
    private HazelcastInstance member3;

    @Before
    public void setUp() throws Exception {
        MapStoreConfig mapStoreConfig = new MapStoreConfig();
        MapStoreWithCounter mapStore = new MapStoreWithCounter();
        mapStoreConfig.setImplementation((Object)mapStore).setWriteDelaySeconds(3000);
        Config config = this.getConfig();
        config.getMapConfig(MAP_NAME).setMapStoreConfig(mapStoreConfig);
        TestHazelcastFactory hazelcastFactory = new TestHazelcastFactory();
        this.member1 = hazelcastFactory.newHazelcastInstance(config);
        this.member2 = hazelcastFactory.newHazelcastInstance(config);
        this.member3 = hazelcastFactory.newHazelcastInstance(config);
        this.client = hazelcastFactory.newHazelcastClient();
    }

    @After
    public void tearDown() throws Exception {
        this.client.shutdown();
        this.member1.shutdown();
        this.member2.shutdown();
        this.member3.shutdown();
    }

    @Test
    @Ignore
    public void testWriteBehindQueues_emptied_onOwnerAndBackupNodes() throws Exception {
        IMap map = this.client.getMap(MAP_NAME);
        for (int i = 0; i < 1000; ++i) {
            map.put((Object)i, (Object)i);
        }
        map.flush();
        this.assertWriteBehindQueuesEmpty(MAP_NAME, Arrays.asList(this.member1, this.member2, this.member3));
    }

    @Test
    public void testFlush_shouldNotCause_concurrentStoreOperation() throws Exception {
        int blockStoreOperationSeconds = 5;
        TemporaryBlockerMapStore store = new TemporaryBlockerMapStore(blockStoreOperationSeconds);
        Config config = this.newMapStoredConfig((MapStore)store, 2);
        TestHazelcastFactory hazelcastFactory = new TestHazelcastFactory();
        hazelcastFactory.newHazelcastInstance(config);
        IMap map = hazelcastFactory.newHazelcastClient().getMap(MAP_NAME);
        map.put((Object)"key", (Object)"value");
        map.flush();
        Assert.assertEquals((String)"Expecting only one store after flush", (long)1L, (long)store.getStoreOperationCount());
        hazelcastFactory.shutdownAll();
    }

    protected Config newMapStoredConfig(MapStore store, int writeDelaySeconds) {
        MapStoreConfig mapStoreConfig = new MapStoreConfig();
        mapStoreConfig.setEnabled(true);
        mapStoreConfig.setWriteDelaySeconds(writeDelaySeconds);
        mapStoreConfig.setImplementation((Object)store);
        Config config = this.getConfig();
        MapConfig mapConfig = config.getMapConfig(MAP_NAME);
        mapConfig.setMapStoreConfig(mapStoreConfig);
        return config;
    }

    protected void assertWriteBehindQueuesEmpty(final String mapName, final List<HazelcastInstance> nodes) {
        ClientWriteBehindFlushTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() throws Exception {
                for (HazelcastInstance instance : nodes) {
                    Assert.assertEquals((long)0L, (long)WriteBehindOnBackupsTest.writeBehindQueueSize((HazelcastInstance)instance, (String)mapName));
                }
            }
        });
    }
}

