/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.map;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.ClientNetworkConfig;
import com.hazelcast.client.map.AbstractMapPartitionIteratorTest;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.Config;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.nio.Address;
import com.hazelcast.test.HazelcastParametersRunnerFactory;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import org.junit.Before;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Parameterized.UseParametersRunnerFactory(value=HazelcastParametersRunnerFactory.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class DummyClientMapPartitionIteratorTest
extends AbstractMapPartitionIteratorTest {
    @Before
    public void setup() {
        this.factory = new TestHazelcastFactory();
        Config config = this.getConfig();
        this.server = this.factory.newHazelcastInstance(config);
        this.factory.newHazelcastInstance(config);
        this.client = this.factory.newHazelcastClient(DummyClientMapPartitionIteratorTest.getClientConfig(this.server));
    }

    private static ClientConfig getClientConfig(HazelcastInstance instance) {
        Address address = instance.getCluster().getLocalMember().getAddress();
        String addressString = address.getHost() + ":" + address.getPort();
        ClientConfig clientConfig = new ClientConfig();
        ClientNetworkConfig networkConfig = new ClientNetworkConfig();
        networkConfig.setSmartRouting(false);
        networkConfig.addAddress(new String[]{addressString});
        clientConfig.setNetworkConfig(networkConfig);
        return clientConfig;
    }
}

