/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.map;

import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.Config;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.NightlyTest;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={NightlyTest.class})
public class MapMemoryUsageStressTest
extends HazelcastTestSupport {
    private final TestHazelcastFactory hazelcastFactory = new TestHazelcastFactory();
    private final ILogger logger = Logger.getLogger(MapMemoryUsageStressTest.class);
    private HazelcastInstance client;

    @Before
    public void launchHazelcastServer() {
        Config config = this.getConfig();
        this.hazelcastFactory.newHazelcastInstance(config);
        this.client = this.hazelcastFactory.newHazelcastClient();
    }

    @After
    public void shutdownHazelcastServer() {
        this.hazelcastFactory.terminateAll();
    }

    @Test(timeout=1800000L)
    public void voidCacher() throws Exception {
        AtomicInteger counter = new AtomicInteger(200000);
        AtomicInteger errors = new AtomicInteger();
        Thread[] threads = new Thread[8];
        for (int k = 0; k < threads.length; ++k) {
            StressThread stressThread = new StressThread(counter, errors);
            threads[k] = stressThread;
            stressThread.start();
        }
        MapMemoryUsageStressTest.assertJoinable((long)TimeUnit.MINUTES.toSeconds(30L), (Thread[])threads);
        Assert.assertEquals((long)0L, (long)errors.get());
        Assert.assertTrue((counter.get() <= 0 ? 1 : 0) != 0);
    }

    private class StressThread
    extends Thread {
        private final AtomicInteger counter;
        private final AtomicInteger errors;

        public StressThread(AtomicInteger counter, AtomicInteger errors) {
            this.counter = counter;
            this.errors = errors;
        }

        @Override
        public void run() {
            try {
                while (true) {
                    int index;
                    if ((index = this.counter.decrementAndGet()) <= 0) {
                        return;
                    }
                    IMap map = MapMemoryUsageStressTest.this.client.getMap("juka" + index);
                    map.set((Object)"aaaa", (Object)"bbbb");
                    map.clear();
                    map.destroy();
                    if (index % 1000 != 0) continue;
                    MapMemoryUsageStressTest.this.logger.log(Level.INFO, "At: " + index);
                }
            }
            catch (Throwable t) {
                this.errors.incrementAndGet();
                t.printStackTrace();
                return;
            }
        }
    }
}

