/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.map;

import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.Config;
import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.EntryListener;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.core.MapEvent;
import com.hazelcast.map.EntryBackupProcessor;
import com.hazelcast.map.EntryProcessor;
import com.hazelcast.map.QueryResultSizeExceededException;
import com.hazelcast.map.impl.MapListenerAdapter;
import com.hazelcast.map.listener.MapListener;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.TruePredicate;
import com.hazelcast.spi.properties.GroupProperty;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class MapPreconditionsTest {
    private final TestHazelcastFactory hazelcastFactory = new TestHazelcastFactory();
    private HazelcastInstance client;
    private HazelcastInstance server;
    private IMap<Object, Object> map;

    @Before
    public void setUp() throws Exception {
        Config config = new Config();
        config.setProperty(GroupProperty.QUERY_RESULT_SIZE_LIMIT.getName(), "1");
        this.server = this.hazelcastFactory.newHazelcastInstance(config);
        this.client = this.hazelcastFactory.newHazelcastClient();
        this.map = this.client.getMap("trial");
    }

    @After
    public void tearDown() {
        this.hazelcastFactory.terminateAll();
    }

    @Test(expected=NullPointerException.class)
    public void testContainsKey() throws Exception {
        this.map.containsKey(null);
    }

    @Test(expected=NullPointerException.class)
    public void testContainsValue() throws Exception {
        this.map.containsValue(null);
    }

    @Test(expected=NullPointerException.class)
    public void testGet() throws Exception {
        this.map.get(null);
    }

    @Test(expected=NullPointerException.class)
    public void testPutWithNullKey() throws Exception {
        this.map.put(null, (Object)"1");
    }

    @Test(expected=NullPointerException.class)
    public void testPutWithNullValue() throws Exception {
        this.map.put((Object)"1", null);
    }

    @Test(expected=NullPointerException.class)
    public void testRemove() throws Exception {
        this.map.remove(null);
    }

    @Test(expected=NullPointerException.class)
    public void testRemoveWithNullKey() throws Exception {
        this.map.remove(null, (Object)"1");
    }

    @Test(expected=NullPointerException.class)
    public void testRemoveWithNullValue() throws Exception {
        this.map.remove((Object)"1", null);
    }

    @Test(expected=NullPointerException.class)
    public void testDelete() throws Exception {
        this.map.delete(null);
    }

    @Test(expected=NullPointerException.class)
    public void testGetAll() throws Exception {
        HashSet<Object> set = new HashSet<Object>();
        set.add(null);
        this.map.getAll(set);
    }

    @Test(expected=NullPointerException.class)
    public void testGetAsync() throws Exception {
        this.map.getAsync(null);
    }

    @Test(expected=NullPointerException.class)
    public void testPutAsyncWithNullValue() throws Exception {
        this.map.putAsync((Object)"1", null);
    }

    @Test(expected=NullPointerException.class)
    public void testPutAsyncWithNullKey() throws Exception {
        this.map.putAsync(null, (Object)"1");
    }

    @Test(expected=NullPointerException.class)
    public void testPutAsyncTTLWithNullValue() throws Exception {
        this.map.putAsync((Object)"1", null, 10L, TimeUnit.MILLISECONDS);
    }

    @Test(expected=NullPointerException.class)
    public void testPutAsyncTTLWithNullKey() throws Exception {
        this.map.putAsync(null, (Object)"1", 10L, TimeUnit.MILLISECONDS);
    }

    @Test(expected=NullPointerException.class)
    public void testRemoveAsync() throws Exception {
        this.map.removeAsync(null);
    }

    @Test(expected=NullPointerException.class)
    public void testTryRemove() throws Exception {
        this.map.tryRemove(null, 10L, TimeUnit.MILLISECONDS);
    }

    @Test(expected=NullPointerException.class)
    public void testTryPutWithNullKey() throws Exception {
        this.map.tryPut(null, (Object)"1", 10L, TimeUnit.MILLISECONDS);
    }

    @Test(expected=NullPointerException.class)
    public void testTryPutWithNullValue() throws Exception {
        this.map.tryPut((Object)"1", null, 10L, TimeUnit.MILLISECONDS);
    }

    @Test(expected=NullPointerException.class)
    public void testPutTTLWithNullKey() throws Exception {
        this.map.put(null, (Object)"1", 1L, TimeUnit.MILLISECONDS);
    }

    @Test(expected=NullPointerException.class)
    public void testPutTTLWithNullValue() throws Exception {
        this.map.put((Object)"1", null, 10L, TimeUnit.MILLISECONDS);
    }

    @Test(expected=NullPointerException.class)
    public void testPutTransientWithNullKey() throws Exception {
        this.map.putTransient(null, (Object)"1", 1L, TimeUnit.MILLISECONDS);
    }

    @Test(expected=NullPointerException.class)
    public void testPutTransientWithNullValue() throws Exception {
        this.map.putTransient((Object)"1", null, 10L, TimeUnit.MILLISECONDS);
    }

    @Test(expected=NullPointerException.class)
    public void testPutIfAbsentWithNullKey() throws Exception {
        this.map.putIfAbsent(null, (Object)"1");
    }

    @Test(expected=NullPointerException.class)
    public void testPutIfAbsentWithNullValue() throws Exception {
        this.map.putIfAbsent((Object)"1", null);
    }

    @Test(expected=NullPointerException.class)
    public void testPutIfAbsentTTLWithNullKey() throws Exception {
        this.map.putIfAbsent(null, (Object)"1", 1L, TimeUnit.MILLISECONDS);
    }

    @Test(expected=NullPointerException.class)
    public void testPutIfAbsentTTLWithNullValue() throws Exception {
        this.map.putIfAbsent((Object)"1", null, 10L, TimeUnit.MILLISECONDS);
    }

    @Test(expected=NullPointerException.class)
    public void testReplaceWithNullKey() throws Exception {
        this.map.replace(null, (Object)"1", (Object)"2");
    }

    @Test(expected=NullPointerException.class)
    public void testReplaceWithNullValue() throws Exception {
        this.map.replace((Object)"1", null, (Object)"2");
    }

    @Test(expected=NullPointerException.class)
    public void testReplaceWithNullNewValue() throws Exception {
        this.map.replace((Object)"1", (Object)"1", null);
    }

    @Test(expected=NullPointerException.class)
    public void testReplaceNoNewValueWithNullKey() throws Exception {
        this.map.replace(null, (Object)"1");
    }

    @Test(expected=NullPointerException.class)
    public void testReplaceNoNewValueWithNullValue() throws Exception {
        this.map.replace((Object)"1", null);
    }

    @Test(expected=NullPointerException.class)
    public void testSetWithNullKey() throws Exception {
        this.map.set(null, (Object)"1");
    }

    @Test(expected=NullPointerException.class)
    public void testSetWithNullValue() throws Exception {
        this.map.set((Object)"1", null);
    }

    @Test(expected=NullPointerException.class)
    public void testSetTTLWithNullKey() throws Exception {
        this.map.set(null, (Object)"1", 10L, TimeUnit.MILLISECONDS);
    }

    @Test(expected=NullPointerException.class)
    public void testSetTTLWithNullValue() throws Exception {
        this.map.set((Object)"1", null, 10L, TimeUnit.MILLISECONDS);
    }

    @Test(expected=NullPointerException.class)
    public void testLock() throws Exception {
        this.map.lock(null);
    }

    @Test(expected=NullPointerException.class)
    public void testLockLease() throws Exception {
        this.map.lock(null, 100L, TimeUnit.MILLISECONDS);
    }

    @Test(expected=NullPointerException.class)
    public void testIsLocked() throws Exception {
        this.map.isLocked(null);
    }

    @Test(expected=NullPointerException.class)
    public void testTryLock() throws Exception {
        this.map.tryLock(null);
    }

    @Test(expected=NullPointerException.class)
    public void testTryLockTimeout() throws Exception {
        this.map.tryLock(null, 10L, TimeUnit.MILLISECONDS);
    }

    @Test(expected=NullPointerException.class)
    public void testTryLockTimeoutAndLease() throws Exception {
        this.map.tryLock(null, 10L, TimeUnit.MILLISECONDS, 100L, TimeUnit.MILLISECONDS);
    }

    @Test(expected=NullPointerException.class)
    public void testUnlockWithNullKey() throws Exception {
        this.map.unlock(null);
    }

    @Test(expected=IllegalMonitorStateException.class)
    public void testUnlockWithNoLock() throws Exception {
        this.map.unlock((Object)123);
    }

    @Test(expected=NullPointerException.class)
    public void testForceUnlock() throws Exception {
        this.map.forceUnlock(null);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testAddLocalEntryListenerWithMapListener() throws Exception {
        MapListener mapListener = null;
        this.map.addLocalEntryListener(mapListener);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testAddLocalEntryListenerWithEntryListener() throws Exception {
        EntryListener entryListener = null;
        this.map.addLocalEntryListener(entryListener);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testAddLocalEntryListenerWithMapListenerAndPredicateAndKey_NullListener() throws Exception {
        MapListener mapListener = null;
        TruePredicate predicate = new TruePredicate();
        this.map.addLocalEntryListener(mapListener, (Predicate)predicate, null, false);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testAddLocalEntryListenerWithMapListenerAndPredicateAndKey_NullPredicate() throws Exception {
        MapListenerAdapter mapListener = new MapListenerAdapter(){

            public void onEntryEvent(EntryEvent event) {
                System.out.println("-");
            }
        };
        Predicate predicate = null;
        this.map.addLocalEntryListener((MapListener)mapListener, predicate, null, true);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testAddLocalEntryListenerWithEntryListenerAndPredicateAndKey_NullListener() throws Exception {
        EntryListener entryListener = null;
        TruePredicate predicate = new TruePredicate();
        this.map.addLocalEntryListener(entryListener, (Predicate)predicate, null, false);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testAddLocalEntryListenerWithEntryListenerAndPredicateAndKey_NullPredicate() throws Exception {
        TestEntryListener entryListener = new TestEntryListener();
        Predicate predicate = null;
        this.map.addLocalEntryListener((EntryListener)entryListener, predicate, null, true);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testAddLocalEntryListenerWithMapListenerAndPredicate_NullListener() throws Exception {
        MapListener mapListener = null;
        TruePredicate predicate = new TruePredicate();
        this.map.addLocalEntryListener(mapListener, (Predicate)predicate, false);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testAddLocalEntryListenerWithMapListenerAndPredicate_NullPredicate() throws Exception {
        MapListenerAdapter mapListener = new MapListenerAdapter(){

            public void onEntryEvent(EntryEvent event) {
                System.out.println("-");
            }
        };
        Predicate predicate = null;
        this.map.addLocalEntryListener((MapListener)mapListener, predicate, true);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testAddLocalEntryListenerWithEntryListenerAndPredicate_NullListener() throws Exception {
        EntryListener entryListener = null;
        TruePredicate predicate = new TruePredicate();
        this.map.addLocalEntryListener(entryListener, (Predicate)predicate, false);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testAddLocalEntryListenerWithEntryListenerAndPredicate_NullPredicate() throws Exception {
        TestEntryListener entryListener = new TestEntryListener();
        Predicate predicate = null;
        this.map.addLocalEntryListener((EntryListener)entryListener, predicate, true);
    }

    @Test(expected=NullPointerException.class)
    public void testAddEntryListenerWithMapListener() throws Exception {
        MapListener mapListener = null;
        this.map.addEntryListener(mapListener, false);
    }

    @Test(expected=NullPointerException.class)
    public void testAddEntryListenerWithEntryListener() throws Exception {
        EntryListener entryListener = null;
        this.map.addEntryListener(entryListener, false);
    }

    @Test(expected=NullPointerException.class)
    public void testAddPartitionLostListener() throws Exception {
        this.map.addPartitionLostListener(null);
    }

    @Test(expected=NullPointerException.class)
    public void testAddEntryListenerWithMapListenerAndKey_NullListener() throws Exception {
        MapListener mapListener = null;
        Integer i = 3;
        this.map.addEntryListener(mapListener, (Object)i, false);
    }

    @Test(expected=NullPointerException.class)
    public void testAddEntryListenerWithMapListenerAndKey_NullKey() throws Exception {
        MapListenerAdapter mapListener = new MapListenerAdapter(){

            public void onEntryEvent(EntryEvent event) {
                System.out.println("-");
            }
        };
        this.map.addEntryListener((MapListener)mapListener, null, false);
    }

    @Test(expected=NullPointerException.class)
    public void testAddEntryListenerWithEntryListenerAndKey_NullListener() throws Exception {
        EntryListener entryListener = null;
        Integer i = 3;
        this.map.addEntryListener(entryListener, (Object)i, false);
    }

    @Test(expected=NullPointerException.class)
    public void testAddEntryListenerWithEntryListenerAndKey_NullKey() throws Exception {
        TestEntryListener entryListener = new TestEntryListener();
        this.map.addEntryListener((EntryListener)entryListener, null, false);
    }

    @Test(expected=NullPointerException.class)
    public void testAddEntryListenerWithMapListenerAndPredicateAndKey_NullListener() throws Exception {
        MapListener mapListener = null;
        TruePredicate predicate = new TruePredicate();
        this.map.addEntryListener(mapListener, (Predicate)predicate, null, true);
    }

    @Test(expected=NullPointerException.class)
    public void testAddEntryListenerWithMapListenerAndPredicateAndKey_NullPredicate() throws Exception {
        MapListenerAdapter mapListener = new MapListenerAdapter(){

            public void onEntryEvent(EntryEvent event) {
                System.out.println("-");
            }
        };
        Predicate predicate = null;
        this.map.addEntryListener((MapListener)mapListener, predicate, null, true);
    }

    @Test(expected=NullPointerException.class)
    public void testAddEntryListenerWithEntryListenerAndPredicateAndKey_NullListener() throws Exception {
        EntryListener entryListener = null;
        TruePredicate predicate = new TruePredicate();
        this.map.addEntryListener(entryListener, (Predicate)predicate, null, false);
    }

    @Test(expected=NullPointerException.class)
    public void testAddEntryListenerWithEntryListenerAndPredicateAndKey_NullPredicate() throws Exception {
        TestEntryListener entryListener = new TestEntryListener();
        Predicate predicate = null;
        this.map.addEntryListener((EntryListener)entryListener, predicate, null, true);
    }

    @Test(expected=NullPointerException.class)
    public void testAddEntryListenerWithMapListenerAndPredicate_NullListener() throws Exception {
        MapListener mapListener = null;
        TruePredicate predicate = new TruePredicate();
        this.map.addEntryListener(mapListener, (Predicate)predicate, false);
    }

    @Test(expected=NullPointerException.class)
    public void testAddEntryListenerWithMapListenerAndPredicate_NullPredicate() throws Exception {
        MapListenerAdapter mapListener = new MapListenerAdapter(){

            public void onEntryEvent(EntryEvent event) {
                System.out.println("-");
            }
        };
        Predicate predicate = null;
        this.map.addEntryListener((MapListener)mapListener, predicate, true);
    }

    @Test(expected=NullPointerException.class)
    public void testAddEntryListenerWithEntryListenerAndPredicate_NullListener() throws Exception {
        EntryListener entryListener = null;
        TruePredicate predicate = new TruePredicate();
        this.map.addEntryListener(entryListener, (Predicate)predicate, false);
    }

    @Test(expected=NullPointerException.class)
    public void testAddEntryListenerWithEntryListenerAndPredicate_NullPredicate() throws Exception {
        TestEntryListener entryListener = new TestEntryListener();
        Predicate predicate = null;
        this.map.addEntryListener((EntryListener)entryListener, predicate, true);
    }

    @Test(expected=NullPointerException.class)
    public void testGetEntryView() throws Exception {
        this.map.getEntryView(null);
    }

    @Test(expected=NullPointerException.class)
    public void testEvict() throws Exception {
        this.map.evict(null);
    }

    @Test(expected=QueryResultSizeExceededException.class)
    public void testKeySet() throws Exception {
        for (int i = 0; i < 115001; ++i) {
            this.map.put((Object)i, (Object)i);
        }
        this.map.keySet();
    }

    @Test(expected=QueryResultSizeExceededException.class)
    public void testValues() throws Exception {
        for (int i = 0; i < 115001; ++i) {
            this.map.put((Object)i, (Object)i);
        }
        this.map.values();
    }

    @Test(expected=QueryResultSizeExceededException.class)
    public void testEntrySet() throws Exception {
        for (int i = 0; i < 115001; ++i) {
            this.map.put((Object)i, (Object)i);
        }
        this.map.entrySet();
    }

    @Test(expected=NullPointerException.class)
    public void testKeySetWithNullPredicate() throws Exception {
        this.map.keySet(null);
    }

    @Test(expected=QueryResultSizeExceededException.class)
    public void testKeySetWithPredicate() throws Exception {
        for (int i = 0; i < 115001; ++i) {
            this.map.put((Object)i, (Object)i);
        }
        this.map.keySet((Predicate)TruePredicate.INSTANCE);
    }

    @Test(expected=NullPointerException.class)
    public void testEntrySetWithNullPredicate() throws Exception {
        this.map.entrySet(null);
    }

    @Test(expected=QueryResultSizeExceededException.class)
    public void testEntrySetWithPredicate() throws Exception {
        for (int i = 0; i < 115001; ++i) {
            this.map.put((Object)i, (Object)i);
        }
        this.map.entrySet((Predicate)TruePredicate.INSTANCE);
    }

    @Test(expected=NullPointerException.class)
    public void testValuesWithNullPredicate() throws Exception {
        this.map.values(null);
    }

    @Test(expected=QueryResultSizeExceededException.class)
    public void testValuesWitPredicate() throws Exception {
        for (int i = 0; i < 115001; ++i) {
            this.map.put((Object)i, (Object)i);
        }
        this.map.values((Predicate)TruePredicate.INSTANCE);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testLocalKeySet() throws Exception {
        for (int i = 0; i < 115001; ++i) {
            this.map.put((Object)i, (Object)i);
        }
        this.map.localKeySet();
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testLocalKeySetWithPredicate() throws Exception {
        for (int i = 0; i < 115001; ++i) {
            this.map.put((Object)i, (Object)i);
        }
        this.map.localKeySet((Predicate)TruePredicate.INSTANCE);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testLocalKeySetWithNullPredicate() throws Exception {
        for (int i = 0; i < 115001; ++i) {
            this.map.put((Object)i, (Object)i);
        }
        this.map.localKeySet(null);
    }

    @Test(expected=NullPointerException.class)
    public void testExecuteOnKey() throws Exception {
        this.map.executeOnKey(null, (EntryProcessor)new NoOpEntryProcessor());
    }

    @Test(expected=NullPointerException.class)
    public void testExecuteOnKeys() throws Exception {
        HashSet<Object> set = new HashSet<Object>();
        set.add(null);
        this.map.executeOnKeys(set, (EntryProcessor)new NoOpEntryProcessor());
    }

    @Test
    public void testIssue7631_emptyKeysSupported() {
        Map res = this.map.executeOnKeys(Collections.emptySet(), (EntryProcessor)new NoOpEntryProcessor());
        Assert.assertEquals(Collections.emptyMap(), (Object)res);
    }

    private class TestEntryListener
    implements EntryListener {
        int entryAddedCalled;
        int entryEvictedCalled;
        int entryRemovedCalled;
        int entryUpdatedCalled;
        int mapClearedCalled;
        int mapEvictedCalled;

        private TestEntryListener() {
        }

        public void entryAdded(EntryEvent event) {
            ++this.entryAddedCalled;
        }

        public void entryEvicted(EntryEvent event) {
            ++this.entryEvictedCalled;
        }

        public void entryRemoved(EntryEvent event) {
            ++this.entryRemovedCalled;
        }

        public void entryUpdated(EntryEvent event) {
            ++this.entryUpdatedCalled;
        }

        public void mapCleared(MapEvent event) {
            ++this.mapClearedCalled;
        }

        public void mapEvicted(MapEvent event) {
            ++this.mapEvictedCalled;
        }
    }

    private static class NoOpEntryProcessor
    implements EntryProcessor {
        private NoOpEntryProcessor() {
        }

        public Object process(Map.Entry entry) {
            return null;
        }

        public EntryBackupProcessor getBackupProcessor() {
            return null;
        }
    }
}

