/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.map.impl.nearcache;

import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.map.impl.nearcache.NearCacheLiteMemberTest;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientMapNearCacheLiteMemberTest {
    private String mapName;
    private TestHazelcastFactory factory;
    private HazelcastInstance client;
    private HazelcastInstance lite;

    @Before
    public void init() {
        this.mapName = HazelcastTestSupport.randomMapName();
        this.factory = new TestHazelcastFactory();
        this.factory.newHazelcastInstance(NearCacheLiteMemberTest.createConfig((String)this.mapName, (boolean)false));
        this.client = this.factory.newHazelcastClient();
        this.lite = this.factory.newHazelcastInstance(NearCacheLiteMemberTest.createConfig((String)this.mapName, (boolean)true));
    }

    @After
    public void destroy() {
        this.factory.terminateAll();
    }

    @Test
    public void testPut() {
        NearCacheLiteMemberTest.testPut((HazelcastInstance)this.client, (HazelcastInstance)this.lite, (String)this.mapName);
    }

    @Test
    public void testPutAll() {
        NearCacheLiteMemberTest.testPutAll((HazelcastInstance)this.client, (HazelcastInstance)this.lite, (String)this.mapName);
    }

    @Test
    public void testPutTransient() {
        NearCacheLiteMemberTest.testPutTransient((HazelcastInstance)this.client, (HazelcastInstance)this.lite, (String)this.mapName);
    }

    @Test
    public void testSet() {
        NearCacheLiteMemberTest.testSet((HazelcastInstance)this.client, (HazelcastInstance)this.lite, (String)this.mapName);
    }

    @Test
    public void testUpdate() {
        NearCacheLiteMemberTest.testUpdate((HazelcastInstance)this.client, (HazelcastInstance)this.lite, (String)this.mapName);
    }

    @Test
    public void testUpdateWithSet() {
        NearCacheLiteMemberTest.testUpdateWithSet((HazelcastInstance)this.client, (HazelcastInstance)this.lite, (String)this.mapName);
    }

    @Test
    public void testUpdateWithPutAll() {
        NearCacheLiteMemberTest.testUpdateWithPutAll((HazelcastInstance)this.client, (HazelcastInstance)this.lite, (String)this.mapName);
    }

    @Test
    public void testReplace() {
        NearCacheLiteMemberTest.testReplace((HazelcastInstance)this.client, (HazelcastInstance)this.lite, (String)this.mapName);
    }

    @Test
    public void testEvict() {
        NearCacheLiteMemberTest.testEvict((HazelcastInstance)this.client, (HazelcastInstance)this.lite, (String)this.mapName);
    }

    @Test
    public void testRemove() {
        NearCacheLiteMemberTest.testRemove((HazelcastInstance)this.client, (HazelcastInstance)this.lite, (String)this.mapName);
    }

    @Test
    public void testDelete() {
        NearCacheLiteMemberTest.testDelete((HazelcastInstance)this.client, (HazelcastInstance)this.lite, (String)this.mapName);
    }

    @Test
    public void testClear() {
        NearCacheLiteMemberTest.testClear((HazelcastInstance)this.client, (HazelcastInstance)this.lite, (String)this.mapName);
    }

    @Test
    public void testEvictAll() {
        NearCacheLiteMemberTest.testEvictAll((HazelcastInstance)this.client, (HazelcastInstance)this.lite, (String)this.mapName);
    }

    @Test
    public void testExecuteOnKey() {
        NearCacheLiteMemberTest.testExecuteOnKey((HazelcastInstance)this.client, (HazelcastInstance)this.lite, (String)this.mapName);
    }

    @Test
    public void testExecuteOnKeys() {
        NearCacheLiteMemberTest.testExecuteOnKeys((HazelcastInstance)this.client, (HazelcastInstance)this.lite, (String)this.mapName);
    }

    @Test
    public void testLoadAll() {
        this.initWithMapStore();
        NearCacheLiteMemberTest.testLoadAll((HazelcastInstance)this.client, (HazelcastInstance)this.lite, (String)this.mapName);
    }

    @Test
    public void testLoadAllWithKeySet() {
        this.initWithMapStore();
        NearCacheLiteMemberTest.testLoadAllWithKeySet((HazelcastInstance)this.client, (HazelcastInstance)this.lite, (String)this.mapName);
    }

    private void initWithMapStore() {
        this.factory.terminateAll();
        this.factory.newHazelcastInstance(NearCacheLiteMemberTest.createNearCachedMapConfigWithMapStoreConfig((String)this.mapName, (boolean)false));
        this.client = this.factory.newHazelcastClient();
        this.lite = this.factory.newHazelcastInstance(NearCacheLiteMemberTest.createNearCachedMapConfigWithMapStoreConfig((String)this.mapName, (boolean)true));
    }
}

