/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.map.impl.nearcache;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.impl.HazelcastClientProxy;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.internal.adapter.DataStructureAdapter;
import com.hazelcast.internal.adapter.IMapDataStructureAdapter;
import com.hazelcast.internal.nearcache.AbstractNearCachePreloaderTest;
import com.hazelcast.internal.nearcache.NearCache;
import com.hazelcast.internal.nearcache.NearCacheManager;
import com.hazelcast.internal.nearcache.NearCacheTestContext;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.serialization.SerializationService;
import com.hazelcast.test.HazelcastParametersRunnerFactory;
import com.hazelcast.test.annotation.QuickTest;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Parameterized.UseParametersRunnerFactory(value=HazelcastParametersRunnerFactory.class)
@Category(value={QuickTest.class})
public class ClientMapNearCachePreloaderTest
extends AbstractNearCachePreloaderTest<Data, String> {
    private static final File DEFAULT_STORE_FILE = new File("nearCache-defaultNearCache.store").getAbsoluteFile();
    private static final File DEFAULT_STORE_LOCK_FILE = new File(DEFAULT_STORE_FILE.getName() + ".lock").getAbsoluteFile();
    @Parameterized.Parameter
    public boolean invalidationOnChange;
    private final TestHazelcastFactory hazelcastFactory = new TestHazelcastFactory();

    @Parameterized.Parameters(name="invalidationOnChange:{0}")
    public static Collection<Object[]> parameters() {
        return Arrays.asList({false}, {true});
    }

    @Before
    public void setUp() {
        this.nearCacheConfig = this.getNearCacheConfig(this.invalidationOnChange, 10023, DEFAULT_STORE_FILE.getParent());
    }

    @After
    public void tearDown() {
        this.hazelcastFactory.shutdownAll();
    }

    @Test(timeout=120000L)
    public void testPreloadNearCacheLock_withSharedMapConfig_concurrently() throws Exception {
        this.nearCacheConfig.getPreloaderConfig().setDirectory("");
        int nThreads = 10;
        ThreadPoolExecutor pool = (ThreadPoolExecutor)Executors.newFixedThreadPool(nThreads);
        final NearCacheTestContext context = this.createContext(true);
        final CountDownLatch startLatch = new CountDownLatch(nThreads);
        final CountDownLatch finishLatch = new CountDownLatch(nThreads);
        for (int i = 0; i < nThreads; ++i) {
            pool.execute(new Runnable(){

                @Override
                public void run() {
                    startLatch.countDown();
                    try {
                        startLatch.await();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                    IMap map = context.nearCacheInstance.getMap("defaultNearCache" + Thread.currentThread());
                    for (int i = 0; i < 100; ++i) {
                        map.put((Object)("key-" + Thread.currentThread() + "-" + i), (Object)("value-" + Thread.currentThread() + "-" + i));
                    }
                    finishLatch.countDown();
                }
            });
        }
        finishLatch.await();
        pool.shutdownNow();
    }

    protected File getDefaultStoreFile() {
        return DEFAULT_STORE_FILE;
    }

    protected File getDefaultStoreLockFile() {
        return DEFAULT_STORE_LOCK_FILE;
    }

    protected <K, V> NearCacheTestContext<K, V, Data, String> createContext(boolean createClient) {
        HazelcastInstance member = this.hazelcastFactory.newHazelcastInstance(this.getConfig());
        IMap memberMap = member.getMap("defaultNearCache");
        if (!createClient) {
            return new NearCacheTestContext((SerializationService)ClientMapNearCachePreloaderTest.getSerializationService((HazelcastInstance)member), member, (DataStructureAdapter)new IMapDataStructureAdapter(memberMap), false, null, null);
        }
        NearCacheTestContext<K, V, Data, String> clientContext = this.createClientContext();
        return new NearCacheTestContext(clientContext.serializationService, clientContext.nearCacheInstance, member, clientContext.nearCacheAdapter, (DataStructureAdapter)new IMapDataStructureAdapter(memberMap), false, clientContext.nearCache, clientContext.nearCacheManager);
    }

    protected <K, V> NearCacheTestContext<K, V, Data, String> createClientContext() {
        ClientConfig clientConfig = this.getClientConfig().addNearCacheConfig(this.nearCacheConfig);
        HazelcastClientProxy client = (HazelcastClientProxy)this.hazelcastFactory.newHazelcastClient(clientConfig);
        IMap clientMap = client.getMap("defaultNearCache");
        NearCacheManager nearCacheManager = client.client.getNearCacheManager();
        NearCache nearCache = nearCacheManager.getNearCache("defaultNearCache");
        return new NearCacheTestContext(client.getSerializationService(), (HazelcastInstance)client, null, (DataStructureAdapter)new IMapDataStructureAdapter(clientMap), null, false, nearCache, nearCacheManager);
    }

    protected ClientConfig getClientConfig() {
        return new ClientConfig();
    }
}

