/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.map.impl.nearcache;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.Config;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.config.SerializationConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.nio.serialization.ClassDefinition;
import com.hazelcast.nio.serialization.ClassDefinitionBuilder;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.nio.serialization.PortableFactory;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.test.HazelcastSerialClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.QuickTest;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastSerialClassRunner.class)
@Category(value={QuickTest.class})
public class ClientMapNearCacheSerializationCountTest
extends HazelcastTestSupport {
    protected static final String MAP_NAME = ClientMapNearCacheSerializationCountTest.randomString();
    protected static final AtomicInteger SERIALIZE_COUNT = new AtomicInteger();
    protected static final AtomicInteger DESERIALIZE_COUNT = new AtomicInteger();
    protected TestHazelcastFactory hazelcastFactory = new TestHazelcastFactory();
    protected IMap<String, SerializationCountingData> map;

    @After
    public void tearDown() {
        DESERIALIZE_COUNT.set(0);
        SERIALIZE_COUNT.set(0);
        this.hazelcastFactory.terminateAll();
    }

    @Test
    public void testDeserializationCountWith_ObjectNearCache_invalidateLocalUpdatePolicy() {
        NearCacheConfig nearCacheConfig = this.createNearCacheConfig(InMemoryFormat.OBJECT, NearCacheConfig.LocalUpdatePolicy.INVALIDATE);
        this.prepareCache(nearCacheConfig);
        String key = ClientMapNearCacheSerializationCountTest.randomString();
        SerializationCountingData value = new SerializationCountingData();
        this.map.put((Object)key, (Object)value);
        this.assertAndReset(1, 0);
        this.map.get((Object)key);
        this.assertAndReset(0, 1);
        this.map.get((Object)key);
        this.assertAndReset(0, 0);
    }

    @Test
    public void testDeserializationCountWith_BinaryNearCache_invalidateLocalUpdatePolicy() {
        NearCacheConfig nearCacheConfig = this.createNearCacheConfig(InMemoryFormat.BINARY, NearCacheConfig.LocalUpdatePolicy.INVALIDATE);
        this.prepareCache(nearCacheConfig);
        String key = ClientMapNearCacheSerializationCountTest.randomString();
        SerializationCountingData value = new SerializationCountingData();
        this.map.put((Object)key, (Object)value);
        this.assertAndReset(1, 0);
        this.map.get((Object)key);
        this.assertAndReset(0, 1);
        this.map.get((Object)key);
        this.assertAndReset(0, 1);
    }

    protected NearCacheConfig createNearCacheConfig(InMemoryFormat inMemoryFormat, NearCacheConfig.LocalUpdatePolicy localUpdatePolicy) {
        return new NearCacheConfig().setName(MAP_NAME).setLocalUpdatePolicy(localUpdatePolicy).setInMemoryFormat(inMemoryFormat);
    }

    protected Config createConfig() {
        Config config = new Config();
        SerializationConfig serializationConfig = config.getSerializationConfig();
        this.prepareSerializationConfig(serializationConfig);
        return config;
    }

    protected ClientConfig createClientConfig() {
        ClientConfig config = new ClientConfig();
        SerializationConfig serializationConfig = config.getSerializationConfig();
        this.prepareSerializationConfig(serializationConfig);
        return config;
    }

    protected void prepareSerializationConfig(SerializationConfig serializationConfig) {
        ClassDefinition classDefinition = new ClassDefinitionBuilder(SerializationCountingData.FACTORY_ID, SerializationCountingData.CLASS_ID).build();
        serializationConfig.addClassDefinition(classDefinition);
        serializationConfig.addPortableFactory(SerializationCountingData.FACTORY_ID, new PortableFactory(){

            public Portable create(int classId) {
                return new SerializationCountingData();
            }
        });
    }

    protected void prepareCache(NearCacheConfig nearCacheConfig) {
        this.hazelcastFactory.newHazelcastInstance(this.createConfig());
        ClientConfig clientConfig = this.createClientConfig();
        if (nearCacheConfig != null) {
            clientConfig.addNearCacheConfig(nearCacheConfig);
        }
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient(clientConfig);
        this.map = client.getMap(MAP_NAME);
    }

    protected void assertAndReset(int serializeCount, int deserializeCount) {
        Assert.assertEquals((long)serializeCount, (long)SERIALIZE_COUNT.getAndSet(0));
        Assert.assertEquals((long)deserializeCount, (long)DESERIALIZE_COUNT.getAndSet(0));
    }

    protected static class SerializationCountingData
    implements Portable {
        static int FACTORY_ID = 1;
        static int CLASS_ID = 1;

        public int getFactoryId() {
            return FACTORY_ID;
        }

        public int getClassId() {
            return CLASS_ID;
        }

        public void writePortable(PortableWriter writer) throws IOException {
            SERIALIZE_COUNT.incrementAndGet();
        }

        public void readPortable(PortableReader reader) throws IOException {
            DESERIALIZE_COUNT.incrementAndGet();
        }
    }
}

