/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.map.impl.nearcache;

import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.proxy.NearCachedClientMapProxy;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.QuickTest;
import com.hazelcast.util.RandomPicker;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class})
public class ClientMapNearCacheStalenessTest
extends HazelcastTestSupport {
    private final int ENTRY_COUNT = 10;
    private final int NEAR_CACHE_INVALIDATOR_THREAD_COUNT = 1;
    private final int NEAR_CACHE_PUTTER_THREAD_COUNT = 10;
    private final String MAP_NAME = ClientMapNearCacheStalenessTest.randomMapName();
    private final AtomicBoolean stop = new AtomicBoolean(false);
    private HazelcastInstance member;
    private HazelcastInstance client;
    private IMap<Integer, Integer> clientMap;
    private IMap<Integer, Integer> memberMap;

    @Before
    public void setUp() {
        ClientConfig clientConfig = this.getClientConfig(this.MAP_NAME);
        clientConfig.setProperty("hazelcast.invalidation.max.tolerated.miss.count", "0");
        this.member = Hazelcast.newHazelcastInstance();
        this.client = HazelcastClient.newHazelcastClient((ClientConfig)clientConfig);
        this.memberMap = this.member.getMap(this.MAP_NAME);
        this.clientMap = this.client.getMap(this.MAP_NAME);
    }

    protected ClientConfig getClientConfig(String mapName) {
        NearCacheConfig nearCacheConfig = this.getNearCacheConfig(mapName);
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.addNearCacheConfig(nearCacheConfig);
        return clientConfig;
    }

    private NearCacheConfig getNearCacheConfig(String mapName) {
        NearCacheConfig nearCacheConfig = new NearCacheConfig(mapName);
        nearCacheConfig.setInvalidateOnChange(true);
        return nearCacheConfig;
    }

    @After
    public void tearDown() {
        this.client.shutdown();
        this.member.shutdown();
    }

    @Test
    public void testNearCache_notContainsStaleValue_whenUpdatedByMultipleThreads() throws Exception {
        int i;
        ArrayList<Thread> threads = new ArrayList<Thread>();
        for (i = 0; i < 1; ++i) {
            NearCacheInvalidator putter = new NearCacheInvalidator();
            threads.add(putter);
        }
        for (i = 0; i < 10; ++i) {
            NearCachePutter getter = new NearCachePutter();
            threads.add(getter);
        }
        for (Thread thread : threads) {
            thread.start();
        }
        ClientMapNearCacheStalenessTest.sleepSeconds((int)5);
        this.stop.set(true);
        for (Thread thread : threads) {
            thread.join();
        }
        ClientMapNearCacheStalenessTest.sleepSeconds((int)5);
        this.assertNoStaleDataExistInNearCache(this.clientMap);
    }

    private void assertNoStaleDataExistInNearCache(IMap<Integer, Integer> map) {
        HashMap<Integer, Integer> fromNearCache = this.getAllEntries(map);
        ((NearCachedClientMapProxy)map).getNearCache().clear();
        HashMap<Integer, Integer> fromIMap = this.getAllEntries(map);
        for (int i = 0; i < 10; ++i) {
            Assert.assertEquals(fromIMap.get(i), fromNearCache.get(i));
        }
    }

    private HashMap<Integer, Integer> getAllEntries(IMap<Integer, Integer> iMap) {
        HashMap<Integer, Integer> localMap = new HashMap<Integer, Integer>(10);
        for (int i = 0; i < 10; ++i) {
            localMap.put(i, (Integer)iMap.get((Object)i));
        }
        return localMap;
    }

    private class NearCachePutter
    extends Thread {
        private NearCachePutter() {
        }

        @Override
        public void run() {
            while (!ClientMapNearCacheStalenessTest.this.stop.get()) {
                for (int i = 0; i < 10; ++i) {
                    ClientMapNearCacheStalenessTest.this.clientMap.get((Object)i);
                }
            }
        }
    }

    private class NearCacheInvalidator
    extends Thread {
        private NearCacheInvalidator() {
        }

        @Override
        public void run() {
            while (!ClientMapNearCacheStalenessTest.this.stop.get()) {
                for (int i = 0; i < 10; ++i) {
                    ClientMapNearCacheStalenessTest.this.memberMap.put((Object)i, (Object)RandomPicker.getInt((int)10));
                }
            }
        }
    }
}

