/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.map.impl.nearcache.invalidation;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.proxy.NearCachedClientMapProxy;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.Config;
import com.hazelcast.config.EvictionPolicy;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.map.impl.nearcache.NearCacheTestSupport;
import com.hazelcast.spi.properties.GroupProperty;
import com.hazelcast.test.AssertTask;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.NightlyTest;
import com.hazelcast.util.RandomPicker;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={NightlyTest.class})
public class InvalidationMemberAddRemoveTest
extends NearCacheTestSupport {
    private static final int NEAR_CACHE_POPULATOR_THREAD_COUNT = 3;
    private static final int TEST_RUN_SECONDS = 30;
    private static final int INVALIDATION_BATCH_SIZE = 10000;
    private static final int KEY_COUNT = 100000;
    private static final int RECONCILIATION_INTERVAL_SECONDS = 30;
    private final TestHazelcastFactory factory = new TestHazelcastFactory();

    @After
    public void tearDown() {
        this.factory.shutdownAll();
    }

    @Test
    public void ensure_nearCachedClient_and_member_data_sync_eventually() throws Exception {
        String mapName = "default";
        final AtomicBoolean stopTest = new AtomicBoolean();
        final Config config = this.createConfig();
        HazelcastInstance member = this.factory.newHazelcastInstance(config);
        this.factory.newHazelcastInstance(config);
        final IMap memberMap = member.getMap("default");
        for (int i = 0; i < 100000; ++i) {
            memberMap.put((Object)i, (Object)i);
        }
        ClientConfig clientConfig = this.createClientConfig().addNearCacheConfig(this.createNearCacheConfig("default"));
        HazelcastInstance client = this.factory.newHazelcastClient(clientConfig);
        final IMap clientMap = client.getMap("default");
        ArrayList<Thread> threads = new ArrayList<Thread>();
        Thread shadowMember = new Thread(new Runnable(){

            @Override
            public void run() {
                while (!stopTest.get()) {
                    HazelcastInstance member = InvalidationMemberAddRemoveTest.this.factory.newHazelcastInstance(config);
                    HazelcastTestSupport.sleepSeconds((int)5);
                    member.getLifecycleService().terminate();
                }
            }
        });
        threads.add(shadowMember);
        for (int i = 0; i < 3; ++i) {
            Thread populateClientNearCache = new Thread(new Runnable(){

                @Override
                public void run() {
                    while (!stopTest.get()) {
                        for (int i = 0; i < 100000; ++i) {
                            clientMap.get((Object)i);
                        }
                    }
                }
            });
            threads.add(populateClientNearCache);
        }
        Thread putFromMember = new Thread(new Runnable(){

            @Override
            public void run() {
                while (!stopTest.get()) {
                    int key = RandomPicker.getInt((int)100000);
                    int value = RandomPicker.getInt((int)Integer.MAX_VALUE);
                    memberMap.put((Object)key, (Object)value);
                    HazelcastTestSupport.sleepAtLeastMillis((long)2L);
                }
            }
        });
        threads.add(putFromMember);
        Thread clearFromMember = new Thread(new Runnable(){

            @Override
            public void run() {
                while (!stopTest.get()) {
                    memberMap.clear();
                    HazelcastTestSupport.sleepSeconds((int)5);
                }
            }
        });
        threads.add(clearFromMember);
        for (Thread thread : threads) {
            thread.start();
        }
        InvalidationMemberAddRemoveTest.sleepSeconds((int)30);
        stopTest.set(true);
        for (Thread thread : threads) {
            thread.join();
        }
        InvalidationMemberAddRemoveTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() throws Exception {
                for (int i = 0; i < 100000; ++i) {
                    Integer valueSeenFromMember = (Integer)memberMap.get((Object)i);
                    Integer valueSeenFromClient = (Integer)clientMap.get((Object)i);
                    int nearCacheSize = ((NearCachedClientMapProxy)clientMap).getNearCache().size();
                    Assert.assertEquals((String)("Stale value found. (nearCacheSize=" + nearCacheSize + ")"), (Object)valueSeenFromMember, (Object)valueSeenFromClient);
                }
            }
        });
    }

    protected Config createConfig() {
        Config config = new Config();
        config.setProperty(GroupProperty.PARTITION_COUNT.getName(), "271");
        config.setProperty(GroupProperty.MAP_INVALIDATION_MESSAGE_BATCH_ENABLED.getName(), "true");
        config.setProperty(GroupProperty.MAP_INVALIDATION_MESSAGE_BATCH_SIZE.getName(), Integer.toString(10000));
        return config;
    }

    protected NearCacheConfig createNearCacheConfig(String mapName) {
        NearCacheConfig nearCacheConfig = this.newNearCacheConfig();
        nearCacheConfig.setInvalidateOnChange(true);
        nearCacheConfig.setName(mapName);
        nearCacheConfig.getEvictionConfig().setSize(Integer.MAX_VALUE).setEvictionPolicy(EvictionPolicy.NONE);
        return nearCacheConfig;
    }

    protected ClientConfig createClientConfig() {
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.setProperty("hazelcast.invalidation.max.tolerated.miss.count", "0");
        clientConfig.setProperty("hazelcast.invalidation.reconciliation.interval.seconds", Integer.toString(30));
        return clientConfig;
    }
}

