/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.map.impl.query;

import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.Config;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.Predicates;
import com.hazelcast.query.SampleObjects;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.Collection;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientQueryAdvancedTest {
    private final TestHazelcastFactory hazelcastFactory = new TestHazelcastFactory();

    @After
    public void tearDown() {
        this.hazelcastFactory.terminateAll();
    }

    @Test
    public void queryIndexedComparableField_whenEqualsPredicateWithNullValueIsUsed_thenConverterUsesNullObject() {
        Config config = this.getConfig();
        this.hazelcastFactory.newHazelcastInstance(config);
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient();
        IMap map = client.getMap("default");
        map.addIndex("type", false);
        SampleObjects.ValueType valueType = new SampleObjects.ValueType("name");
        SampleObjects.Value valueWithoutNull = new SampleObjects.Value("notNull", valueType, 1);
        SampleObjects.Value valueWithNull = new SampleObjects.Value("null", null, 1);
        map.put((Object)1, (Object)valueWithoutNull);
        map.put((Object)2, (Object)valueWithNull);
        Predicate nullPredicate = Predicates.equal((String)"type", null);
        Collection emptyFieldValues = map.values(nullPredicate);
        Assert.assertThat((Object)emptyFieldValues, (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat((Object)emptyFieldValues, (Matcher)Matchers.contains((Object[])new SampleObjects.Value[]{valueWithNull}));
    }

    protected Config getConfig() {
        return new Config();
    }
}

