/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.map.querycache;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.EvictionConfig;
import com.hazelcast.config.EvictionPolicy;
import com.hazelcast.config.QueryCacheConfig;
import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.map.QueryCache;
import com.hazelcast.map.listener.EntryEvictedListener;
import com.hazelcast.map.listener.MapListener;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.TruePredicate;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.concurrent.CountDownLatch;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientEvictionTest
extends HazelcastTestSupport {
    private TestHazelcastFactory factory = new TestHazelcastFactory();

    @Before
    public void setUp() throws Exception {
        this.factory.newHazelcastInstance();
    }

    @After
    public void tearDown() throws Exception {
        this.factory.shutdownAll();
    }

    @Test
    public void testMaxSizeEvictionWorks() throws Exception {
        int maxSize = 1000;
        int populationCount = 5000;
        String mapName = ClientEvictionTest.randomString();
        String cacheName = ClientEvictionTest.randomString();
        QueryCacheConfig cacheConfig = new QueryCacheConfig(cacheName);
        cacheConfig.getEvictionConfig().setSize(1000).setEvictionPolicy(EvictionPolicy.LFU).setMaximumSizePolicy(EvictionConfig.MaxSizePolicy.ENTRY_COUNT);
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.addQueryCacheConfig(mapName, cacheConfig);
        HazelcastInstance client = this.factory.newHazelcastClient(clientConfig);
        IMap map = client.getMap(mapName);
        int margin = 10;
        final CountDownLatch evictedCount = new CountDownLatch(4000 - margin);
        QueryCache cache = map.getQueryCache(cacheName, (Predicate)TruePredicate.INSTANCE, true);
        String listener = cache.addEntryListener((MapListener)new EntryEvictedListener(){

            public void entryEvicted(EntryEvent event) {
                evictedCount.countDown();
            }
        }, false);
        for (int i = 0; i < 5000; ++i) {
            map.put((Object)i, (Object)i);
        }
        ClientEvictionTest.assertOpenEventually((CountDownLatch)evictedCount);
        this.assertQueryCacheEvicted(1000, margin, (QueryCache<Integer, Integer>)cache);
        Assert.assertTrue((boolean)cache.removeEntryListener(listener));
    }

    private void assertQueryCacheEvicted(int maxSize, int margin, QueryCache<Integer, Integer> cache) {
        int size = cache.size();
        Assert.assertTrue((String)("cache size = " + size + ", should be smaller than max size = " + maxSize), (size < maxSize + margin ? 1 : 0) != 0);
    }
}

