/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.map.querycache;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.Config;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.config.PredicateConfig;
import com.hazelcast.config.QueryCacheConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.map.AbstractEntryEventTypesTest;
import com.hazelcast.map.QueryCache;
import com.hazelcast.map.impl.event.MapEventPublisherImpl;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.SqlPredicate;
import com.hazelcast.test.HazelcastParametersRunnerFactory;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.Callable;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Parameterized.UseParametersRunnerFactory(value=HazelcastParametersRunnerFactory.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientQueryCacheBasicTest
extends HazelcastTestSupport {
    private static final String TEST_MAP_NAME = "ClientQueryCacheBasicTestMap";
    private static final String QUERY_CACHE_NAME = "query-cache";
    private TestHazelcastFactory factory;
    private IMap<Integer, AbstractEntryEventTypesTest.Person> map;
    private QueryCache queryCache;
    private Predicate predicate = new SqlPredicate("age > 50");
    @Parameterized.Parameter
    public boolean includeValues;
    @Parameterized.Parameter(value=1)
    public boolean useQueryCacheNaturalFilteringStrategy;
    @Parameterized.Parameter(value=2)
    public boolean useNearCache;

    @Parameterized.Parameters(name="includeValues: {0}, useQueryCacheFilteringStrategy: {1}, nearCache: {2}")
    public static Collection<Object[]> parameters() {
        return Arrays.asList({false, false, false}, {false, false, true}, {false, true, false}, {false, true, true}, {true, false, false}, {true, false, true}, {true, true, false}, {true, true, true});
    }

    @Before
    public void setup() {
        Config config = new Config();
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.addQueryCacheConfig(TEST_MAP_NAME, new QueryCacheConfig(QUERY_CACHE_NAME).setPredicateConfig(new PredicateConfig(this.predicate)).setIncludeValue(this.includeValues));
        if (this.useNearCache) {
            clientConfig.addNearCacheConfig(new NearCacheConfig().setName(TEST_MAP_NAME).setInvalidateOnChange(true));
        }
        clientConfig.setProperty(MapEventPublisherImpl.LISTENER_WITH_PREDICATE_PRODUCES_NATURAL_EVENT_TYPES.getName(), Boolean.toString(this.useQueryCacheNaturalFilteringStrategy));
        this.factory = new TestHazelcastFactory();
        this.factory.newHazelcastInstance(config);
        HazelcastInstance client = this.factory.newHazelcastClient(clientConfig);
        this.map = client.getMap(TEST_MAP_NAME);
        this.queryCache = this.map.getQueryCache(QUERY_CACHE_NAME);
    }

    @After
    public void tearDown() {
        this.factory.shutdownAll();
    }

    @Test
    public void entryAdded_whenValueMatchesPredicate() {
        this.map.put((Object)1, (Object)new AbstractEntryEventTypesTest.Person("a", 75));
        ClientQueryCacheBasicTest.assertEqualsEventually((Callable)new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return ClientQueryCacheBasicTest.this.queryCache.size();
            }
        }, (Object)1);
    }

    @Test
    public void entryAdded_whenValueOutsidePredicate() {
        this.map.put((Object)1, (Object)new AbstractEntryEventTypesTest.Person("a", 25));
        ClientQueryCacheBasicTest.assertEqualsEventually((Callable)new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return ClientQueryCacheBasicTest.this.queryCache.size();
            }
        }, (Object)0);
    }

    @Test
    public void entryRemoved_whenValueMatchesPredicate() {
        this.map.put((Object)1, (Object)new AbstractEntryEventTypesTest.Person("a", 75));
        this.map.put((Object)2, (Object)new AbstractEntryEventTypesTest.Person("a", 95));
        this.map.remove((Object)1);
        ClientQueryCacheBasicTest.assertEqualsEventually((Callable)new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return ClientQueryCacheBasicTest.this.queryCache.size();
            }
        }, (Object)1);
    }

    @Test
    public void entryRemoved_whenValueOutsidePredicate() {
        this.map.put((Object)1, (Object)new AbstractEntryEventTypesTest.Person("a", 15));
        this.map.put((Object)2, (Object)new AbstractEntryEventTypesTest.Person("a", 25));
        this.map.remove((Object)1);
        ClientQueryCacheBasicTest.assertEqualsEventually((Callable)new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return ClientQueryCacheBasicTest.this.queryCache.size();
            }
        }, (Object)0);
    }

    @Test
    public void entryUpdated_whenOldValueOutside_newValueMatchesPredicate() {
        this.map.put((Object)1, (Object)new AbstractEntryEventTypesTest.Person("a", 15));
        this.map.replace((Object)1, (Object)new AbstractEntryEventTypesTest.Person("a", 85));
        ClientQueryCacheBasicTest.assertEqualsEventually((Callable)new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return ClientQueryCacheBasicTest.this.queryCache.size();
            }
        }, (Object)1);
    }

    @Test
    public void entryUpdated_whenOldValueOutside_newValueOutsidePredicate() {
        this.map.put((Object)1, (Object)new AbstractEntryEventTypesTest.Person("a", 15));
        this.map.replace((Object)1, (Object)new AbstractEntryEventTypesTest.Person("a", 25));
        ClientQueryCacheBasicTest.assertEqualsEventually((Callable)new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return ClientQueryCacheBasicTest.this.queryCache.size();
            }
        }, (Object)0);
    }

    @Test
    public void entryUpdated_whenOldValueMatches_newValueMatchesPredicate() {
        this.map.put((Object)1, (Object)new AbstractEntryEventTypesTest.Person("a", 55));
        this.map.replace((Object)1, (Object)new AbstractEntryEventTypesTest.Person("a", 56));
        ClientQueryCacheBasicTest.assertEqualsEventually((Callable)new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return ClientQueryCacheBasicTest.this.queryCache.size();
            }
        }, (Object)1);
    }

    @Test
    public void entryUpdated_whenOldValueMatches_newValueOutsidePredicate() {
        this.map.put((Object)1, (Object)new AbstractEntryEventTypesTest.Person("a", 55));
        this.map.replace((Object)1, (Object)new AbstractEntryEventTypesTest.Person("a", 15));
        ClientQueryCacheBasicTest.assertEqualsEventually((Callable)new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return ClientQueryCacheBasicTest.this.queryCache.size();
            }
        }, (Object)0);
    }
}

