/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.map.querycache;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.impl.querycache.ClientQueryCacheContext;
import com.hazelcast.client.proxy.ClientMapProxy;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.Config;
import com.hazelcast.config.PredicateConfig;
import com.hazelcast.config.QueryCacheConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.TruePredicate;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientQueryCacheClientContextTest
extends HazelcastTestSupport {
    private static final String MAP_NAME_1 = "ClientQueryCacheClientContextTest-1";
    private static final String MAP_NAME_2 = "ClientQueryCacheClientContextTest-2";
    private static final String MAP_NAME_3 = "ClientQueryCacheClientContextTest-3";
    private static final String QUERY_CACHE_1 = "query-cache-1";
    private static final String QUERY_CACHE_2 = "query-cache-2";
    private static final String QUERY_CACHE_3 = "query-cache-3";
    private TestHazelcastFactory factory;
    private IMap<String, String> map1;
    private IMap<String, String> map2;
    private IMap<String, String> map3;
    private Predicate predicate = TruePredicate.INSTANCE;

    @Before
    public void setup() {
        Config config = new Config();
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.addQueryCacheConfig(MAP_NAME_1, this.newQueryCacheConfig(QUERY_CACHE_1));
        clientConfig.addQueryCacheConfig(MAP_NAME_2, this.newQueryCacheConfig(QUERY_CACHE_2));
        clientConfig.addQueryCacheConfig(MAP_NAME_3, this.newQueryCacheConfig(QUERY_CACHE_3));
        this.factory = new TestHazelcastFactory();
        this.factory.newHazelcastInstance(config);
        HazelcastInstance client = this.factory.newHazelcastClient(clientConfig);
        this.map1 = client.getMap(MAP_NAME_1);
        this.map2 = client.getMap(MAP_NAME_2);
        this.map3 = client.getMap(MAP_NAME_3);
    }

    @After
    public void tearDown() throws Exception {
        this.factory.shutdownAll();
    }

    private QueryCacheConfig newQueryCacheConfig(String cacheName) {
        return new QueryCacheConfig(cacheName).setPredicateConfig(new PredicateConfig(this.predicate));
    }

    @Test
    public void same_context_object_is_used_by_all_query_caches() throws Exception {
        ClientQueryCacheContext instance1 = this.getQueryCacheContext(this.map1);
        ClientQueryCacheContext instance2 = this.getQueryCacheContext(this.map2);
        ClientQueryCacheContext instance3 = this.getQueryCacheContext(this.map3);
        Assert.assertEquals((Object)instance1, (Object)instance2);
        Assert.assertEquals((Object)instance2, (Object)instance3);
    }

    private ClientQueryCacheContext getQueryCacheContext(IMap map) {
        return ((ClientMapProxy)map).getQueryCacheContext();
    }
}

