/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.map.querycache;

import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.map.QueryCache;
import com.hazelcast.map.listener.EntryAddedListener;
import com.hazelcast.map.listener.EntryRemovedListener;
import com.hazelcast.map.listener.MapListener;
import com.hazelcast.mapreduce.helpers.Employee;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.SqlPredicate;
import com.hazelcast.query.TruePredicate;
import com.hazelcast.test.AssertTask;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.concurrent.CountDownLatch;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientQueryCacheListenerTest
extends HazelcastTestSupport {
    private static final Predicate<Integer, Employee> TRUE_PREDICATE = TruePredicate.INSTANCE;
    private static final Predicate<Integer, Integer> INTEGER_TRUE_PREDICATE = TruePredicate.INSTANCE;
    private static TestHazelcastFactory factory = new TestHazelcastFactory();

    @BeforeClass
    public static void setUp() {
        factory.newHazelcastInstance();
        factory.newHazelcastInstance();
        factory.newHazelcastInstance();
    }

    @AfterClass
    public static void tearDown() {
        factory.shutdownAll();
    }

    @Test
    public void shouldReceiveEvent_whenListening_withPredicate() {
        String mapName = ClientQueryCacheListenerTest.randomString();
        String cacheName = ClientQueryCacheListenerTest.randomString();
        HazelcastInstance instance = factory.newHazelcastClient();
        IMap map = instance.getMap(mapName);
        CountDownLatch numberOfCaughtEvents = new CountDownLatch(10);
        QueryCache cache = map.getQueryCache(cacheName, TRUE_PREDICATE, true);
        cache.addEntryListener((MapListener)new QueryCacheAdditionListener(numberOfCaughtEvents), (Predicate)new SqlPredicate("id > 100"), true);
        int putCount = 111;
        for (int i = 0; i < 111; ++i) {
            map.put((Object)i, (Object)new Employee(i));
        }
        ClientQueryCacheListenerTest.assertOpenEventually((CountDownLatch)numberOfCaughtEvents, (long)10L);
    }

    @Test
    public void shouldReceiveEvent_whenListeningKey_withPredicate() {
        String mapName = ClientQueryCacheListenerTest.randomString();
        String cacheName = ClientQueryCacheListenerTest.randomString();
        HazelcastInstance instance = factory.newHazelcastClient();
        IMap map = instance.getMap(mapName);
        CountDownLatch numberOfCaughtEvents = new CountDownLatch(1);
        QueryCache cache = map.getQueryCache(cacheName, TRUE_PREDICATE, true);
        int keyToListen = 109;
        cache.addEntryListener((MapListener)new QueryCacheAdditionListener(numberOfCaughtEvents), (Predicate)new SqlPredicate("id > 100"), (Object)keyToListen, true);
        int putCount = 111;
        for (int i = 0; i < putCount; ++i) {
            map.put((Object)i, (Object)new Employee(i));
        }
        ClientQueryCacheListenerTest.assertOpenEventually((CountDownLatch)numberOfCaughtEvents, (long)10L);
    }

    @Test
    public void shouldReceiveEvent_whenListeningKey_withMultipleListener() {
        int i;
        String mapName = ClientQueryCacheListenerTest.randomString();
        String cacheName = ClientQueryCacheListenerTest.randomString();
        HazelcastInstance instance = factory.newHazelcastClient();
        IMap map = instance.getMap(mapName);
        CountDownLatch additionCount = new CountDownLatch(2);
        CountDownLatch removalCount = new CountDownLatch(2);
        final QueryCache cache = map.getQueryCache(cacheName, TRUE_PREDICATE, true);
        int keyToListen = 109;
        cache.addEntryListener((MapListener)new QueryCacheAdditionListener(additionCount), (Predicate)new SqlPredicate("id > 100"), (Object)keyToListen, true);
        cache.addEntryListener((MapListener)new QueryCacheRemovalListener(removalCount), (Predicate)new SqlPredicate("id > 100"), (Object)keyToListen, true);
        int count = 111;
        for (i = 0; i < count; ++i) {
            map.put((Object)i, (Object)new Employee(i));
        }
        for (i = 0; i < count; ++i) {
            map.remove((Object)i);
        }
        for (i = 0; i < count; ++i) {
            map.put((Object)i, (Object)new Employee(i));
        }
        for (i = 0; i < count; ++i) {
            map.remove((Object)i);
        }
        AssertTask task = new AssertTask(){

            public void run() throws Exception {
                Assert.assertEquals((long)0L, (long)cache.size());
            }
        };
        ClientQueryCacheListenerTest.assertTrueEventually((AssertTask)task);
        ClientQueryCacheListenerTest.assertOpenEventually((String)(cache.size() + ""), (CountDownLatch)additionCount, (long)10L);
        ClientQueryCacheListenerTest.assertOpenEventually((String)(cache.size() + ""), (CountDownLatch)removalCount, (long)10L);
    }

    @Test
    public void shouldReceiveValue_whenIncludeValue_enabled() {
        boolean includeValue = true;
        this.testIncludeValue(includeValue);
    }

    @Test
    public void shouldNotReceiveValue_whenIncludeValue_disabled() {
        boolean includeValue = false;
        this.testIncludeValue(includeValue);
    }

    private void testIncludeValue(final boolean includeValue) {
        String mapName = ClientQueryCacheListenerTest.randomString();
        String cacheName = ClientQueryCacheListenerTest.randomString();
        HazelcastInstance client = factory.newHazelcastClient();
        IMap map = client.getMap(mapName);
        final QueryCache cache = map.getQueryCache(cacheName, INTEGER_TRUE_PREDICATE, true);
        final TestIncludeValueListener listener = new TestIncludeValueListener();
        cache.addEntryListener((MapListener)listener, includeValue);
        int putCount = 10;
        for (int i = 0; i < 10; ++i) {
            map.put((Object)i, (Object)i);
        }
        ClientQueryCacheListenerTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() throws Exception {
                Assert.assertEquals((long)10L, (long)cache.size());
                if (includeValue) {
                    Assert.assertTrue((String)"There should not be any null value", (boolean)listener.hasValue);
                } else {
                    Assert.assertFalse((String)"There should not be any non-null value", (boolean)listener.hasValue);
                }
            }
        });
    }

    private class QueryCacheRemovalListener
    implements EntryRemovedListener {
        private final CountDownLatch numberOfCaughtEvents;

        QueryCacheRemovalListener(CountDownLatch numberOfCaughtEvents) {
            this.numberOfCaughtEvents = numberOfCaughtEvents;
        }

        public void entryRemoved(EntryEvent event) {
            this.numberOfCaughtEvents.countDown();
        }
    }

    private class QueryCacheAdditionListener
    implements EntryAddedListener {
        private final CountDownLatch numberOfCaughtEvents;

        QueryCacheAdditionListener(CountDownLatch numberOfCaughtEvents) {
            this.numberOfCaughtEvents = numberOfCaughtEvents;
        }

        public void entryAdded(EntryEvent event) {
            this.numberOfCaughtEvents.countDown();
        }
    }

    private class TestIncludeValueListener
    implements EntryAddedListener {
        volatile boolean hasValue = false;

        private TestIncludeValueListener() {
        }

        public void entryAdded(EntryEvent event) {
            Object value = event.getValue();
            this.hasValue = value != null;
        }
    }
}

