/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.map.querycache;

import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.map.QueryCache;
import com.hazelcast.mapreduce.helpers.Employee;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.SqlPredicate;
import com.hazelcast.query.TruePredicate;
import com.hazelcast.test.AssertTask;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.Collection;
import java.util.Set;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientQueryCacheMethodsWithPredicateTest
extends HazelcastTestSupport {
    private static final Predicate<Integer, Employee> TRUE_PREDICATE = TruePredicate.INSTANCE;
    private static final int DEFAULT_TEST_TIMEOUT = 120;
    private static TestHazelcastFactory factory = new TestHazelcastFactory();

    @BeforeClass
    public static void setUp() {
        factory.newHazelcastInstance();
        factory.newHazelcastInstance();
        factory.newHazelcastInstance();
    }

    @AfterClass
    public static void tearDown() {
        factory.shutdownAll();
    }

    @Test
    public void test_keySet() {
        String mapName = ClientQueryCacheMethodsWithPredicateTest.randomString();
        String cacheName = ClientQueryCacheMethodsWithPredicateTest.randomString();
        HazelcastInstance instance = this.getInstance();
        IMap map = instance.getMap(mapName);
        int count = 111;
        for (int i = 0; i < count; ++i) {
            map.put((Object)i, (Object)new Employee(i));
        }
        QueryCache cache = map.getQueryCache(cacheName, TRUE_PREDICATE, true);
        cache.addIndex("id", true);
        for (int i = count; i < 2 * count; ++i) {
            map.put((Object)i, (Object)new Employee(i));
        }
        int equalsOrBiggerThan = 27;
        int expectedSize = 2 * count - equalsOrBiggerThan;
        this.assertKeySetSizeEventually(expectedSize, (Predicate)new SqlPredicate("id >= " + equalsOrBiggerThan), (QueryCache<Integer, Employee>)cache);
    }

    @Test
    public void test_keySet_whenIncludeValueFalse() {
        String mapName = ClientQueryCacheMethodsWithPredicateTest.randomString();
        String cacheName = ClientQueryCacheMethodsWithPredicateTest.randomString();
        HazelcastInstance instance = this.getInstance();
        IMap map = instance.getMap(mapName);
        int count = 111;
        for (int i = 0; i < count; ++i) {
            map.put((Object)i, (Object)new Employee(i));
        }
        QueryCache cache = map.getQueryCache(cacheName, TRUE_PREDICATE, false);
        cache.addIndex("__key", true);
        for (int i = count; i < 2 * count; ++i) {
            map.put((Object)i, (Object)new Employee(i));
        }
        int equalsOrBiggerThan = 27;
        int expectedSize = 2 * count - equalsOrBiggerThan;
        this.assertKeySetSizeEventually(expectedSize, (Predicate)new SqlPredicate("__key >= " + equalsOrBiggerThan), (QueryCache<Integer, Employee>)cache);
    }

    @Test
    public void test_keySet_onRemovedIndexes() {
        String mapName = ClientQueryCacheMethodsWithPredicateTest.randomString();
        String cacheName = ClientQueryCacheMethodsWithPredicateTest.randomString();
        HazelcastInstance instance = this.getInstance();
        IMap map = instance.getMap(mapName);
        int count = 111;
        for (int i = 0; i < count; ++i) {
            map.put((Object)i, (Object)new Employee(i));
        }
        QueryCache cache = map.getQueryCache(cacheName, TRUE_PREDICATE, true);
        cache.addIndex("id", true);
        for (int i = 17; i < count; ++i) {
            map.remove((Object)i);
        }
        int smallerThan = 17;
        int expectedSize = 17;
        this.assertKeySetSizeEventually(expectedSize, (Predicate)new SqlPredicate("id < " + smallerThan), (QueryCache<Integer, Employee>)cache);
    }

    @Test
    public void test_entrySet() {
        String mapName = ClientQueryCacheMethodsWithPredicateTest.randomString();
        String cacheName = ClientQueryCacheMethodsWithPredicateTest.randomString();
        HazelcastInstance instance = this.getInstance();
        IMap map = instance.getMap(mapName);
        int count = 111;
        for (int i = 0; i < 111; ++i) {
            map.put((Object)i, (Object)new Employee(i));
        }
        QueryCache cache = map.getQueryCache(cacheName, TRUE_PREDICATE, true);
        cache.addIndex("id", true);
        for (int i = 111; i < 222; ++i) {
            map.put((Object)i, (Object)new Employee(i));
        }
        int equalsOrBiggerThan = 27;
        int expectedSize = 222 - equalsOrBiggerThan;
        this.assertEntrySetSizeEventually(expectedSize, (Predicate)new SqlPredicate("id >= " + equalsOrBiggerThan), (QueryCache<Integer, Employee>)cache);
    }

    @Test
    public void test_entrySet_whenIncludeValueFalse() {
        String mapName = ClientQueryCacheMethodsWithPredicateTest.randomString();
        String cacheName = ClientQueryCacheMethodsWithPredicateTest.randomString();
        HazelcastInstance instance = this.getInstance();
        IMap map = instance.getMap(mapName);
        int count = 111;
        for (int i = 0; i < count; ++i) {
            map.put((Object)i, (Object)new Employee(i));
        }
        QueryCache cache = map.getQueryCache(cacheName, TRUE_PREDICATE, false);
        cache.addIndex("id", true);
        for (int i = 17; i < count; ++i) {
            map.remove((Object)i);
        }
        int smallerThan = 17;
        int expectedSize = 0;
        this.assertEntrySetSizeEventually(expectedSize, (Predicate)new SqlPredicate("id < " + smallerThan), (QueryCache<Integer, Employee>)cache);
    }

    @Test
    public void test_entrySet_withIndexedKeys_whenIncludeValueFalse() {
        String mapName = ClientQueryCacheMethodsWithPredicateTest.randomString();
        String cacheName = ClientQueryCacheMethodsWithPredicateTest.randomString();
        HazelcastInstance instance = this.getInstance();
        IMap map = instance.getMap(mapName);
        int count = 111;
        for (int i = 0; i < count; ++i) {
            map.put((Object)i, (Object)new Employee(i));
        }
        QueryCache cache = map.getQueryCache(cacheName, TRUE_PREDICATE, false);
        cache.addIndex("__key", true);
        for (int i = 17; i < count; ++i) {
            map.remove((Object)i);
        }
        int smallerThan = 17;
        int expectedSize = 17;
        this.assertEntrySetSizeEventually(expectedSize, (Predicate)new SqlPredicate("__key < " + smallerThan), (QueryCache<Integer, Employee>)cache);
    }

    @Test
    public void test_values() {
        String mapName = ClientQueryCacheMethodsWithPredicateTest.randomString();
        String cacheName = ClientQueryCacheMethodsWithPredicateTest.randomString();
        HazelcastInstance instance = this.getInstance();
        IMap map = instance.getMap(mapName);
        int count = 111;
        for (int i = 0; i < count; ++i) {
            map.put((Object)i, (Object)new Employee(i));
        }
        QueryCache cache = map.getQueryCache(cacheName, TRUE_PREDICATE, true);
        cache.addIndex("id", true);
        for (int i = count; i < 2 * count; ++i) {
            map.put((Object)i, (Object)new Employee(i));
        }
        int equalsOrBiggerThan = 27;
        int expectedSize = 2 * count - equalsOrBiggerThan;
        this.assertValuesSizeEventually(expectedSize, (Predicate)new SqlPredicate("id >= " + equalsOrBiggerThan), (QueryCache<Integer, Employee>)cache);
    }

    @Test
    public void test_values_withoutIndex() {
        String mapName = ClientQueryCacheMethodsWithPredicateTest.randomString();
        String cacheName = ClientQueryCacheMethodsWithPredicateTest.randomString();
        HazelcastInstance instance = this.getInstance();
        IMap map = instance.getMap(mapName);
        int count = 111;
        for (int i = 0; i < count; ++i) {
            map.put((Object)i, (Object)new Employee(i));
        }
        QueryCache cache = map.getQueryCache(cacheName, TRUE_PREDICATE, true);
        for (int i = 17; i < count; ++i) {
            map.remove((Object)i);
        }
        int smallerThan = 17;
        int expectedSize = 17;
        this.assertValuesSizeEventually(expectedSize, (Predicate)new SqlPredicate("__key < " + smallerThan), (QueryCache<Integer, Employee>)cache);
    }

    @Test
    public void test_values_withoutIndex_whenIncludeValueFalse() {
        String mapName = ClientQueryCacheMethodsWithPredicateTest.randomString();
        String cacheName = ClientQueryCacheMethodsWithPredicateTest.randomString();
        HazelcastInstance instance = this.getInstance();
        IMap map = instance.getMap(mapName);
        int count = 111;
        for (int i = 0; i < count; ++i) {
            map.put((Object)i, (Object)new Employee(i));
        }
        QueryCache cache = map.getQueryCache(cacheName, TRUE_PREDICATE, false);
        for (int i = 17; i < count; ++i) {
            map.remove((Object)i);
        }
        int smallerThan = 17;
        int expectedSize = 0;
        this.assertValuesSizeEventually(expectedSize, (Predicate)new SqlPredicate("__key < " + smallerThan), (QueryCache<Integer, Employee>)cache);
    }

    private void assertKeySetSizeEventually(final int expectedSize, final Predicate predicate, final QueryCache<Integer, Employee> cache) {
        AssertTask task = new AssertTask(){

            public void run() throws Exception {
                int size = cache.size();
                Set keySet = cache.keySet(predicate);
                Assert.assertEquals((String)("cache size = " + size), (long)expectedSize, (long)keySet.size());
            }
        };
        ClientQueryCacheMethodsWithPredicateTest.assertTrueEventually((AssertTask)task, (long)120L);
    }

    private void assertEntrySetSizeEventually(final int expectedSize, final Predicate predicate, final QueryCache<Integer, Employee> cache) {
        AssertTask task = new AssertTask(){

            public void run() throws Exception {
                int size = cache.size();
                Set entries = cache.entrySet(predicate);
                Assert.assertEquals((String)("cache size = " + size), (long)expectedSize, (long)entries.size());
            }
        };
        ClientQueryCacheMethodsWithPredicateTest.assertTrueEventually((AssertTask)task, (long)120L);
    }

    private void assertValuesSizeEventually(final int expectedSize, final Predicate predicate, final QueryCache<Integer, Employee> cache) {
        AssertTask task = new AssertTask(){

            public void run() throws Exception {
                int size = cache.size();
                Collection values = cache.values(predicate);
                Assert.assertEquals((String)("cache size = " + size), (long)expectedSize, (long)values.size());
            }
        };
        ClientQueryCacheMethodsWithPredicateTest.assertTrueEventually((AssertTask)task, (long)120L);
    }

    private HazelcastInstance getInstance() {
        return factory.newHazelcastClient();
    }
}

